/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.app;

import com.google.inject.Inject;
import haveno.common.ClockWatcher;
import haveno.common.persistence.PersistenceManager;
import haveno.core.account.sign.SignedWitnessService;
import haveno.core.account.witness.AccountAgeWitnessService;
import haveno.core.alert.PrivateNotificationManager;
import haveno.core.alert.PrivateNotificationPayload;
import haveno.core.app.WalletAppSetup;
import haveno.core.filter.FilterManager;
import haveno.core.notifications.MobileNotificationService;
import haveno.core.notifications.alerts.DisputeMsgEvents;
import haveno.core.notifications.alerts.MyOfferTakenEvents;
import haveno.core.notifications.alerts.TradeEvents;
import haveno.core.notifications.alerts.market.MarketAlerts;
import haveno.core.notifications.alerts.price.PriceAlert;
import haveno.core.offer.OpenOfferManager;
import haveno.core.offer.TriggerPriceService;
import haveno.core.payment.AmazonGiftCardAccount;
import haveno.core.payment.RevolutAccount;
import haveno.core.provider.price.PriceFeedService;
import haveno.core.support.dispute.arbitration.ArbitrationManager;
import haveno.core.support.dispute.arbitration.arbitrator.ArbitratorManager;
import haveno.core.support.dispute.mediation.MediationManager;
import haveno.core.support.dispute.mediation.mediator.MediatorManager;
import haveno.core.support.dispute.refund.RefundManager;
import haveno.core.support.dispute.refund.refundagent.RefundAgentManager;
import haveno.core.support.traderchat.TraderChatManager;
import haveno.core.trade.ClosedTradableManager;
import haveno.core.trade.TradeManager;
import haveno.core.trade.failed.FailedTradesManager;
import haveno.core.trade.statistics.TradeStatisticsManager;
import haveno.core.user.User;
import haveno.core.xmr.Balances;
import haveno.network.p2p.P2PService;
import haveno.network.p2p.mailbox.MailboxMessageService;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class DomainInitialisation {
    private final ClockWatcher clockWatcher;
    private final ArbitrationManager arbitrationManager;
    private final MediationManager mediationManager;
    private final RefundManager refundManager;
    private final TraderChatManager traderChatManager;
    private final TradeManager tradeManager;
    private final ClosedTradableManager closedTradableManager;
    private final FailedTradesManager failedTradesManager;
    private final OpenOfferManager openOfferManager;
    private final Balances balances;
    private final WalletAppSetup walletAppSetup;
    private final ArbitratorManager arbitratorManager;
    private final MediatorManager mediatorManager;
    private final RefundAgentManager refundAgentManager;
    private final PrivateNotificationManager privateNotificationManager;
    private final P2PService p2PService;
    private final TradeStatisticsManager tradeStatisticsManager;
    private final AccountAgeWitnessService accountAgeWitnessService;
    private final SignedWitnessService signedWitnessService;
    private final PriceFeedService priceFeedService;
    private final FilterManager filterManager;
    private final MobileNotificationService mobileNotificationService;
    private final MyOfferTakenEvents myOfferTakenEvents;
    private final TradeEvents tradeEvents;
    private final DisputeMsgEvents disputeMsgEvents;
    private final PriceAlert priceAlert;
    private final MarketAlerts marketAlerts;
    private final User user;
    private final TriggerPriceService triggerPriceService;
    private final MailboxMessageService mailboxMessageService;

    @Inject
    public DomainInitialisation(ClockWatcher clockWatcher, ArbitrationManager arbitrationManager, MediationManager mediationManager, RefundManager refundManager, TraderChatManager traderChatManager, TradeManager tradeManager, ClosedTradableManager closedTradableManager, FailedTradesManager failedTradesManager, OpenOfferManager openOfferManager, Balances balances, WalletAppSetup walletAppSetup, ArbitratorManager arbitratorManager, MediatorManager mediatorManager, RefundAgentManager refundAgentManager, PrivateNotificationManager privateNotificationManager, P2PService p2PService, TradeStatisticsManager tradeStatisticsManager, AccountAgeWitnessService accountAgeWitnessService, SignedWitnessService signedWitnessService, PriceFeedService priceFeedService, FilterManager filterManager, MobileNotificationService mobileNotificationService, MyOfferTakenEvents myOfferTakenEvents, TradeEvents tradeEvents, DisputeMsgEvents disputeMsgEvents, PriceAlert priceAlert, MarketAlerts marketAlerts, User user, TriggerPriceService triggerPriceService, MailboxMessageService mailboxMessageService) {
        this.clockWatcher = clockWatcher;
        this.arbitrationManager = arbitrationManager;
        this.mediationManager = mediationManager;
        this.refundManager = refundManager;
        this.traderChatManager = traderChatManager;
        this.tradeManager = tradeManager;
        this.closedTradableManager = closedTradableManager;
        this.failedTradesManager = failedTradesManager;
        this.openOfferManager = openOfferManager;
        this.balances = balances;
        this.walletAppSetup = walletAppSetup;
        this.arbitratorManager = arbitratorManager;
        this.mediatorManager = mediatorManager;
        this.refundAgentManager = refundAgentManager;
        this.privateNotificationManager = privateNotificationManager;
        this.p2PService = p2PService;
        this.tradeStatisticsManager = tradeStatisticsManager;
        this.accountAgeWitnessService = accountAgeWitnessService;
        this.signedWitnessService = signedWitnessService;
        this.priceFeedService = priceFeedService;
        this.filterManager = filterManager;
        this.mobileNotificationService = mobileNotificationService;
        this.myOfferTakenEvents = myOfferTakenEvents;
        this.tradeEvents = tradeEvents;
        this.disputeMsgEvents = disputeMsgEvents;
        this.priceAlert = priceAlert;
        this.marketAlerts = marketAlerts;
        this.user = user;
        this.triggerPriceService = triggerPriceService;
        this.mailboxMessageService = mailboxMessageService;
    }

    public void initDomainServices(Consumer<String> rejectedTxErrorMessageHandler, Consumer<PrivateNotificationPayload> displayPrivateNotificationHandler, Consumer<String> filterWarningHandler, Consumer<List<RevolutAccount>> revolutAccountsUpdateHandler, Consumer<List<AmazonGiftCardAccount>> amazonGiftCardAccountsUpdateHandler) {
        this.clockWatcher.start();
        PersistenceManager.onAllServicesInitialized();
        this.arbitratorManager.onAllServicesInitialized();
        this.mediatorManager.onAllServicesInitialized();
        this.refundAgentManager.onAllServicesInitialized();
        this.tradeManager.onAllServicesInitialized();
        this.arbitrationManager.onAllServicesInitialized();
        this.mediationManager.onAllServicesInitialized();
        this.refundManager.onAllServicesInitialized();
        this.traderChatManager.onAllServicesInitialized();
        this.closedTradableManager.onAllServicesInitialized();
        this.failedTradesManager.onAllServicesInitialized();
        this.filterManager.setFilterWarningHandler(filterWarningHandler);
        this.filterManager.onAllServicesInitialized();
        this.openOfferManager.onAllServicesInitialized();
        this.balances.onAllServicesInitialized();
        this.walletAppSetup.setRejectedTxErrorMessageHandler(rejectedTxErrorMessageHandler, this.openOfferManager, this.tradeManager);
        this.privateNotificationManager.privateNotificationProperty().addListener((observable2, oldValue, newValue) -> {
            if (displayPrivateNotificationHandler != null) {
                displayPrivateNotificationHandler.accept((PrivateNotificationPayload)newValue);
            }
        });
        this.p2PService.onAllServicesInitialized();
        this.tradeStatisticsManager.onAllServicesInitialized();
        this.accountAgeWitnessService.onAllServicesInitialized();
        this.signedWitnessService.onAllServicesInitialized();
        this.priceFeedService.setCurrencyCodeOnInit();
        this.priceFeedService.startRequestingPrices();
        this.mobileNotificationService.onAllServicesInitialized();
        this.myOfferTakenEvents.onAllServicesInitialized();
        this.tradeEvents.onAllServicesInitialized();
        this.disputeMsgEvents.onAllServicesInitialized();
        this.priceAlert.onAllServicesInitialized();
        this.marketAlerts.onAllServicesInitialized();
        this.triggerPriceService.onAllServicesInitialized();
        this.mailboxMessageService.onAllServicesInitialized();
        if (revolutAccountsUpdateHandler != null && this.user.getPaymentAccountsAsObservable() != null) {
            revolutAccountsUpdateHandler.accept(this.user.getPaymentAccountsAsObservable().stream().filter(paymentAccount -> paymentAccount instanceof RevolutAccount).map(paymentAccount -> (RevolutAccount)paymentAccount).filter(RevolutAccount::usernameNotSet).collect(Collectors.toList()));
        }
        if (amazonGiftCardAccountsUpdateHandler != null && this.user.getPaymentAccountsAsObservable() != null) {
            amazonGiftCardAccountsUpdateHandler.accept(this.user.getPaymentAccountsAsObservable().stream().filter(paymentAccount -> paymentAccount instanceof AmazonGiftCardAccount).map(paymentAccount -> (AmazonGiftCardAccount)paymentAccount).filter(AmazonGiftCardAccount::countryNotSet).collect(Collectors.toList()));
        }
    }
}

