/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.app;

import com.google.inject.Guice;
import com.google.inject.Injector;
import haveno.common.ThreadUtils;
import haveno.common.UserThread;
import haveno.common.app.AppModule;
import haveno.common.config.Config;
import haveno.common.config.ConfigException;
import haveno.common.config.HavenoHelpFormatter;
import haveno.common.crypto.IncorrectPasswordException;
import haveno.common.handlers.ResultHandler;
import haveno.common.persistence.PersistenceManager;
import haveno.common.proto.persistable.PersistedDataHost;
import haveno.common.setup.CommonSetup;
import haveno.common.setup.GracefulShutDownHandler;
import haveno.common.setup.UncaughtExceptionHandler;
import haveno.common.util.Utilities;
import haveno.core.api.AccountServiceListener;
import haveno.core.api.CoreAccountService;
import haveno.core.api.XmrConnectionService;
import haveno.core.app.AvoidStandbyModeService;
import haveno.core.app.ConsoleInput;
import haveno.core.app.HavenoSetup;
import haveno.core.offer.OfferBookService;
import haveno.core.offer.OpenOfferManager;
import haveno.core.provider.price.PriceFeedService;
import haveno.core.setup.CorePersistedDataHost;
import haveno.core.setup.CoreSetup;
import haveno.core.support.dispute.arbitration.arbitrator.ArbitratorManager;
import haveno.core.trade.TradeManager;
import haveno.core.trade.statistics.TradeStatisticsManager;
import haveno.core.xmr.setup.WalletsSetup;
import haveno.core.xmr.wallet.BtcWalletService;
import haveno.core.xmr.wallet.XmrWalletService;
import haveno.network.p2p.P2PService;
import java.io.Console;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HavenoExecutable
implements GracefulShutDownHandler,
HavenoSetup.HavenoSetupListener,
UncaughtExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(HavenoExecutable.class);
    public static final String DEFAULT_APP_NAME = "Haveno";
    public static final int EXIT_SUCCESS = 0;
    public static final int EXIT_FAILURE = 1;
    public static final int EXIT_RESTART = 2;
    private final String fullName;
    private final String scriptName;
    private final String appName;
    private final String version;
    protected CoreAccountService accountService;
    protected Injector injector;
    protected AppModule module;
    protected Config config;
    protected boolean isShutDownStarted;
    private boolean isReadOnly;
    private Thread keepRunningThread;
    private AtomicInteger keepRunningResult = new AtomicInteger(0);
    private Runnable shutdownCompletedHandler;

    public HavenoExecutable(String fullName, String scriptName, String appName, String version) {
        this.fullName = fullName;
        this.scriptName = scriptName;
        this.appName = appName;
        this.version = version;
    }

    public int execute(String[] args2) {
        try {
            this.config = new Config(this.appName, Utilities.getUserDataDir(), args2);
            if (this.config.helpRequested) {
                this.config.printHelp(System.out, new HavenoHelpFormatter(this.fullName, this.scriptName, this.version));
                System.exit(0);
            }
        }
        catch (ConfigException ex) {
            ex.printStackTrace();
            System.err.println("error: " + ex.getMessage());
            System.exit(1);
        }
        catch (Throwable ex) {
            System.err.println("fault: An unexpected error occurred. Please file a report at https://github.com/haveno-dex/haveno/issues");
            ex.printStackTrace(System.err);
            System.exit(1);
        }
        return this.doExecute();
    }

    protected int doExecute() {
        CommonSetup.setup(this.config, this);
        CoreSetup.setup(this.config);
        this.addCapabilities();
        this.launchApplication();
        return 0;
    }

    protected abstract void configUserThread();

    protected void addCapabilities() {
    }

    protected abstract void launchApplication();

    protected void onApplicationLaunched() {
        this.configUserThread();
        CommonSetup.printSystemLoadPeriodically(10);
        CommonSetup.setupUncaughtExceptionHandler(this);
        this.setupGuice();
        this.setupAvoidStandbyMode();
        this.isReadOnly = HavenoSetup.hasDowngraded();
        this.accountService = this.injector.getInstance(CoreAccountService.class);
        this.accountService.addListener(new AccountServiceListener(){

            @Override
            public void onAccountDeleted(Runnable onShutdown) {
                HavenoExecutable.this.shutDownNoPersist(onShutdown, true);
            }

            @Override
            public void onAccountRestored(Runnable onShutdown) {
                HavenoExecutable.this.shutDownNoPersist(onShutdown, true);
            }
        });
        CompletableFuture<Boolean> loginFuture = this.loginAccount();
        loginFuture.whenComplete((result, throwable) -> {
            if (throwable != null) {
                log.error("Error logging in to account", (Throwable)throwable);
                this.shutDownNoPersist(null, false);
                return;
            }
            try {
                if (!this.isReadOnly && ((Boolean)loginFuture.get()).booleanValue()) {
                    this.readAllPersisted(this::startApplication);
                } else {
                    log.warn("Running application in readonly mode");
                    this.startApplication();
                }
            }
            catch (InterruptedException | ExecutionException e) {
                log.error("An error occurred: {}\n", (Object)e.getMessage(), (Object)e);
            }
        });
    }

    protected void shutDownNoPersist(Runnable onShutdown, boolean restart) {
        this.isReadOnly = true;
        if (restart) {
            this.shutdownCompletedHandler = onShutdown;
            this.keepRunningResult.set(2);
            this.keepRunningThread.interrupt();
        } else {
            this.gracefulShutDown(() -> {
                log.info("Shutdown without persisting");
                if (onShutdown != null) {
                    onShutdown.run();
                }
            });
        }
    }

    protected CompletableFuture<Boolean> loginAccount() {
        CompletableFuture<Boolean> result = new CompletableFuture<Boolean>();
        if (this.accountService.accountExists()) {
            log.info("Account already exists, attempting to open");
            try {
                this.accountService.openAccount(null);
                result.complete(this.accountService.isAccountOpen());
            }
            catch (IncorrectPasswordException ipe) {
                log.info("Account password protected, password required");
                result.complete(false);
            }
        } else if (!this.config.passwordRequired) {
            log.info("Creating Haveno account with null password");
            this.accountService.createAccount(null);
            result.complete(this.accountService.isAccountOpen());
        } else {
            log.info("Account does not exist and password is required");
            result.complete(false);
        }
        return result;
    }

    protected void setupGuice() {
        this.module = this.getModule();
        this.injector = this.getInjector();
        this.applyInjector();
    }

    protected abstract AppModule getModule();

    protected Injector getInjector() {
        return Guice.createInjector(this.module);
    }

    protected void applyInjector() {
    }

    protected void readAllPersisted(Runnable completeHandler) {
        this.readAllPersisted(null, completeHandler);
    }

    protected void readAllPersisted(@Nullable List<PersistedDataHost> additionalHosts, Runnable completeHandler) {
        List<PersistedDataHost> hosts = CorePersistedDataHost.getPersistedDataHosts(this.injector);
        if (additionalHosts != null) {
            hosts.addAll(additionalHosts);
        }
        AtomicInteger remaining = new AtomicInteger(hosts.size());
        hosts.forEach(host -> host.readPersisted(() -> {
            if (remaining.decrementAndGet() == 0) {
                UserThread.execute(completeHandler);
            }
        }));
    }

    protected void setupAvoidStandbyMode() {
    }

    protected abstract void startApplication();

    protected void onApplicationStarted() {
        this.runHavenoSetup();
    }

    protected void runHavenoSetup() {
        HavenoSetup havenoSetup = this.injector.getInstance(HavenoSetup.class);
        havenoSetup.addHavenoSetupListener(this);
        havenoSetup.start();
    }

    @Override
    public abstract void onSetupComplete();

    @Override
    public void gracefulShutDown(ResultHandler resultHandler) {
        this.gracefulShutDown(resultHandler, true);
    }

    @Override
    public void gracefulShutDown(ResultHandler onShutdown, boolean systemExit) {
        log.info("Starting graceful shut down of {}", (Object)this.getClass().getSimpleName());
        if (this.isShutDownStarted) {
            log.info("Ignoring call to gracefulShutDown, already started");
            return;
        }
        this.isShutDownStarted = true;
        ResultHandler resultHandler = this.shutdownCompletedHandler != null ? () -> {
            this.shutdownCompletedHandler.run();
            onShutdown.handleResult();
        } : onShutdown;
        if (this.injector == null) {
            log.info("Shut down called before injector was created");
            resultHandler.handleResult();
            System.exit(0);
        }
        try {
            HashSet<Runnable> tasks = new HashSet<Runnable>();
            tasks.add(() -> this.injector.getInstance(TradeManager.class).onShutDownStarted());
            tasks.add(() -> this.injector.getInstance(XmrWalletService.class).onShutDownStarted());
            tasks.add(() -> this.injector.getInstance(XmrConnectionService.class).onShutDownStarted());
            try {
                ThreadUtils.awaitTasks(tasks, tasks.size(), 90000L);
            }
            catch (Exception e) {
                log.error("Failed to notify all services to prepare for shutdown: {}\n", (Object)e.getMessage(), (Object)e);
            }
            this.injector.getInstance(PriceFeedService.class).shutDown();
            this.injector.getInstance(ArbitratorManager.class).shutDown();
            this.injector.getInstance(TradeStatisticsManager.class).shutDown();
            this.injector.getInstance(AvoidStandbyModeService.class).shutDown();
            log.info("Shutting down OpenOfferManager");
            this.injector.getInstance(OpenOfferManager.class).shutDown(() -> {
                this.injector.getInstance(WalletsSetup.class).shutDownComplete.addListener((ov, o, n) -> {
                    log.info("Shutting down P2P service");
                    this.injector.getInstance(P2PService.class).shutDown(() -> {
                        log.info("Graceful shutdown completed. Exiting now.");
                        this.module.close(this.injector);
                        this.completeShutdown(resultHandler, 0, systemExit);
                    });
                });
                log.info("Shutting down trade and wallet services");
                this.injector.getInstance(OfferBookService.class).shutDown();
                this.injector.getInstance(TradeManager.class).shutDown();
                this.injector.getInstance(BtcWalletService.class).shutDown();
                this.injector.getInstance(XmrWalletService.class).shutDown();
                this.injector.getInstance(XmrConnectionService.class).shutDown();
                this.injector.getInstance(WalletsSetup.class).shutDown();
            });
        }
        catch (Throwable t2) {
            log.error("App shutdown failed with exception: {}\n", (Object)t2.getMessage(), (Object)t2);
            this.completeShutdown(resultHandler, 1, systemExit);
        }
    }

    private void completeShutdown(ResultHandler resultHandler, int exitCode, boolean systemExit) {
        if (!this.isReadOnly) {
            PersistenceManager.flushAllDataToDiskAtShutdown(() -> {
                log.info("Graceful shutdown flushed persistence. Exiting now.");
                resultHandler.handleResult();
                if (systemExit) {
                    UserThread.runAfter(() -> System.exit(exitCode), 1L);
                }
            });
        } else {
            resultHandler.handleResult();
            if (systemExit) {
                UserThread.runAfter(() -> System.exit(exitCode), 1L);
            }
        }
    }

    @Override
    public void handleUncaughtException(Throwable throwable, boolean doShutDown) {
        log.error(throwable.toString());
        if (doShutDown) {
            this.gracefulShutDown(() -> log.info("gracefulShutDown complete"));
        }
    }

    protected int keepRunning() {
        this.keepRunningThread = new Thread(() -> {
            ConsoleInput reader = new ConsoleInput(Integer.MAX_VALUE, Integer.MAX_VALUE, TimeUnit.MILLISECONDS);
            while (true) {
                Console console = System.console();
                try {
                    if (console == null) {
                        Thread.sleep(Long.MAX_VALUE);
                        continue;
                    }
                    String cmd = reader.readLine();
                    if ("exit".equals(cmd)) {
                        this.keepRunningResult.set(0);
                        break;
                    }
                    if ("restart".equals(cmd)) {
                        this.keepRunningResult.set(2);
                        break;
                    }
                    if ("help".equals(cmd)) {
                        System.out.println("Commands: restart, exit, help");
                        continue;
                    }
                    System.out.println("Unknown command, use: restart, exit, help");
                }
                catch (InterruptedException e) {
                    break;
                }
            }
        });
        this.keepRunningThread.start();
        try {
            this.keepRunningThread.join();
        }
        catch (InterruptedException ie) {
            System.out.println(ie);
        }
        return this.keepRunningResult.get();
    }

    public boolean isShutDownStarted() {
        return this.isShutDownStarted;
    }
}

