/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.app;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import haveno.common.UserThread;
import haveno.core.api.XmrConnectionService;
import haveno.core.locale.Res;
import haveno.core.provider.price.PriceFeedService;
import haveno.core.user.Preferences;
import haveno.network.p2p.P2PService;
import haveno.network.p2p.P2PServiceListener;
import haveno.network.p2p.network.CloseConnectionReason;
import haveno.network.p2p.network.Connection;
import haveno.network.p2p.network.ConnectionListener;
import java.util.function.Consumer;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javax.annotation.Nullable;
import org.fxmisc.easybind.EasyBind;
import org.fxmisc.easybind.monadic.MonadicBinding;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class P2PNetworkSetup {
    private static final Logger log = LoggerFactory.getLogger(P2PNetworkSetup.class);
    private final PriceFeedService priceFeedService;
    private final P2PService p2PService;
    private final XmrConnectionService xmrConnectionService;
    private final Preferences preferences;
    private MonadicBinding<String> p2PNetworkInfoBinding;
    final StringProperty p2PNetworkInfo = new SimpleStringProperty();
    final StringProperty p2PNetworkIconId = new SimpleStringProperty();
    final StringProperty p2PNetworkStatusIconId = new SimpleStringProperty();
    final BooleanProperty splashP2PNetworkAnimationVisible = new SimpleBooleanProperty(true);
    final StringProperty p2pNetworkLabelId = new SimpleStringProperty("footer-pane");
    final StringProperty p2pNetworkWarnMsg = new SimpleStringProperty();
    final BooleanProperty updatedDataReceived = new SimpleBooleanProperty();
    final BooleanProperty p2pNetworkFailed = new SimpleBooleanProperty();

    @Inject
    public P2PNetworkSetup(PriceFeedService priceFeedService, P2PService p2PService, XmrConnectionService xmrConnectionService, Preferences preferences) {
        this.priceFeedService = priceFeedService;
        this.p2PService = p2PService;
        this.xmrConnectionService = xmrConnectionService;
        this.preferences = preferences;
    }

    BooleanProperty init(final Runnable onReadyHandler, final @Nullable Consumer<Boolean> displayTorNetworkSettingsHandler) {
        final SimpleStringProperty bootstrapState = new SimpleStringProperty();
        final SimpleStringProperty bootstrapWarning = new SimpleStringProperty();
        final SimpleBooleanProperty hiddenServicePublished = new SimpleBooleanProperty();
        final SimpleBooleanProperty initialP2PNetworkDataReceived = new SimpleBooleanProperty();
        this.p2PNetworkInfoBinding = EasyBind.combine(bootstrapState, bootstrapWarning, this.p2PService.getNumConnectedPeers(), this.xmrConnectionService.numConnectionsProperty(), hiddenServicePublished, initialP2PNetworkDataReceived, (state, warning, numP2pPeers, numXmrPeers, hiddenService, dataReceived) -> {
            Object result;
            int p2pPeers = (Integer)numP2pPeers;
            if (warning != null && p2pPeers == 0) {
                result = warning;
            } else {
                String p2pInfo = (String)((Integer)numXmrPeers > 0 ? Res.get("mainView.footer.xmrPeers", numXmrPeers) + " / " : "") + Res.get("mainView.footer.p2pPeers", numP2pPeers);
                result = dataReceived != false && hiddenService != false ? p2pInfo : (p2pPeers == 0 ? state : state + " / " + p2pInfo);
            }
            return result;
        });
        this.p2PNetworkInfoBinding.subscribe((observable2, oldValue, newValue) -> UserThread.execute(() -> this.p2PNetworkInfo.set(newValue)));
        bootstrapState.set(Res.get("mainView.bootstrapState.connectionToTorNetwork"));
        this.p2PService.getNetworkNode().addConnectionListener(new ConnectionListener(){

            @Override
            public void onConnection(Connection connection) {
                P2PNetworkSetup.this.updateNetworkStatusIndicator();
            }

            @Override
            public void onDisconnect(CloseConnectionReason closeConnectionReason, Connection connection) {
                P2PNetworkSetup.this.updateNetworkStatusIndicator();
                if (connection.getConnectionState().isSeedNode() && closeConnectionReason == CloseConnectionReason.RULE_VIOLATION) {
                    log.warn("RULE_VIOLATION onDisconnect closeConnectionReason={}, connection={}", (Object)closeConnectionReason, (Object)connection);
                }
            }
        });
        final SimpleBooleanProperty p2pNetworkInitialized = new SimpleBooleanProperty();
        this.p2PService.start(new P2PServiceListener(){

            @Override
            public void onTorNodeReady() {
                log.debug("onTorNodeReady");
                bootstrapState.set(Res.get("mainView.bootstrapState.torNodeCreated"));
                P2PNetworkSetup.this.p2PNetworkIconId.set("image-connection-tor");
                P2PNetworkSetup.this.priceFeedService.setCurrencyCodeOnInit();
                P2PNetworkSetup.this.priceFeedService.requestPrices();
                onReadyHandler.run();
            }

            @Override
            public void onHiddenServicePublished() {
                log.debug("onHiddenServicePublished");
                hiddenServicePublished.set(true);
                bootstrapState.set(Res.get("mainView.bootstrapState.hiddenServicePublished"));
            }

            @Override
            public void onDataReceived() {
                log.debug("onRequestingDataCompleted");
                initialP2PNetworkDataReceived.set(true);
                bootstrapState.set(Res.get("mainView.bootstrapState.initialDataReceived"));
                P2PNetworkSetup.this.splashP2PNetworkAnimationVisible.set(false);
                p2pNetworkInitialized.set(true);
            }

            @Override
            public void onNoSeedNodeAvailable() {
                log.warn("onNoSeedNodeAvailable");
                if (P2PNetworkSetup.this.p2PService.getNumConnectedPeers().get() == 0) {
                    bootstrapWarning.set(Res.get("mainView.bootstrapWarning.noSeedNodesAvailable"));
                } else {
                    bootstrapWarning.set(null);
                }
                P2PNetworkSetup.this.splashP2PNetworkAnimationVisible.set(false);
                p2pNetworkInitialized.set(true);
            }

            @Override
            public void onNoPeersAvailable() {
                log.warn("onNoPeersAvailable");
                if (P2PNetworkSetup.this.p2PService.getNumConnectedPeers().get() == 0) {
                    P2PNetworkSetup.this.p2pNetworkWarnMsg.set(Res.get("mainView.p2pNetworkWarnMsg.noNodesAvailable"));
                    bootstrapWarning.set(Res.get("mainView.bootstrapWarning.noNodesAvailable"));
                    P2PNetworkSetup.this.p2pNetworkLabelId.set("splash-error-state-msg");
                } else {
                    bootstrapWarning.set(null);
                    P2PNetworkSetup.this.p2pNetworkLabelId.set("footer-pane");
                }
                P2PNetworkSetup.this.splashP2PNetworkAnimationVisible.set(false);
                p2pNetworkInitialized.set(true);
            }

            @Override
            public void onUpdatedDataReceived() {
                log.debug("onUpdatedDataReceived");
                P2PNetworkSetup.this.splashP2PNetworkAnimationVisible.set(false);
                P2PNetworkSetup.this.updatedDataReceived.set(true);
            }

            @Override
            public void onSetupFailed(Throwable throwable) {
                log.error("onSetupFailed");
                P2PNetworkSetup.this.p2pNetworkWarnMsg.set(Res.get("mainView.p2pNetworkWarnMsg.connectionToP2PFailed", throwable.getMessage()));
                P2PNetworkSetup.this.splashP2PNetworkAnimationVisible.set(false);
                bootstrapWarning.set(Res.get("mainView.bootstrapWarning.bootstrappingToP2PFailed"));
                P2PNetworkSetup.this.p2pNetworkLabelId.set("splash-error-state-msg");
                P2PNetworkSetup.this.p2pNetworkFailed.set(true);
            }

            @Override
            public void onRequestCustomBridges() {
                if (displayTorNetworkSettingsHandler != null) {
                    displayTorNetworkSettingsHandler.accept(true);
                }
            }
        });
        return p2pNetworkInitialized;
    }

    public void setSplashP2PNetworkAnimationVisible(boolean value) {
        this.splashP2PNetworkAnimationVisible.set(value);
    }

    private void updateNetworkStatusIndicator() {
        if (this.p2PService.getNetworkNode().getInboundConnectionCount() > 0) {
            this.p2PNetworkStatusIconId.set("image-green_circle");
        } else if (this.p2PService.getNetworkNode().getOutboundConnectionCount() > 0) {
            this.p2PNetworkStatusIconId.set("image-yellow_circle");
        } else {
            this.p2PNetworkStatusIconId.set("image-alert-round");
        }
    }

    public StringProperty getP2PNetworkInfo() {
        return this.p2PNetworkInfo;
    }

    public StringProperty getP2PNetworkIconId() {
        return this.p2PNetworkIconId;
    }

    public StringProperty getP2PNetworkStatusIconId() {
        return this.p2PNetworkStatusIconId;
    }

    public BooleanProperty getSplashP2PNetworkAnimationVisible() {
        return this.splashP2PNetworkAnimationVisible;
    }

    public StringProperty getP2pNetworkLabelId() {
        return this.p2pNetworkLabelId;
    }

    public StringProperty getP2pNetworkWarnMsg() {
        return this.p2pNetworkWarnMsg;
    }

    public BooleanProperty getUpdatedDataReceived() {
        return this.updatedDataReceived;
    }

    public BooleanProperty getP2pNetworkFailed() {
        return this.p2pNetworkFailed;
    }
}

