/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.app;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import haveno.common.UserThread;
import haveno.common.config.Config;
import haveno.core.api.CoreContext;
import haveno.core.api.XmrConnectionService;
import haveno.core.locale.Res;
import haveno.core.offer.OpenOfferManager;
import haveno.core.trade.TradeManager;
import haveno.core.user.Preferences;
import haveno.core.util.FormattingUtils;
import haveno.core.xmr.exceptions.InvalidHostException;
import haveno.core.xmr.exceptions.RejectedTxException;
import haveno.core.xmr.setup.WalletsSetup;
import haveno.core.xmr.wallet.WalletsManager;
import haveno.core.xmr.wallet.XmrWalletService;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javax.annotation.Nullable;
import monero.common.MoneroUtils;
import org.bitcoinj.core.RejectMessage;
import org.bitcoinj.store.BlockStoreException;
import org.bitcoinj.store.ChainFileLockedException;
import org.fxmisc.easybind.EasyBind;
import org.fxmisc.easybind.monadic.MonadicBinding;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class WalletAppSetup {
    private static final Logger log = LoggerFactory.getLogger(WalletAppSetup.class);
    private final CoreContext coreContext;
    private final WalletsManager walletsManager;
    private final WalletsSetup walletsSetup;
    private final XmrConnectionService xmrConnectionService;
    private final XmrWalletService xmrWalletService;
    private final Config config;
    private final Preferences preferences;
    private MonadicBinding<String> xmrInfoBinding;
    private final DoubleProperty xmrDaemonSyncProgress = new SimpleDoubleProperty(-1.0);
    private final DoubleProperty xmrWalletSyncProgress = new SimpleDoubleProperty(-1.0);
    private final StringProperty xmrSplashSyncIconId = new SimpleStringProperty();
    private final StringProperty xmrInfo = new SimpleStringProperty(Res.get("mainView.footer.xmrInfo.initializing"));
    private final ObjectProperty<RejectedTxException> rejectedTxException = new SimpleObjectProperty<RejectedTxException>();
    private final ObjectProperty<Preferences.UseTorForXmr> useTorForXmr = new SimpleObjectProperty<Preferences.UseTorForXmr>();

    @Inject
    public WalletAppSetup(CoreContext coreContext, WalletsManager walletsManager, WalletsSetup walletsSetup, XmrConnectionService xmrConnectionService, XmrWalletService xmrWalletService, Config config, Preferences preferences) {
        this.coreContext = coreContext;
        this.walletsManager = walletsManager;
        this.walletsSetup = walletsSetup;
        this.xmrConnectionService = xmrConnectionService;
        this.xmrWalletService = xmrWalletService;
        this.config = config;
        this.preferences = preferences;
        this.useTorForXmr.set(preferences.getUseTorForXmr());
    }

    void init(@Nullable Consumer<String> chainFileLockedExceptionHandler, @Nullable Runnable showFirstPopupIfResyncSPVRequestedHandler, @Nullable Runnable showPopupIfInvalidXmrConfigHandler, Runnable downloadCompleteHandler, Runnable walletInitializedHandler) {
        log.info("Initialize WalletAppSetup with monero-java v{}", (Object)MoneroUtils.getVersion());
        SimpleObjectProperty walletServiceException = new SimpleObjectProperty();
        this.xmrInfoBinding = EasyBind.combine(this.xmrConnectionService.numUpdatesProperty(), this.xmrWalletService.downloadPercentageProperty(), this.xmrWalletService.walletHeightProperty(), walletServiceException, this.xmrConnectionService.getConnectionServiceErrorMsg(), (numConnectionUpdates, walletDownloadPercentage, walletHeight, exception, errorMsg) -> {
            String result;
            if (exception == null && errorMsg == null) {
                String chainHeightAsString;
                double chainDownloadPercentageD = this.xmrConnectionService.downloadPercentageProperty().doubleValue();
                Long bestChainHeight = this.xmrConnectionService.chainHeightProperty().get();
                String string = chainHeightAsString = bestChainHeight != null && bestChainHeight > 0L ? String.valueOf(bestChainHeight) : "";
                if (chainDownloadPercentageD < 1.0) {
                    this.xmrDaemonSyncProgress.set(chainDownloadPercentageD);
                    if (chainDownloadPercentageD > 0.0) {
                        String synchronizingWith = Res.get("mainView.footer.xmrInfo.synchronizingWith", this.getXmrDaemonNetworkAsString(), chainHeightAsString, FormattingUtils.formatToRoundedPercentWithSymbol(chainDownloadPercentageD));
                        result = Res.get("mainView.footer.xmrInfo", synchronizingWith, "");
                    } else {
                        result = Res.get("mainView.footer.xmrInfo", Res.get("mainView.footer.xmrInfo.connectingTo"), this.getXmrDaemonNetworkAsString());
                    }
                } else {
                    String walletHeightAsString;
                    double walletDownloadPercentageD = (Double)walletDownloadPercentage;
                    this.xmrWalletSyncProgress.set(walletDownloadPercentageD);
                    Long bestWalletHeight = walletHeight == null ? null : (Long)walletHeight;
                    String string2 = walletHeightAsString = bestWalletHeight != null && bestWalletHeight > 0L ? String.valueOf(bestWalletHeight) : "";
                    if (walletDownloadPercentageD == 1.0) {
                        String synchronizedWith = Res.get("mainView.footer.xmrInfo.syncedWith", this.getXmrWalletNetworkAsString(), walletHeightAsString);
                        String feeInfo = "";
                        result = Res.get("mainView.footer.xmrInfo", synchronizedWith, feeInfo);
                        this.getXmrSplashSyncIconId().set("image-connection-synced");
                        downloadCompleteHandler.run();
                    } else if (walletDownloadPercentageD >= 0.0) {
                        String synchronizingWith = Res.get("mainView.footer.xmrInfo.synchronizingWalletWith", this.getXmrWalletNetworkAsString(), walletHeightAsString, FormattingUtils.formatToRoundedPercentWithSymbol(walletDownloadPercentageD));
                        result = Res.get("mainView.footer.xmrInfo", synchronizingWith, "");
                        this.getXmrSplashSyncIconId().set("");
                    } else {
                        String synchronizedWith = Res.get("mainView.footer.xmrInfo.connectedTo", this.getXmrDaemonNetworkAsString(), chainHeightAsString);
                        String feeInfo = "";
                        result = Res.get("mainView.footer.xmrInfo", synchronizedWith, feeInfo);
                        this.getXmrSplashSyncIconId().set("image-connection-synced");
                    }
                }
            } else {
                result = Res.get("mainView.footer.xmrInfo", Res.get("mainView.footer.xmrInfo.connectionFailed"), this.getXmrDaemonNetworkAsString());
                if (exception != null) {
                    if (exception instanceof TimeoutException) {
                        this.xmrConnectionService.getConnectionServiceErrorMsg().set(Res.get("mainView.walletServiceErrorMsg.timeout"));
                    } else if (exception.getCause() instanceof BlockStoreException) {
                        if (exception.getCause().getCause() instanceof ChainFileLockedException && chainFileLockedExceptionHandler != null) {
                            chainFileLockedExceptionHandler.accept(Res.get("popup.warning.startupFailed.twoInstances"));
                        }
                    } else if (exception instanceof RejectedTxException) {
                        this.rejectedTxException.set((RejectedTxException)exception);
                        this.xmrConnectionService.getConnectionServiceErrorMsg().set(Res.get("mainView.walletServiceErrorMsg.rejectedTxException", exception.getMessage()));
                    } else {
                        this.xmrConnectionService.getConnectionServiceErrorMsg().set(Res.get("mainView.walletServiceErrorMsg.connectionError", exception.getMessage()));
                    }
                }
            }
            return result;
        });
        this.xmrInfoBinding.subscribe((observable2, oldValue, newValue) -> UserThread.execute(() -> this.xmrInfo.set(newValue)));
        this.walletsSetup.initialize(null, () -> walletInitializedHandler.run(), exception -> {
            if (exception instanceof InvalidHostException && showPopupIfInvalidXmrConfigHandler != null) {
                showPopupIfInvalidXmrConfigHandler.run();
            } else {
                walletServiceException.set(exception);
            }
        });
    }

    void setRejectedTxErrorMessageHandler(Consumer<String> rejectedTxErrorMessageHandler, OpenOfferManager openOfferManager, TradeManager tradeManager) {
        this.getRejectedTxException().addListener((observable2, oldValue, newValue) -> {
            if (newValue == null || newValue.getTxId() == null) {
                return;
            }
            RejectMessage rejectMessage = newValue.getRejectMessage();
            log.warn("We received reject message: {}", (Object)rejectMessage);
            switch (rejectMessage.getReasonCode()) {
                case OBSOLETE: 
                case DUPLICATE: 
                case NONSTANDARD: 
                case CHECKPOINT: 
                case OTHER: {
                    log.warn("We ignore that reject message as it is likely not critical.");
                    break;
                }
                case MALFORMED: 
                case INVALID: 
                case DUST: 
                case INSUFFICIENTFEE: {
                    log.warn("We handle that reject message as it is likely critical.");
                    UserThread.runAfter(() -> {
                        String txId = newValue.getTxId();
                        tradeManager.getObservableList().stream().filter(trade -> trade.getOffer() != null).forEach(trade -> {
                            String details = null;
                            if (txId.equals(trade.getMaker().getDepositTxHash())) {
                                details = Res.get("popup.warning.trade.txRejected.deposit");
                            }
                            if (txId.equals(trade.getTaker().getDepositTxHash())) {
                                details = Res.get("popup.warning.trade.txRejected.deposit");
                            }
                            if (details != null) {
                                String finalDetails = details;
                                UserThread.runAfter(() -> {
                                    trade.setErrorMessage(newValue.getMessage());
                                    tradeManager.requestPersistence();
                                    if (rejectedTxErrorMessageHandler != null) {
                                        rejectedTxErrorMessageHandler.accept(Res.get("popup.warning.trade.txRejected", finalDetails, trade.getShortId(), txId));
                                    }
                                }, 1L);
                            }
                        });
                    }, 3L);
                }
            }
        });
    }

    private String getXmrDaemonNetworkAsString() {
        Object postFix = this.xmrConnectionService.isConnectionLocalHost() ? " " + Res.get("mainView.footer.localhostMoneroNode") : (this.xmrConnectionService.isProxyApplied() ? " " + Res.get("mainView.footer.usingTor") : "");
        return Res.get(this.config.baseCurrencyNetwork.name()) + (String)postFix;
    }

    private String getXmrWalletNetworkAsString() {
        String postFix = this.xmrConnectionService.isConnectionLocalHost() ? " " + Res.get("mainView.footer.localhostMoneroNode") : (this.xmrWalletService.isProxyApplied() ? " " + Res.get("mainView.footer.usingTor") : " " + Res.get("mainView.footer.clearnet"));
        return Res.get(this.config.baseCurrencyNetwork.name()) + postFix;
    }

    public DoubleProperty getXmrDaemonSyncProgress() {
        return this.xmrDaemonSyncProgress;
    }

    public DoubleProperty getXmrWalletSyncProgress() {
        return this.xmrWalletSyncProgress;
    }

    public StringProperty getXmrSplashSyncIconId() {
        return this.xmrSplashSyncIconId;
    }

    public StringProperty getXmrInfo() {
        return this.xmrInfo;
    }

    public ObjectProperty<RejectedTxException> getRejectedTxException() {
        return this.rejectedTxException;
    }

    public ObjectProperty<Preferences.UseTorForXmr> getUseTorForXmr() {
        return this.useTorForXmr;
    }
}

