/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.app.misc;

import com.google.inject.Inject;
import haveno.common.config.Config;
import haveno.common.persistence.PersistenceManager;
import haveno.common.proto.persistable.PersistedDataHost;
import haveno.core.account.sign.SignedWitnessService;
import haveno.core.account.witness.AccountAgeWitnessService;
import haveno.core.app.misc.AppSetup;
import haveno.core.filter.FilterManager;
import haveno.core.trade.statistics.TradeStatisticsManager;
import haveno.network.p2p.P2PService;
import haveno.network.p2p.P2PServiceListener;
import haveno.network.p2p.network.CloseConnectionReason;
import haveno.network.p2p.network.Connection;
import haveno.network.p2p.network.ConnectionListener;
import haveno.network.p2p.peers.PeerManager;
import haveno.network.p2p.storage.P2PDataStorage;
import java.util.ArrayList;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppSetupWithP2P
extends AppSetup {
    private static final Logger log = LoggerFactory.getLogger(AppSetupWithP2P.class);
    protected final P2PService p2PService;
    protected final AccountAgeWitnessService accountAgeWitnessService;
    private final SignedWitnessService signedWitnessService;
    protected final FilterManager filterManager;
    private final P2PDataStorage p2PDataStorage;
    private final PeerManager peerManager;
    protected final TradeStatisticsManager tradeStatisticsManager;
    protected ArrayList<PersistedDataHost> persistedDataHosts;
    protected BooleanProperty p2pNetWorkReady;

    @Inject
    public AppSetupWithP2P(P2PService p2PService, P2PDataStorage p2PDataStorage, PeerManager peerManager, TradeStatisticsManager tradeStatisticsManager, AccountAgeWitnessService accountAgeWitnessService, SignedWitnessService signedWitnessService, FilterManager filterManager, Config config) {
        super(config);
        this.p2PService = p2PService;
        this.p2PDataStorage = p2PDataStorage;
        this.peerManager = peerManager;
        this.tradeStatisticsManager = tradeStatisticsManager;
        this.accountAgeWitnessService = accountAgeWitnessService;
        this.signedWitnessService = signedWitnessService;
        this.filterManager = filterManager;
        this.persistedDataHosts = new ArrayList();
    }

    @Override
    public void initPersistedDataHosts() {
        this.persistedDataHosts.add(this.p2PDataStorage);
        this.persistedDataHosts.add(this.peerManager);
        this.persistedDataHosts.forEach(e -> {
            try {
                e.readPersisted(() -> {});
            }
            catch (Throwable e1) {
                log.error("readPersisted error", e1);
            }
        });
    }

    @Override
    protected void initBasicServices() {
        String postFix = "_" + this.config.baseCurrencyNetwork.name();
        this.p2PDataStorage.readFromResources(postFix, this::startInitP2PNetwork);
    }

    private void startInitP2PNetwork() {
        this.p2pNetWorkReady = this.initP2PNetwork();
        this.p2pNetWorkReady.addListener((observable2, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                this.onBasicServicesInitialized();
            }
        });
    }

    private BooleanProperty initP2PNetwork() {
        log.info("initP2PNetwork");
        this.p2PService.getNetworkNode().addConnectionListener(new ConnectionListener(){

            @Override
            public void onConnection(Connection connection) {
            }

            @Override
            public void onDisconnect(CloseConnectionReason closeConnectionReason, Connection connection) {
                if (connection.getConnectionState().isSeedNode() && closeConnectionReason == CloseConnectionReason.RULE_VIOLATION) {
                    log.warn("RULE_VIOLATION onDisconnect closeConnectionReason={}. connection={}", (Object)closeConnectionReason, (Object)connection);
                }
            }
        });
        final SimpleBooleanProperty p2pNetworkInitialized = new SimpleBooleanProperty();
        this.p2PService.start(new P2PServiceListener(){

            @Override
            public void onTorNodeReady() {
            }

            @Override
            public void onHiddenServicePublished() {
                log.info("onHiddenServicePublished");
            }

            @Override
            public void onDataReceived() {
                log.info("onRequestingDataCompleted");
                p2pNetworkInitialized.set(true);
            }

            @Override
            public void onNoSeedNodeAvailable() {
                log.info("onNoSeedNodeAvailable");
                p2pNetworkInitialized.set(true);
            }

            @Override
            public void onNoPeersAvailable() {
                log.info("onNoPeersAvailable");
                p2pNetworkInitialized.set(true);
            }

            @Override
            public void onUpdatedDataReceived() {
                log.info("onUpdatedDataReceived");
            }

            @Override
            public void onSetupFailed(Throwable throwable) {
                log.error(throwable.toString());
            }

            @Override
            public void onRequestCustomBridges() {
            }
        });
        return p2pNetworkInitialized;
    }

    protected void onBasicServicesInitialized() {
        log.info("onBasicServicesInitialized");
        PersistenceManager.onAllServicesInitialized();
        this.p2PService.onAllServicesInitialized();
        this.tradeStatisticsManager.onAllServicesInitialized();
        this.accountAgeWitnessService.onAllServicesInitialized();
        this.signedWitnessService.onAllServicesInitialized();
        this.filterManager.onAllServicesInitialized();
    }
}

