/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.locale;

import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import haveno.core.locale.Country;
import haveno.core.locale.GlobalSettings;
import haveno.core.locale.LanguageUtil;
import haveno.core.locale.LocaleUtil;
import haveno.core.locale.Region;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CountryUtil {
    private static final Logger log = LoggerFactory.getLogger(CountryUtil.class);
    private static final Map<String, String> regionCodeToNameMap = new HashMap<String, String>();
    private static final Map<String, String> regionByCountryCodeMap = new HashMap<String, String>();

    public static List<String> getCountryCodes(List<Country> countries) {
        return countries.stream().map(country -> country.code).collect(Collectors.toList());
    }

    public static Country getCountry(String code) {
        return CountryUtil.getCountries(List.of(code)).get(0);
    }

    public static List<Country> getCountries(List<String> codes) {
        ArrayList<Country> countries = new ArrayList<Country>();
        for (String code : codes) {
            Locale locale = new Locale(LanguageUtil.getDefaultLanguage(), code, "");
            String countryCode = locale.getCountry();
            String regionCode = CountryUtil.getRegionCode(countryCode);
            Region region = new Region(regionCode, CountryUtil.getRegionName(regionCode));
            Country country = new Country(countryCode, locale.getDisplayCountry(), region);
            if (countryCode.equals("XK")) {
                country = new Country(countryCode, CountryUtil.getNameByCode(countryCode), region);
            }
            countries.add(country);
        }
        return countries;
    }

    public static List<Country> getAllSepaEuroCountries() {
        ArrayList<Country> list = new ArrayList<Country>();
        String[] codes = new String[]{"AT", "BE", "CY", "DE", "EE", "FI", "FR", "GR", "IE", "IT", "LV", "LT", "LU", "MC", "MT", "NL", "PT", "SK", "SI", "ES", "AD", "SM", "VA"};
        CountryUtil.populateCountryListByCodes(list, codes);
        list.sort((a, b) -> a.name.compareTo(b.name));
        return list;
    }

    public static List<Country> getAllRevolutCountries() {
        ArrayList<Country> list = new ArrayList<Country>();
        String[] codes = new String[]{"AT", "BE", "BG", "HR", "CY", "CZ", "DK", "EE", "FI", "FR", "DE", "GR", "HU", "IS", "IE", "IT", "LV", "LI", "LT", "LU", "MT", "NL", "NO", "PL", "PT", "RO", "SK", "SI", "ES", "SE", "GB", "AU", "CA", "SG", "CH", "US"};
        CountryUtil.populateCountryListByCodes(list, codes);
        list.sort((a, b) -> a.name.compareTo(b.name));
        return list;
    }

    public static List<Country> getAllAmazonGiftCardCountries() {
        ArrayList<Country> list = new ArrayList<Country>();
        String[] codes = new String[]{"AU", "CA", "FR", "DE", "IT", "NL", "ES", "GB", "IN", "JP", "SA", "SE", "SG", "TR", "US"};
        CountryUtil.populateCountryListByCodes(list, codes);
        list.sort(Comparator.comparing(a -> a.name));
        return list;
    }

    public static List<Country> getAllSepaInstantEuroCountries() {
        return CountryUtil.getAllSepaEuroCountries();
    }

    private static void populateCountryListByCodes(List<Country> list, String[] codes) {
        list.addAll(CountryUtil.getCountries(Arrays.asList(codes)));
    }

    public static boolean containsAllSepaEuroCountries(List<String> countryCodesToCompare) {
        List countryCodesBase = CountryUtil.getAllSepaEuroCountries().stream().map(c -> c.code).collect(Collectors.toList());
        return countryCodesToCompare.containsAll(countryCodesBase) && countryCodesBase.containsAll(countryCodesToCompare);
    }

    public static boolean containsAllSepaInstantEuroCountries(List<String> countryCodesToCompare) {
        return CountryUtil.containsAllSepaEuroCountries(countryCodesToCompare);
    }

    public static List<Country> getAllSepaNonEuroCountries() {
        ArrayList<Country> list = new ArrayList<Country>();
        String[] codes = new String[]{"BG", "HR", "CZ", "DK", "GB", "HU", "PL", "RO", "SE", "IS", "NO", "LI", "CH", "JE"};
        CountryUtil.populateCountryListByCodes(list, codes);
        list.sort((a, b) -> a.name.compareTo(b.name));
        return list;
    }

    public static List<Country> getAllSepaInstantNonEuroCountries() {
        return CountryUtil.getAllSepaNonEuroCountries();
    }

    public static List<Country> getAllSepaCountries() {
        ArrayList<Country> list = new ArrayList<Country>();
        list.addAll(CountryUtil.getAllSepaEuroCountries());
        list.addAll(CountryUtil.getAllSepaNonEuroCountries());
        return list;
    }

    public static List<Country> getAllSepaInstantCountries() {
        return CountryUtil.getAllSepaCountries();
    }

    public static Country getDefaultCountry() {
        String regionCode = CountryUtil.getRegionCode(CountryUtil.getLocale().getCountry());
        Region region = new Region(regionCode, CountryUtil.getRegionName(regionCode));
        return new Country(CountryUtil.getLocale().getCountry(), CountryUtil.getLocale().getDisplayCountry(), region);
    }

    public static Optional<Country> findCountryByCode(String countryCode) {
        return CountryUtil.getAllCountries().stream().filter(e -> e.code.equals(countryCode)).findAny();
    }

    public static String getNameByCode(String countryCode) {
        if (countryCode.equals("XK")) {
            return "Republic of Kosovo";
        }
        return new Locale(LanguageUtil.getDefaultLanguage(), countryCode).getDisplayCountry();
    }

    public static String getNameAndCode(String countryCode) {
        if (countryCode.isEmpty()) {
            return "";
        }
        return CountryUtil.getNameByCode(countryCode) + " (" + countryCode + ")";
    }

    public static String getCodesString(List<String> countryCodes) {
        return countryCodes.stream().collect(Collectors.joining(", "));
    }

    public static String getNamesByCodesString(List<String> countryCodes) {
        return CountryUtil.getNamesByCodes(countryCodes).stream().collect(Collectors.joining(",\n"));
    }

    public static List<Region> getAllRegions() {
        ArrayList<Region> allRegions = new ArrayList<Region>();
        String regionCode = "AM";
        Region region = new Region(regionCode, CountryUtil.getRegionName(regionCode));
        allRegions.add(region);
        regionCode = "AF";
        region = new Region(regionCode, CountryUtil.getRegionName(regionCode));
        allRegions.add(region);
        regionCode = "EU";
        region = new Region(regionCode, CountryUtil.getRegionName(regionCode));
        allRegions.add(region);
        regionCode = "AS";
        region = new Region(regionCode, CountryUtil.getRegionName(regionCode));
        allRegions.add(region);
        regionCode = "OC";
        region = new Region(regionCode, CountryUtil.getRegionName(regionCode));
        allRegions.add(region);
        return allRegions;
    }

    public static List<Country> getAllCountriesForRegion(Region selectedRegion) {
        return Lists.newArrayList(Collections2.filter(CountryUtil.getAllCountries(), country -> selectedRegion != null && country != null && selectedRegion.equals(country.region)));
    }

    public static List<Country> getAllCountries() {
        HashSet<Country> allCountries = new HashSet<Country>();
        for (Locale locale : CountryUtil.getAllCountryLocales()) {
            String regionCode = CountryUtil.getRegionCode(locale.getCountry());
            Region region = new Region(regionCode, CountryUtil.getRegionName(regionCode));
            Country country = new Country(locale.getCountry(), locale.getDisplayCountry(), region);
            if (locale.getCountry().equals("XK")) {
                country = new Country(locale.getCountry(), "Republic of Kosovo", region);
            }
            allCountries.add(country);
        }
        allCountries.add(new Country("GE", "Georgia", new Region("AS", CountryUtil.getRegionName("AS"))));
        allCountries.add(new Country("BW", "Botswana", new Region("AF", CountryUtil.getRegionName("AF"))));
        allCountries.add(new Country("IR", "Iran", new Region("AS", CountryUtil.getRegionName("AS"))));
        ArrayList<Country> allCountriesList = new ArrayList<Country>(allCountries);
        allCountriesList.sort((locale1, locale2) -> locale1.name.compareTo(locale2.name));
        return allCountriesList;
    }

    private static List<Locale> getAllCountryLocales() {
        List<Locale> allLocales = LocaleUtil.getAllLocales();
        Set allLocalesAsSet = allLocales.stream().filter(locale -> !locale.getCountry().isEmpty()).collect(Collectors.toSet());
        ArrayList<Locale> allCountryLocales = new ArrayList<Locale>();
        allCountryLocales.addAll(allLocalesAsSet);
        allCountryLocales.sort((locale1, locale2) -> locale1.getDisplayCountry().compareTo(locale2.getDisplayCountry()));
        return allCountryLocales;
    }

    private static List<String> getNamesByCodes(List<String> countryCodes) {
        return countryCodes.stream().map(CountryUtil::getNameByCode).collect(Collectors.toList());
    }

    private static String getRegionName(String regionCode) {
        return regionCodeToNameMap.get(regionCode);
    }

    public static String getRegionCode(String countryCode) {
        if (regionByCountryCodeMap.containsKey(countryCode)) {
            return regionByCountryCodeMap.get(countryCode);
        }
        return "Undefined";
    }

    public static String getDefaultCountryCode() {
        return CountryUtil.getLocale().getCountry();
    }

    private static Locale getLocale() {
        return GlobalSettings.getLocale();
    }

    static {
        regionCodeToNameMap.put("AM", "Americas");
        regionCodeToNameMap.put("AF", "Africa");
        regionCodeToNameMap.put("EU", "Europe");
        regionCodeToNameMap.put("AS", "Asia");
        regionCodeToNameMap.put("OC", "Oceania");
        regionByCountryCodeMap.put("AF", "AS");
        regionByCountryCodeMap.put("AX", "EU");
        regionByCountryCodeMap.put("AL", "EU");
        regionByCountryCodeMap.put("DZ", "AF");
        regionByCountryCodeMap.put("AS", "OC");
        regionByCountryCodeMap.put("AD", "EU");
        regionByCountryCodeMap.put("AO", "AF");
        regionByCountryCodeMap.put("AI", "AM");
        regionByCountryCodeMap.put("AG", "AM");
        regionByCountryCodeMap.put("AR", "AM");
        regionByCountryCodeMap.put("AM", "AS");
        regionByCountryCodeMap.put("AW", "AM");
        regionByCountryCodeMap.put("AU", "OC");
        regionByCountryCodeMap.put("AT", "EU");
        regionByCountryCodeMap.put("AZ", "AS");
        regionByCountryCodeMap.put("BS", "AM");
        regionByCountryCodeMap.put("BH", "AS");
        regionByCountryCodeMap.put("BD", "AS");
        regionByCountryCodeMap.put("BB", "AM");
        regionByCountryCodeMap.put("BY", "EU");
        regionByCountryCodeMap.put("BE", "EU");
        regionByCountryCodeMap.put("BZ", "AM");
        regionByCountryCodeMap.put("BJ", "AF");
        regionByCountryCodeMap.put("BM", "AM");
        regionByCountryCodeMap.put("BT", "AS");
        regionByCountryCodeMap.put("BO", "AM");
        regionByCountryCodeMap.put("BQ", "AM");
        regionByCountryCodeMap.put("BA", "EU");
        regionByCountryCodeMap.put("BW", "AF");
        regionByCountryCodeMap.put("BR", "AM");
        regionByCountryCodeMap.put("IO", "AF");
        regionByCountryCodeMap.put("UM", "AM");
        regionByCountryCodeMap.put("VG", "AM");
        regionByCountryCodeMap.put("VI", "AM");
        regionByCountryCodeMap.put("BN", "AS");
        regionByCountryCodeMap.put("BG", "EU");
        regionByCountryCodeMap.put("BF", "AF");
        regionByCountryCodeMap.put("BI", "AF");
        regionByCountryCodeMap.put("KH", "AS");
        regionByCountryCodeMap.put("CM", "AF");
        regionByCountryCodeMap.put("CA", "AM");
        regionByCountryCodeMap.put("CV", "AF");
        regionByCountryCodeMap.put("KY", "AM");
        regionByCountryCodeMap.put("CF", "AF");
        regionByCountryCodeMap.put("TD", "AF");
        regionByCountryCodeMap.put("CL", "AM");
        regionByCountryCodeMap.put("CN", "AS");
        regionByCountryCodeMap.put("CX", "OC");
        regionByCountryCodeMap.put("CC", "OC");
        regionByCountryCodeMap.put("CO", "AM");
        regionByCountryCodeMap.put("KM", "AF");
        regionByCountryCodeMap.put("CG", "AF");
        regionByCountryCodeMap.put("CD", "AF");
        regionByCountryCodeMap.put("CK", "OC");
        regionByCountryCodeMap.put("CR", "AM");
        regionByCountryCodeMap.put("HR", "EU");
        regionByCountryCodeMap.put("CU", "AM");
        regionByCountryCodeMap.put("CW", "AM");
        regionByCountryCodeMap.put("CY", "EU");
        regionByCountryCodeMap.put("CZ", "EU");
        regionByCountryCodeMap.put("DK", "EU");
        regionByCountryCodeMap.put("DJ", "AF");
        regionByCountryCodeMap.put("DM", "AM");
        regionByCountryCodeMap.put("DO", "AM");
        regionByCountryCodeMap.put("EC", "AM");
        regionByCountryCodeMap.put("EG", "AF");
        regionByCountryCodeMap.put("SV", "AM");
        regionByCountryCodeMap.put("GQ", "AF");
        regionByCountryCodeMap.put("ER", "AF");
        regionByCountryCodeMap.put("EE", "EU");
        regionByCountryCodeMap.put("ET", "AF");
        regionByCountryCodeMap.put("FK", "AM");
        regionByCountryCodeMap.put("FO", "EU");
        regionByCountryCodeMap.put("FJ", "OC");
        regionByCountryCodeMap.put("FI", "EU");
        regionByCountryCodeMap.put("FR", "EU");
        regionByCountryCodeMap.put("GF", "AM");
        regionByCountryCodeMap.put("PF", "OC");
        regionByCountryCodeMap.put("TF", "AF");
        regionByCountryCodeMap.put("GA", "AF");
        regionByCountryCodeMap.put("GM", "AF");
        regionByCountryCodeMap.put("GE", "AS");
        regionByCountryCodeMap.put("DE", "EU");
        regionByCountryCodeMap.put("GH", "AF");
        regionByCountryCodeMap.put("GI", "EU");
        regionByCountryCodeMap.put("GR", "EU");
        regionByCountryCodeMap.put("GL", "AM");
        regionByCountryCodeMap.put("GD", "AM");
        regionByCountryCodeMap.put("GP", "AM");
        regionByCountryCodeMap.put("GU", "OC");
        regionByCountryCodeMap.put("GT", "AM");
        regionByCountryCodeMap.put("GG", "EU");
        regionByCountryCodeMap.put("GN", "AF");
        regionByCountryCodeMap.put("GW", "AF");
        regionByCountryCodeMap.put("GY", "AM");
        regionByCountryCodeMap.put("HT", "AM");
        regionByCountryCodeMap.put("VA", "EU");
        regionByCountryCodeMap.put("HN", "AM");
        regionByCountryCodeMap.put("HK", "AS");
        regionByCountryCodeMap.put("HU", "EU");
        regionByCountryCodeMap.put("IS", "EU");
        regionByCountryCodeMap.put("IN", "AS");
        regionByCountryCodeMap.put("ID", "AS");
        regionByCountryCodeMap.put("CI", "AF");
        regionByCountryCodeMap.put("IR", "AS");
        regionByCountryCodeMap.put("IQ", "AS");
        regionByCountryCodeMap.put("IE", "EU");
        regionByCountryCodeMap.put("IM", "EU");
        regionByCountryCodeMap.put("IL", "AS");
        regionByCountryCodeMap.put("IT", "EU");
        regionByCountryCodeMap.put("JM", "AM");
        regionByCountryCodeMap.put("JP", "AS");
        regionByCountryCodeMap.put("JE", "EU");
        regionByCountryCodeMap.put("JO", "AS");
        regionByCountryCodeMap.put("KZ", "AS");
        regionByCountryCodeMap.put("KE", "AF");
        regionByCountryCodeMap.put("KI", "OC");
        regionByCountryCodeMap.put("KW", "AS");
        regionByCountryCodeMap.put("KG", "AS");
        regionByCountryCodeMap.put("LA", "AS");
        regionByCountryCodeMap.put("LV", "EU");
        regionByCountryCodeMap.put("LB", "AS");
        regionByCountryCodeMap.put("LS", "AF");
        regionByCountryCodeMap.put("LR", "AF");
        regionByCountryCodeMap.put("LY", "AF");
        regionByCountryCodeMap.put("LI", "EU");
        regionByCountryCodeMap.put("LT", "EU");
        regionByCountryCodeMap.put("LU", "EU");
        regionByCountryCodeMap.put("MO", "AS");
        regionByCountryCodeMap.put("MK", "EU");
        regionByCountryCodeMap.put("MG", "AF");
        regionByCountryCodeMap.put("MW", "AF");
        regionByCountryCodeMap.put("MY", "AS");
        regionByCountryCodeMap.put("MV", "AS");
        regionByCountryCodeMap.put("ML", "AF");
        regionByCountryCodeMap.put("MT", "EU");
        regionByCountryCodeMap.put("MH", "OC");
        regionByCountryCodeMap.put("MQ", "AM");
        regionByCountryCodeMap.put("MR", "AF");
        regionByCountryCodeMap.put("MU", "AF");
        regionByCountryCodeMap.put("YT", "AF");
        regionByCountryCodeMap.put("MX", "AM");
        regionByCountryCodeMap.put("FM", "OC");
        regionByCountryCodeMap.put("MD", "EU");
        regionByCountryCodeMap.put("MC", "EU");
        regionByCountryCodeMap.put("MN", "AS");
        regionByCountryCodeMap.put("ME", "EU");
        regionByCountryCodeMap.put("MS", "AM");
        regionByCountryCodeMap.put("MA", "AF");
        regionByCountryCodeMap.put("MZ", "AF");
        regionByCountryCodeMap.put("MM", "AS");
        regionByCountryCodeMap.put("NA", "AF");
        regionByCountryCodeMap.put("NR", "OC");
        regionByCountryCodeMap.put("NP", "AS");
        regionByCountryCodeMap.put("NL", "EU");
        regionByCountryCodeMap.put("NC", "OC");
        regionByCountryCodeMap.put("NZ", "OC");
        regionByCountryCodeMap.put("NI", "AM");
        regionByCountryCodeMap.put("NE", "AF");
        regionByCountryCodeMap.put("NG", "AF");
        regionByCountryCodeMap.put("NU", "OC");
        regionByCountryCodeMap.put("NF", "OC");
        regionByCountryCodeMap.put("KP", "AS");
        regionByCountryCodeMap.put("MP", "OC");
        regionByCountryCodeMap.put("NO", "EU");
        regionByCountryCodeMap.put("OM", "AS");
        regionByCountryCodeMap.put("PK", "AS");
        regionByCountryCodeMap.put("PW", "OC");
        regionByCountryCodeMap.put("PS", "AS");
        regionByCountryCodeMap.put("PA", "AM");
        regionByCountryCodeMap.put("PG", "OC");
        regionByCountryCodeMap.put("PY", "AM");
        regionByCountryCodeMap.put("PE", "AM");
        regionByCountryCodeMap.put("PH", "AS");
        regionByCountryCodeMap.put("PN", "OC");
        regionByCountryCodeMap.put("PL", "EU");
        regionByCountryCodeMap.put("PT", "EU");
        regionByCountryCodeMap.put("PR", "AM");
        regionByCountryCodeMap.put("QA", "AS");
        regionByCountryCodeMap.put("XK", "EU");
        regionByCountryCodeMap.put("RE", "AF");
        regionByCountryCodeMap.put("RO", "EU");
        regionByCountryCodeMap.put("RU", "EU");
        regionByCountryCodeMap.put("RW", "AF");
        regionByCountryCodeMap.put("BL", "AM");
        regionByCountryCodeMap.put("SH", "AF");
        regionByCountryCodeMap.put("KN", "AM");
        regionByCountryCodeMap.put("LC", "AM");
        regionByCountryCodeMap.put("MF", "AM");
        regionByCountryCodeMap.put("PM", "AM");
        regionByCountryCodeMap.put("VC", "AM");
        regionByCountryCodeMap.put("WS", "OC");
        regionByCountryCodeMap.put("SM", "EU");
        regionByCountryCodeMap.put("ST", "AF");
        regionByCountryCodeMap.put("SA", "AS");
        regionByCountryCodeMap.put("SN", "AF");
        regionByCountryCodeMap.put("RS", "EU");
        regionByCountryCodeMap.put("SC", "AF");
        regionByCountryCodeMap.put("SL", "AF");
        regionByCountryCodeMap.put("SG", "AS");
        regionByCountryCodeMap.put("SX", "AM");
        regionByCountryCodeMap.put("SK", "EU");
        regionByCountryCodeMap.put("SI", "EU");
        regionByCountryCodeMap.put("SB", "OC");
        regionByCountryCodeMap.put("SO", "AF");
        regionByCountryCodeMap.put("ZA", "AF");
        regionByCountryCodeMap.put("GS", "AM");
        regionByCountryCodeMap.put("KR", "AS");
        regionByCountryCodeMap.put("SS", "AF");
        regionByCountryCodeMap.put("ES", "EU");
        regionByCountryCodeMap.put("LK", "AS");
        regionByCountryCodeMap.put("SD", "AF");
        regionByCountryCodeMap.put("SR", "AM");
        regionByCountryCodeMap.put("SJ", "EU");
        regionByCountryCodeMap.put("SZ", "AF");
        regionByCountryCodeMap.put("SE", "EU");
        regionByCountryCodeMap.put("CH", "EU");
        regionByCountryCodeMap.put("SY", "AS");
        regionByCountryCodeMap.put("TW", "AS");
        regionByCountryCodeMap.put("TJ", "AS");
        regionByCountryCodeMap.put("TZ", "AF");
        regionByCountryCodeMap.put("TH", "AS");
        regionByCountryCodeMap.put("TL", "AS");
        regionByCountryCodeMap.put("TG", "AF");
        regionByCountryCodeMap.put("TK", "OC");
        regionByCountryCodeMap.put("TO", "OC");
        regionByCountryCodeMap.put("TT", "AM");
        regionByCountryCodeMap.put("TN", "AF");
        regionByCountryCodeMap.put("TR", "AS");
        regionByCountryCodeMap.put("TM", "AS");
        regionByCountryCodeMap.put("TC", "AM");
        regionByCountryCodeMap.put("TV", "OC");
        regionByCountryCodeMap.put("UG", "AF");
        regionByCountryCodeMap.put("UA", "EU");
        regionByCountryCodeMap.put("AE", "AS");
        regionByCountryCodeMap.put("GB", "EU");
        regionByCountryCodeMap.put("US", "AM");
        regionByCountryCodeMap.put("UY", "AM");
        regionByCountryCodeMap.put("UZ", "AS");
        regionByCountryCodeMap.put("VU", "OC");
        regionByCountryCodeMap.put("VE", "AM");
        regionByCountryCodeMap.put("VN", "AS");
        regionByCountryCodeMap.put("WF", "OC");
        regionByCountryCodeMap.put("EH", "AF");
        regionByCountryCodeMap.put("YE", "AS");
        regionByCountryCodeMap.put("ZM", "AF");
        regionByCountryCodeMap.put("ZW", "AF");
    }
}

