/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.locale;

import haveno.core.locale.TradeCurrency;
import java.util.Locale;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalSettings {
    private static final Logger log = LoggerFactory.getLogger(GlobalSettings.class);
    private static boolean useAnimations = true;
    private static Locale locale;
    private static final ObjectProperty<Locale> localeProperty;
    private static TradeCurrency defaultTradeCurrency;
    private static String btcDenomination;

    public static void setLocale(Locale locale) {
        GlobalSettings.locale = locale;
        localeProperty.set(locale);
    }

    public static void setUseAnimations(boolean useAnimations) {
        GlobalSettings.useAnimations = useAnimations;
    }

    public static void setDefaultTradeCurrency(TradeCurrency tradeCurrency) {
        defaultTradeCurrency = tradeCurrency;
    }

    public static void setBtcDenomination(String btcDenomination) {
        GlobalSettings.btcDenomination = btcDenomination;
    }

    public static TradeCurrency getDefaultTradeCurrency() {
        return defaultTradeCurrency;
    }

    public static String getBtcDenomination() {
        return btcDenomination;
    }

    public static ReadOnlyObjectProperty<Locale> localeProperty() {
        return localeProperty;
    }

    public static boolean getUseAnimations() {
        return useAnimations;
    }

    public static Locale getLocale() {
        return locale;
    }

    static {
        localeProperty = new SimpleObjectProperty<Locale>(locale);
        locale = Locale.getDefault();
        log.info("Locale info: {}", (Object)locale);
        if (locale.getCountry() == null || locale.getCountry().isEmpty()) {
            locale = Locale.US;
        }
    }
}

