/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.locale;

import com.google.protobuf.Message;
import haveno.core.locale.GlobalSettings;
import haveno.core.locale.TradeCurrency;
import java.util.Currency;
import java.util.Locale;

public final class TraditionalCurrency
extends TradeCurrency {
    private static final String PREFIX = "\u2605 ";

    public TraditionalCurrency(String currencyCode) {
        this(Currency.getInstance(currencyCode), TraditionalCurrency.getLocale());
    }

    public TraditionalCurrency(String currencyCode, String name) {
        super(currencyCode, name);
    }

    public TraditionalCurrency(TraditionalCurrency currency) {
        this(currency.getCode(), currency.getName());
    }

    public TraditionalCurrency(Currency currency) {
        this(currency, TraditionalCurrency.getLocale());
    }

    public TraditionalCurrency(Currency currency, Locale locale) {
        super(currency.getCurrencyCode(), currency.getDisplayName(locale));
    }

    @Override
    public Message toProtoMessage() {
        return this.getTradeCurrencyBuilder().setCode(this.code).setName(this.name).setTraditionalCurrency(protobuf.TraditionalCurrency.newBuilder()).build();
    }

    public static TraditionalCurrency fromProto(protobuf.TradeCurrency proto) {
        return new TraditionalCurrency(proto.getCode(), proto.getName());
    }

    private static Locale getLocale() {
        return GlobalSettings.getLocale();
    }

    @Override
    public String getDisplayPrefix() {
        return PREFIX;
    }

    @Override
    public String toString() {
        return "TraditionalCurrency()";
    }
}

