/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.monetary;

import com.google.common.base.Preconditions;
import haveno.core.monetary.CryptoMoney;
import java.math.BigInteger;
import org.bitcoinj.core.Coin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CryptoExchangeRate {
    private static final Logger log = LoggerFactory.getLogger(CryptoExchangeRate.class);
    public final Coin coin;
    public final CryptoMoney crypto;

    public CryptoExchangeRate(Coin coin, CryptoMoney crypto) {
        Preconditions.checkArgument(coin.isPositive());
        Preconditions.checkArgument(crypto.isPositive());
        Preconditions.checkArgument(crypto.currencyCode != null, "currency code required");
        this.coin = coin;
        this.crypto = crypto;
    }

    public CryptoExchangeRate(CryptoMoney crypto) {
        this(Coin.COIN, crypto);
    }

    public CryptoMoney coinToCrypto(Coin convertCoin) {
        BigInteger converted = BigInteger.valueOf(this.coin.value).multiply(BigInteger.valueOf(convertCoin.value)).divide(BigInteger.valueOf(this.crypto.value));
        if (converted.compareTo(BigInteger.valueOf(Long.MAX_VALUE)) > 0 || converted.compareTo(BigInteger.valueOf(Long.MIN_VALUE)) < 0) {
            throw new ArithmeticException("Overflow");
        }
        return CryptoMoney.valueOf(this.crypto.currencyCode, converted.longValue());
    }

    public Coin cryptoToCoin(CryptoMoney convertCrypto) {
        Preconditions.checkArgument(convertCrypto.currencyCode.equals(this.crypto.currencyCode), "Currency mismatch: %s vs %s", (Object)convertCrypto.currencyCode, (Object)this.crypto.currencyCode);
        BigInteger converted = BigInteger.valueOf(this.crypto.value).multiply(BigInteger.valueOf(convertCrypto.value)).divide(BigInteger.valueOf(this.coin.value));
        if (converted.compareTo(BigInteger.valueOf(Long.MAX_VALUE)) > 0 || converted.compareTo(BigInteger.valueOf(Long.MIN_VALUE)) < 0) {
            throw new ArithmeticException("Overflow");
        }
        try {
            return Coin.valueOf(converted.longValue());
        }
        catch (IllegalArgumentException x) {
            throw new ArithmeticException("Overflow: " + x.getMessage());
        }
    }
}

