/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.monetary;

import org.bitcoinj.core.Monetary;
import org.bitcoinj.utils.MonetaryFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MonetaryWrapper {
    private static final Logger log = LoggerFactory.getLogger(MonetaryWrapper.class);
    protected final Monetary monetary;
    protected final MonetaryFormat traditionalFormat = MonetaryFormat.FIAT.repeatOptionalDecimals(0, 0);
    protected final MonetaryFormat cryptoFormat = MonetaryFormat.FIAT.repeatOptionalDecimals(0, 0);

    public MonetaryWrapper(Monetary monetary) {
        this.monetary = monetary;
    }

    public Monetary getMonetary() {
        return this.monetary;
    }

    public boolean isZero() {
        return this.monetary.getValue() == 0L;
    }

    public int smallestUnitExponent() {
        return this.monetary.smallestUnitExponent();
    }

    public long getValue() {
        return this.monetary.getValue();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        Monetary otherMonetary = ((MonetaryWrapper)o).getMonetary();
        return this.monetary.getValue() == otherMonetary.getValue();
    }

    public int hashCode() {
        return (int)this.monetary.getValue();
    }
}

