/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.network;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import haveno.network.p2p.NodeAddress;
import haveno.network.p2p.network.BanFilter;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoreBanFilter
implements BanFilter {
    private static final Logger log = LoggerFactory.getLogger(CoreBanFilter.class);
    private final Set<NodeAddress> bannedPeersFromOptions = new HashSet<NodeAddress>();
    private Predicate<NodeAddress> bannedNodePredicate;

    @Inject
    public CoreBanFilter(@Named(value="banList") List<String> banList) {
        banList.stream().map(NodeAddress::new).forEach(this.bannedPeersFromOptions::add);
    }

    @Override
    public void setBannedNodePredicate(Predicate<NodeAddress> bannedNodePredicate) {
        this.bannedNodePredicate = bannedNodePredicate;
    }

    @Override
    public boolean isPeerBanned(NodeAddress nodeAddress) {
        return this.bannedPeersFromOptions.contains(nodeAddress) || this.bannedNodePredicate != null && this.bannedNodePredicate.test(nodeAddress);
    }
}

