/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.network.p2p.inventory;

import com.google.common.base.Enums;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import haveno.common.proto.network.NetworkEnvelope;
import haveno.common.util.Profiler;
import haveno.core.filter.Filter;
import haveno.core.filter.FilterManager;
import haveno.core.network.p2p.inventory.messages.GetInventoryRequest;
import haveno.core.network.p2p.inventory.messages.GetInventoryResponse;
import haveno.core.network.p2p.inventory.model.InventoryItem;
import haveno.network.p2p.network.Connection;
import haveno.network.p2p.network.MessageListener;
import haveno.network.p2p.network.NetworkNode;
import haveno.network.p2p.network.Statistic;
import haveno.network.p2p.peers.PeerManager;
import haveno.network.p2p.storage.P2PDataStorage;
import haveno.network.p2p.storage.payload.ProtectedStorageEntry;
import java.lang.management.ManagementFactory;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetInventoryRequestHandler
implements MessageListener {
    private static final Logger log = LoggerFactory.getLogger(GetInventoryRequestHandler.class);
    private final NetworkNode networkNode;
    private final PeerManager peerManager;
    private final P2PDataStorage p2PDataStorage;
    private final FilterManager filterManager;
    private final int maxConnections;

    @Inject
    public GetInventoryRequestHandler(NetworkNode networkNode, PeerManager peerManager, P2PDataStorage p2PDataStorage, FilterManager filterManager, @Named(value="maxConnections") int maxConnections) {
        this.networkNode = networkNode;
        this.peerManager = peerManager;
        this.p2PDataStorage = p2PDataStorage;
        this.filterManager = filterManager;
        this.maxConnections = maxConnections;
        this.networkNode.addMessageListener(this);
    }

    @Override
    public void onMessage(NetworkEnvelope networkEnvelope, Connection connection) {
        if (networkEnvelope instanceof GetInventoryRequest) {
            GetInventoryRequest getInventoryRequest = (GetInventoryRequest)networkEnvelope;
            HashMap<InventoryItem, Integer> dataObjects = new HashMap<InventoryItem, Integer>();
            this.p2PDataStorage.getMapForDataResponse(getInventoryRequest.getVersion()).values().stream().map(e -> e.getClass().getSimpleName()).forEach(className -> this.addClassNameToMap((Map<InventoryItem, Integer>)dataObjects, (String)className));
            this.p2PDataStorage.getMap().values().stream().map(ProtectedStorageEntry::getProtectedStoragePayload).map(e -> e.getClass().getSimpleName()).forEach(className -> this.addClassNameToMap((Map<InventoryItem, Integer>)dataObjects, (String)className));
            HashMap<InventoryItem, String> inventory = new HashMap<InventoryItem, String>();
            dataObjects.forEach((key, value) -> inventory.put((InventoryItem)((Object)key), String.valueOf(value)));
            inventory.put(InventoryItem.maxConnections, String.valueOf(this.maxConnections));
            inventory.put(InventoryItem.numConnections, String.valueOf(this.networkNode.getAllConnections().size()));
            inventory.put(InventoryItem.peakNumConnections, String.valueOf(this.peerManager.getPeakNumConnections()));
            inventory.put(InventoryItem.numAllConnectionsLostEvents, String.valueOf(this.peerManager.getNumAllConnectionsLostEvents()));
            this.peerManager.maybeResetNumAllConnectionsLostEvents();
            inventory.put(InventoryItem.sentBytes, String.valueOf(Statistic.totalSentBytesProperty().get()));
            inventory.put(InventoryItem.sentBytesPerSec, String.valueOf(Statistic.totalSentBytesPerSecProperty().get()));
            inventory.put(InventoryItem.receivedBytes, String.valueOf(Statistic.totalReceivedBytesProperty().get()));
            inventory.put(InventoryItem.receivedBytesPerSec, String.valueOf(Statistic.totalReceivedBytesPerSecProperty().get()));
            inventory.put(InventoryItem.receivedMessagesPerSec, String.valueOf(Statistic.numTotalReceivedMessagesPerSecProperty().get()));
            inventory.put(InventoryItem.sentMessagesPerSec, String.valueOf(Statistic.numTotalSentMessagesPerSecProperty().get()));
            inventory.put(InventoryItem.version, "1.1.1");
            inventory.put(InventoryItem.commitHash, "c07d47a8");
            inventory.put(InventoryItem.usedMemory, String.valueOf(Profiler.getUsedMemoryInBytes()));
            inventory.put(InventoryItem.jvmStartTime, String.valueOf(ManagementFactory.getRuntimeMXBean().getStartTime()));
            Filter filter = this.filterManager.getFilter();
            if (filter != null) {
                inventory.put(InventoryItem.filteredSeeds, Joiner.on("," + System.getProperty("line.separator")).join(filter.getSeedNodes()));
            }
            log.info("Send inventory {} to {}", (Object)inventory, (Object)connection.getPeersNodeAddressOptional());
            GetInventoryResponse getInventoryResponse = new GetInventoryResponse(inventory);
            this.networkNode.sendMessage(connection, (NetworkEnvelope)getInventoryResponse);
        }
    }

    public void shutDown() {
        this.networkNode.removeMessageListener(this);
    }

    private void addClassNameToMap(Map<InventoryItem, Integer> dataObjects, String className) {
        Optional<InventoryItem> optionalEnum = Enums.getIfPresent(InventoryItem.class, className);
        if (optionalEnum.isPresent()) {
            InventoryItem key = optionalEnum.get();
            dataObjects.putIfAbsent(key, 0);
            int prev = dataObjects.get((Object)key);
            dataObjects.put(key, prev + 1);
        }
    }
}

