/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.network.p2p.inventory.model;

import haveno.common.util.Tuple2;
import haveno.core.network.p2p.inventory.model.DeviationByIntegerDiff;
import haveno.core.network.p2p.inventory.model.DeviationByPercentage;
import haveno.core.network.p2p.inventory.model.DeviationOfHashes;
import haveno.core.network.p2p.inventory.model.DeviationSeverity;
import haveno.core.network.p2p.inventory.model.DeviationType;
import haveno.core.network.p2p.inventory.model.RequestInfo;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum InventoryItem {
    OfferPayload("OfferPayload", true, new DeviationByPercentage(0.5, 1.5, 0.75, 1.25), 10),
    MailboxStoragePayload("MailboxStoragePayload", true, new DeviationByPercentage(0.9, 1.1, 0.95, 1.05), 2),
    TradeStatistics3("TradeStatistics3", true, new DeviationByPercentage(0.9, 1.1, 0.95, 1.05), 2),
    AccountAgeWitness("AccountAgeWitness", true, new DeviationByPercentage(0.9, 1.1, 0.95, 1.05), 2),
    SignedWitness("SignedWitness", true, new DeviationByPercentage(0.9, 1.1, 0.95, 1.05), 2),
    Alert("Alert", true, new DeviationByIntegerDiff(1, 1), 2),
    Filter("Filter", true, new DeviationByIntegerDiff(1, 1), 2),
    Mediator("Mediator", true, new DeviationByIntegerDiff(1, 1), 2),
    RefundAgent("RefundAgent", true, new DeviationByIntegerDiff(1, 1), 2),
    maxConnections("maxConnections", true, new DeviationByPercentage(0.33, 3.0, 0.4, 2.5), 2),
    numConnections("numConnections", true, new DeviationByPercentage(0.0, 3.0, 0.0, 2.5), 2),
    peakNumConnections("peakNumConnections", true, new DeviationByPercentage(0.0, 3.0, 0.0, 2.5), 2),
    numAllConnectionsLostEvents("numAllConnectionsLostEvents", true, new DeviationByIntegerDiff(1, 2), 1),
    sentBytesPerSec("sentBytesPerSec", true, new DeviationByPercentage(), 5),
    receivedBytesPerSec("receivedBytesPerSec", true, new DeviationByPercentage(), 5),
    receivedMessagesPerSec("receivedMessagesPerSec", true, new DeviationByPercentage(), 5),
    sentMessagesPerSec("sentMessagesPerSec", true, new DeviationByPercentage(), 5),
    sentBytes("sentBytes", true),
    receivedBytes("receivedBytes", true),
    version("version", false),
    commitHash("commitHash", false),
    usedMemory("usedMemory", true),
    jvmStartTime("jvmStartTime", true),
    filteredSeeds("filteredSeeds", false);

    private final String key;
    private final boolean isNumberValue;
    @Nullable
    private DeviationType deviationType;
    private int deviationTolerance = 1;

    private InventoryItem(String key, boolean isNumberValue) {
        this.key = key;
        this.isNumberValue = isNumberValue;
    }

    private InventoryItem(@NotNull String key, boolean isNumberValue, DeviationType deviationType, int deviationTolerance) {
        this(key, isNumberValue);
        this.deviationType = deviationType;
        this.deviationTolerance = deviationTolerance;
    }

    @Nullable
    public Tuple2<Double, Double> getDeviationAndAverage(Map<InventoryItem, Double> averageValues, @Nullable String value) {
        if (averageValues.containsKey((Object)this) && value != null) {
            double averageValue = averageValues.get((Object)this);
            return new Tuple2<Double, Double>(this.getDeviation(value, averageValue), averageValue);
        }
        return null;
    }

    @Nullable
    public Double getDeviation(@Nullable String value, double average) {
        if (this.deviationType != null && value != null && average != 0.0 && this.isNumberValue) {
            return Double.parseDouble(value) / average;
        }
        return null;
    }

    public DeviationSeverity getDeviationSeverity(Double deviation, Collection<List<RequestInfo>> collection, @Nullable String value) {
        if (this.deviationType == null || deviation == null || value == null) {
            return DeviationSeverity.OK;
        }
        if (this.deviationType instanceof DeviationByPercentage) {
            return ((DeviationByPercentage)this.deviationType).getDeviationSeverity(deviation);
        }
        if (this.deviationType instanceof DeviationByIntegerDiff) {
            return ((DeviationByIntegerDiff)this.deviationType).getDeviationSeverity(collection, value, this);
        }
        if (this.deviationType instanceof DeviationOfHashes) {
            return ((DeviationOfHashes)this.deviationType).getDeviationSeverity(collection, value, this);
        }
        return DeviationSeverity.OK;
    }

    public String getKey() {
        return this.key;
    }

    public boolean isNumberValue() {
        return this.isNumberValue;
    }

    @Nullable
    public DeviationType getDeviationType() {
        return this.deviationType;
    }

    public int getDeviationTolerance() {
        return this.deviationTolerance;
    }
}

