/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.network.p2p.inventory.model;

import haveno.core.network.p2p.inventory.model.DeviationSeverity;
import haveno.core.network.p2p.inventory.model.InventoryItem;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class RequestInfo {
    public static final String COMMIT_HASH = "c07d47a8";
    private final long requestStartTime;
    private long responseTime;
    @Nullable
    private String errorMessage;
    private final Map<InventoryItem, Data> dataMap = new HashMap<InventoryItem, Data>();

    public RequestInfo(long requestStartTime) {
        this.requestStartTime = requestStartTime;
    }

    public String getDisplayValue(InventoryItem inventoryItem) {
        String value = this.getValue(inventoryItem);
        return value != null ? value : "n/a";
    }

    @Nullable
    public String getValue(InventoryItem inventoryItem) {
        return this.dataMap.containsKey((Object)inventoryItem) ? this.dataMap.get((Object)inventoryItem).getValue() : null;
    }

    public boolean hasError() {
        return this.errorMessage != null && !this.errorMessage.isEmpty();
    }

    public long getRequestStartTime() {
        return this.requestStartTime;
    }

    public long getResponseTime() {
        return this.responseTime;
    }

    @Nullable
    public String getErrorMessage() {
        return this.errorMessage;
    }

    public Map<InventoryItem, Data> getDataMap() {
        return this.dataMap;
    }

    public void setResponseTime(long responseTime) {
        this.responseTime = responseTime;
    }

    public void setErrorMessage(@Nullable String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public static final class Data {
        private final String value;
        @Nullable
        private final Double average;
        private final Double deviation;
        private final DeviationSeverity deviationSeverity;
        private final boolean persistentWarning;
        private final boolean persistentAlert;

        public Data(String value, @Nullable Double average, Double deviation, DeviationSeverity deviationSeverity, boolean persistentWarning, boolean persistentAlert) {
            this.value = value;
            this.average = average;
            this.deviation = deviation;
            this.deviationSeverity = deviationSeverity;
            this.persistentWarning = persistentWarning;
            this.persistentAlert = persistentAlert;
        }

        public String toString() {
            return "InventoryData{\n     value='" + this.value + "',\n     average=" + this.average + ",\n     deviation=" + this.deviation + ",\n     deviationSeverity=" + String.valueOf((Object)this.deviationSeverity) + ",\n     persistentWarning=" + this.persistentWarning + ",\n     persistentAlert=" + this.persistentAlert + "\n}";
        }

        public String getValue() {
            return this.value;
        }

        @Nullable
        public Double getAverage() {
            return this.average;
        }

        public Double getDeviation() {
            return this.deviation;
        }

        public DeviationSeverity getDeviationSeverity() {
            return this.deviationSeverity;
        }

        public boolean isPersistentWarning() {
            return this.persistentWarning;
        }

        public boolean isPersistentAlert() {
            return this.persistentAlert;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Data)) {
                return false;
            }
            Data other = (Data)o;
            if (this.isPersistentWarning() != other.isPersistentWarning()) {
                return false;
            }
            if (this.isPersistentAlert() != other.isPersistentAlert()) {
                return false;
            }
            Double this$average = this.getAverage();
            Double other$average = other.getAverage();
            if (this$average == null ? other$average != null : !((Object)this$average).equals(other$average)) {
                return false;
            }
            Double this$deviation = this.getDeviation();
            Double other$deviation = other.getDeviation();
            if (this$deviation == null ? other$deviation != null : !((Object)this$deviation).equals(other$deviation)) {
                return false;
            }
            String this$value = this.getValue();
            String other$value = other.getValue();
            if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
                return false;
            }
            DeviationSeverity this$deviationSeverity = this.getDeviationSeverity();
            DeviationSeverity other$deviationSeverity = other.getDeviationSeverity();
            return !(this$deviationSeverity == null ? other$deviationSeverity != null : !((Object)((Object)this$deviationSeverity)).equals((Object)other$deviationSeverity));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isPersistentWarning() ? 79 : 97);
            result = result * 59 + (this.isPersistentAlert() ? 79 : 97);
            Double $average = this.getAverage();
            result = result * 59 + ($average == null ? 43 : ((Object)$average).hashCode());
            Double $deviation = this.getDeviation();
            result = result * 59 + ($deviation == null ? 43 : ((Object)$deviation).hashCode());
            String $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            DeviationSeverity $deviationSeverity = this.getDeviationSeverity();
            result = result * 59 + ($deviationSeverity == null ? 43 : ((Object)((Object)$deviationSeverity)).hashCode());
            return result;
        }
    }
}

