/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.notifications;

import haveno.common.util.JsonExclude;
import haveno.core.notifications.MobileMessageType;
import java.util.Date;

public final class MobileMessage {
    private final long sentDate;
    private final String txId;
    private final String title;
    private final String message;
    @JsonExclude
    private final transient MobileMessageType mobileMessageType;
    private final String type;
    private final String actionRequired;
    private final int version;

    public MobileMessage(String title, String message, MobileMessageType mobileMessageType) {
        this(title, message, "", mobileMessageType);
    }

    public MobileMessage(String title, String message, String txId, MobileMessageType mobileMessageType) {
        this.title = title;
        this.message = message;
        this.txId = txId;
        this.mobileMessageType = mobileMessageType;
        this.type = mobileMessageType.name();
        this.actionRequired = "";
        this.sentDate = new Date().getTime();
        this.version = 1;
    }

    public long getSentDate() {
        return this.sentDate;
    }

    public String getTxId() {
        return this.txId;
    }

    public String getTitle() {
        return this.title;
    }

    public String getMessage() {
        return this.message;
    }

    public MobileMessageType getMobileMessageType() {
        return this.mobileMessageType;
    }

    public String getType() {
        return this.type;
    }

    public String getActionRequired() {
        return this.actionRequired;
    }

    public int getVersion() {
        return this.version;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MobileMessage)) {
            return false;
        }
        MobileMessage other = (MobileMessage)o;
        if (this.getSentDate() != other.getSentDate()) {
            return false;
        }
        if (this.getVersion() != other.getVersion()) {
            return false;
        }
        String this$txId = this.getTxId();
        String other$txId = other.getTxId();
        if (this$txId == null ? other$txId != null : !this$txId.equals(other$txId)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$actionRequired = this.getActionRequired();
        String other$actionRequired = other.getActionRequired();
        return !(this$actionRequired == null ? other$actionRequired != null : !this$actionRequired.equals(other$actionRequired));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $sentDate = this.getSentDate();
        result = result * 59 + (int)($sentDate >>> 32 ^ $sentDate);
        result = result * 59 + this.getVersion();
        String $txId = this.getTxId();
        result = result * 59 + ($txId == null ? 43 : $txId.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $actionRequired = this.getActionRequired();
        result = result * 59 + ($actionRequired == null ? 43 : $actionRequired.hashCode());
        return result;
    }

    public String toString() {
        return "MobileMessage(sentDate=" + this.getSentDate() + ", txId=" + this.getTxId() + ", title=" + this.getTitle() + ", message=" + this.getMessage() + ", mobileMessageType=" + String.valueOf((Object)this.getMobileMessageType()) + ", type=" + this.getType() + ", actionRequired=" + this.getActionRequired() + ", version=" + this.getVersion() + ")";
    }
}

