/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.notifications.alerts;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import haveno.core.locale.Res;
import haveno.core.notifications.MobileMessage;
import haveno.core.notifications.MobileMessageType;
import haveno.core.notifications.MobileNotificationService;
import haveno.core.support.SupportType;
import haveno.core.support.dispute.Dispute;
import haveno.core.support.dispute.mediation.MediationManager;
import haveno.core.support.dispute.refund.RefundManager;
import haveno.core.support.messages.ChatMessage;
import haveno.network.p2p.P2PService;
import java.util.UUID;
import javafx.collections.ObservableList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DisputeMsgEvents {
    private static final Logger log = LoggerFactory.getLogger(DisputeMsgEvents.class);
    private final RefundManager refundManager;
    private final MediationManager mediationManager;
    private final P2PService p2PService;
    private final MobileNotificationService mobileNotificationService;

    @Inject
    public DisputeMsgEvents(RefundManager refundManager, MediationManager mediationManager, P2PService p2PService, MobileNotificationService mobileNotificationService) {
        this.refundManager = refundManager;
        this.mediationManager = mediationManager;
        this.p2PService = p2PService;
        this.mobileNotificationService = mobileNotificationService;
    }

    public void onAllServicesInitialized() {
        this.refundManager.getDisputesAsObservableList().addListener(c -> {
            c.next();
            if (c.wasAdded()) {
                c.getAddedSubList().forEach(this::setDisputeListener);
            }
        });
        this.refundManager.getDisputesAsObservableList().forEach(this::setDisputeListener);
        this.mediationManager.getDisputesAsObservableList().addListener(c -> {
            c.next();
            if (c.wasAdded()) {
                c.getAddedSubList().forEach(this::setDisputeListener);
            }
        });
        this.mediationManager.getDisputesAsObservableList().forEach(this::setDisputeListener);
    }

    public static MobileMessage getTestMsg() {
        String shortId = UUID.randomUUID().toString().substring(0, 8);
        return new MobileMessage(Res.get("account.notifications.dispute.message.title"), Res.get("account.notifications.dispute.message.msg", shortId), shortId, MobileMessageType.DISPUTE);
    }

    private void setDisputeListener(Dispute dispute) {
        log.debug("We got a dispute added. id={}, tradeId={}", (Object)dispute.getId(), (Object)dispute.getTradeId());
        dispute.getChatMessages().addListener(c -> {
            log.debug("We got a ChatMessage added. id={}, tradeId={}", (Object)dispute.getId(), (Object)dispute.getTradeId());
            c.next();
            if (c.wasAdded()) {
                c.getAddedSubList().forEach(chatMessage -> this.onChatMessage((ChatMessage)chatMessage, dispute));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onChatMessage(ChatMessage chatMessage, Dispute dispute) {
        if (chatMessage.getSenderNodeAddress().equals(this.p2PService.getAddress())) {
            return;
        }
        String shortId = chatMessage.getShortId();
        MobileMessage message = new MobileMessage(Res.get("account.notifications.dispute.message.title"), Res.get("account.notifications.dispute.message.msg", shortId), shortId, MobileMessageType.DISPUTE);
        try {
            this.mobileNotificationService.sendMessage(message);
        }
        catch (Exception e) {
            log.error(e.toString());
            e.printStackTrace();
        }
        ObservableList<ChatMessage> observableList = dispute.getChatMessages();
        synchronized (observableList) {
            ObservableList<ChatMessage> chatMessages = dispute.getChatMessages();
            if (dispute.isClosed() && !chatMessages.isEmpty() && !((ChatMessage)chatMessages.get(chatMessages.size() - 1)).isResultMessage(dispute)) {
                dispute.reOpen();
                if (dispute.getSupportType() == SupportType.MEDIATION) {
                    this.mediationManager.requestPersistence();
                } else if (dispute.getSupportType() == SupportType.REFUND) {
                    this.refundManager.requestPersistence();
                }
            }
        }
    }
}

