/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.notifications.alerts;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import haveno.core.locale.Res;
import haveno.core.notifications.MobileMessage;
import haveno.core.notifications.MobileMessageType;
import haveno.core.notifications.MobileNotificationService;
import haveno.core.offer.OpenOffer;
import haveno.core.offer.OpenOfferManager;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class MyOfferTakenEvents {
    private static final Logger log = LoggerFactory.getLogger(MyOfferTakenEvents.class);
    private final OpenOfferManager openOfferManager;
    private final MobileNotificationService mobileNotificationService;

    @Inject
    public MyOfferTakenEvents(OpenOfferManager openOfferManager, MobileNotificationService mobileNotificationService) {
        this.openOfferManager = openOfferManager;
        this.mobileNotificationService = mobileNotificationService;
    }

    public void onAllServicesInitialized() {
        this.openOfferManager.getObservableList().addListener(c -> {
            c.next();
            if (c.wasRemoved()) {
                c.getRemoved().forEach(this::onOpenOfferRemoved);
            }
        });
        this.openOfferManager.getObservableList().forEach(this::onOpenOfferRemoved);
    }

    private void onOpenOfferRemoved(OpenOffer openOffer) {
        OpenOffer.State state = openOffer.getState();
        if (state == OpenOffer.State.RESERVED) {
            log.info("We got a offer removed. id={}, state={}", (Object)openOffer.getId(), (Object)state);
            String shortId = openOffer.getShortId();
            MobileMessage message = new MobileMessage(Res.get("account.notifications.offer.message.title"), Res.get("account.notifications.offer.message.msg", shortId), shortId, MobileMessageType.OFFER);
            try {
                this.mobileNotificationService.sendMessage(message);
            }
            catch (Exception e) {
                log.error(e.toString());
                e.printStackTrace();
            }
        }
    }

    public static MobileMessage getTestMsg() {
        String shortId = UUID.randomUUID().toString().substring(0, 8);
        return new MobileMessage(Res.get("account.notifications.offer.message.title"), Res.get("account.notifications.offer.message.msg", shortId), shortId, MobileMessageType.OFFER);
    }
}

