/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.notifications.alerts;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import haveno.common.crypto.PubKeyRingProvider;
import haveno.core.locale.Res;
import haveno.core.notifications.MobileMessage;
import haveno.core.notifications.MobileMessageType;
import haveno.core.notifications.MobileNotificationService;
import haveno.core.trade.Trade;
import haveno.core.trade.TradeManager;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class TradeEvents {
    private static final Logger log = LoggerFactory.getLogger(TradeEvents.class);
    private final PubKeyRingProvider pubKeyRingProvider;
    private final TradeManager tradeManager;
    private final MobileNotificationService mobileNotificationService;
    private boolean isInitialized = false;

    @Inject
    public TradeEvents(TradeManager tradeManager, PubKeyRingProvider pubKeyRingProvider, MobileNotificationService mobileNotificationService) {
        this.tradeManager = tradeManager;
        this.mobileNotificationService = mobileNotificationService;
        this.pubKeyRingProvider = pubKeyRingProvider;
    }

    public void onAllServicesInitialized() {
        this.tradeManager.getObservableList().addListener(c -> {
            c.next();
            if (c.wasAdded()) {
                c.getAddedSubList().forEach(this::setTradePhaseListener);
            }
        });
        this.tradeManager.getObservableList().forEach(this::setTradePhaseListener);
        this.isInitialized = true;
    }

    private void setTradePhaseListener(Trade trade) {
        if (this.isInitialized) {
            log.info("We got a new trade. id={}", (Object)trade.getId());
        }
        if (!trade.isPayoutPublished()) {
            trade.statePhaseProperty().addListener((observable2, oldValue, newValue) -> {
                String msg = null;
                String shortId = trade.getShortId();
                switch (newValue) {
                    case INIT: 
                    case DEPOSIT_REQUESTED: 
                    case DEPOSITS_PUBLISHED: {
                        break;
                    }
                    case DEPOSITS_UNLOCKED: {
                        if (trade.getContract() == null || !this.pubKeyRingProvider.get().equals(trade.getContract().getBuyerPubKeyRing())) break;
                        msg = Res.get("account.notifications.trade.message.msg.conf", shortId);
                        break;
                    }
                    case PAYMENT_SENT: {
                        if (trade.getContract() == null || !this.pubKeyRingProvider.get().equals(trade.getContract().getSellerPubKeyRing())) break;
                        msg = Res.get("account.notifications.trade.message.msg.started", shortId);
                        break;
                    }
                    case PAYMENT_RECEIVED: {
                        if (trade.getContract() == null || !this.pubKeyRingProvider.get().equals(trade.getContract().getBuyerPubKeyRing())) break;
                        msg = Res.get("account.notifications.trade.message.msg.completed", shortId);
                    }
                }
                if (msg != null) {
                    MobileMessage message = new MobileMessage(Res.get("account.notifications.trade.message.title"), msg, shortId, MobileMessageType.TRADE);
                    try {
                        this.mobileNotificationService.sendMessage(message);
                    }
                    catch (Exception e) {
                        log.error(e.toString());
                        e.printStackTrace();
                    }
                }
            });
        }
    }

    public static List<MobileMessage> getTestMessages() {
        String shortId = UUID.randomUUID().toString().substring(0, 8);
        ArrayList<MobileMessage> list = new ArrayList<MobileMessage>();
        list.add(new MobileMessage(Res.get("account.notifications.trade.message.title"), Res.get("account.notifications.trade.message.msg.conf", shortId), shortId, MobileMessageType.TRADE));
        list.add(new MobileMessage(Res.get("account.notifications.trade.message.title"), Res.get("account.notifications.trade.message.msg.started", shortId), shortId, MobileMessageType.TRADE));
        list.add(new MobileMessage(Res.get("account.notifications.trade.message.title"), Res.get("account.notifications.trade.message.msg.completed", shortId), shortId, MobileMessageType.TRADE));
        return list;
    }
}

