/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.notifications.alerts.market;

import haveno.common.proto.persistable.PersistablePayload;
import haveno.core.payment.PaymentAccount;
import haveno.core.proto.CoreProtoResolver;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MarketAlertFilter
implements PersistablePayload {
    private static final Logger log = LoggerFactory.getLogger(MarketAlertFilter.class);
    private final PaymentAccount paymentAccount;
    private final int triggerValue;
    private final boolean isBuyOffer;
    private final List<String> alertIds;

    public MarketAlertFilter(PaymentAccount paymentAccount, int triggerValue, boolean isBuyOffer) {
        this(paymentAccount, triggerValue, isBuyOffer, new ArrayList<String>());
    }

    private MarketAlertFilter(PaymentAccount paymentAccount, int triggerValue, boolean isBuyOffer, List<String> alertIds) {
        this.paymentAccount = paymentAccount;
        this.triggerValue = triggerValue;
        this.isBuyOffer = isBuyOffer;
        this.alertIds = alertIds;
    }

    @Override
    public protobuf.MarketAlertFilter toProtoMessage() {
        return protobuf.MarketAlertFilter.newBuilder().setPaymentAccount(this.paymentAccount.toProtoMessage()).setTriggerValue(this.triggerValue).setIsBuyOffer(this.isBuyOffer).addAllAlertIds(this.alertIds).build();
    }

    public static MarketAlertFilter fromProto(protobuf.MarketAlertFilter proto, CoreProtoResolver coreProtoResolver) {
        ArrayList<String> list = proto.getAlertIdsList().isEmpty() ? new ArrayList<String>() : new ArrayList<String>(proto.getAlertIdsList());
        return new MarketAlertFilter(PaymentAccount.fromProto(proto.getPaymentAccount(), coreProtoResolver), proto.getTriggerValue(), proto.getIsBuyOffer(), list);
    }

    public void addAlertId(String alertId) {
        if (this.notContainsAlertId(alertId)) {
            this.alertIds.add(alertId);
        }
    }

    public boolean notContainsAlertId(String alertId) {
        return !this.alertIds.contains(alertId);
    }

    public String toString() {
        return "MarketAlertFilter{\n     paymentAccount=" + String.valueOf(this.paymentAccount) + ",\n     triggerValue=" + this.triggerValue + ",\n     isBuyOffer=" + this.isBuyOffer + ",\n     alertIds=" + String.valueOf(this.alertIds) + "\n}";
    }

    public PaymentAccount getPaymentAccount() {
        return this.paymentAccount;
    }

    public int getTriggerValue() {
        return this.triggerValue;
    }

    public boolean isBuyOffer() {
        return this.isBuyOffer;
    }

    public List<String> getAlertIds() {
        return this.alertIds;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MarketAlertFilter)) {
            return false;
        }
        MarketAlertFilter other = (MarketAlertFilter)o;
        if (this.getTriggerValue() != other.getTriggerValue()) {
            return false;
        }
        if (this.isBuyOffer() != other.isBuyOffer()) {
            return false;
        }
        PaymentAccount this$paymentAccount = this.getPaymentAccount();
        PaymentAccount other$paymentAccount = other.getPaymentAccount();
        if (this$paymentAccount == null ? other$paymentAccount != null : !((Object)this$paymentAccount).equals(other$paymentAccount)) {
            return false;
        }
        List<String> this$alertIds = this.getAlertIds();
        List<String> other$alertIds = other.getAlertIds();
        return !(this$alertIds == null ? other$alertIds != null : !((Object)this$alertIds).equals(other$alertIds));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getTriggerValue();
        result = result * 59 + (this.isBuyOffer() ? 79 : 97);
        PaymentAccount $paymentAccount = this.getPaymentAccount();
        result = result * 59 + ($paymentAccount == null ? 43 : ((Object)$paymentAccount).hashCode());
        List<String> $alertIds = this.getAlertIds();
        result = result * 59 + ($alertIds == null ? 43 : ((Object)$alertIds).hashCode());
        return result;
    }
}

