/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.offer;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.protobuf.ByteString;
import haveno.common.crypto.Hash;
import haveno.common.crypto.PubKeyRing;
import haveno.common.proto.ProtoUtil;
import haveno.common.util.CollectionUtils;
import haveno.common.util.Hex;
import haveno.common.util.JsonExclude;
import haveno.common.util.Utilities;
import haveno.core.offer.OfferDirection;
import haveno.core.trade.HavenoUtils;
import haveno.core.xmr.wallet.Restrictions;
import haveno.network.p2p.NodeAddress;
import haveno.network.p2p.storage.payload.ExpirablePayload;
import haveno.network.p2p.storage.payload.ProtectedStoragePayload;
import haveno.network.p2p.storage.payload.RequiresOwnerIsOnlinePayload;
import java.lang.reflect.Type;
import java.math.BigInteger;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import protobuf.OfferPayload;
import protobuf.StoragePayload;

public final class OfferPayload
implements ProtectedStoragePayload,
ExpirablePayload,
RequiresOwnerIsOnlinePayload {
    private static final Logger log = LoggerFactory.getLogger(OfferPayload.class);
    public static final long TTL = TimeUnit.MINUTES.toMillis(11L);
    protected final String id;
    protected final long date;
    protected final String baseCurrencyCode;
    protected final String counterCurrencyCode;
    protected final long price;
    protected final long amount;
    protected final long minAmount;
    protected final String paymentMethodId;
    protected final String makerPaymentAccountId;
    protected final NodeAddress ownerNodeAddress;
    protected final OfferDirection direction;
    protected final String versionNr;
    protected final int protocolVersion;
    @JsonExclude
    protected final PubKeyRing pubKeyRing;
    protected transient byte[] hash;
    @Nullable
    protected final Map<String, String> extraDataMap;
    @Nullable
    protected NodeAddress arbitratorSigner;
    @Nullable
    protected byte[] arbitratorSignature;
    @Nullable
    protected List<String> reserveTxKeyImages;
    public static final String ACCOUNT_AGE_WITNESS_HASH = "accountAgeWitnessHash";
    public static final String CASHAPP_EXTRA_INFO = "cashAppExtraInfo";
    public static final String REFERRAL_ID = "referralId";
    public static final String F2F_CITY = "f2fCity";
    public static final String F2F_EXTRA_INFO = "f2fExtraInfo";
    public static final String PAY_BY_MAIL_EXTRA_INFO = "payByMailExtraInfo";
    public static final String AUSTRALIA_PAYID_EXTRA_INFO = "australiaPayidExtraInfo";
    public static final String PAYPAL_EXTRA_INFO = "payPalExtraInfo";
    public static final String CASH_AT_ATM_EXTRA_INFO = "cashAtAtmExtraInfo";
    public static final String CAPABILITIES = "capabilities";
    public static final String XMR_AUTO_CONF = "xmrAutoConf";
    public static final String XMR_AUTO_CONF_ENABLED_VALUE = "1";
    private final double marketPriceMarginPct;
    private final boolean useMarketBasedPrice;
    @Nullable
    private final String countryCode;
    @Nullable
    private final List<String> acceptedCountryCodes;
    @Nullable
    private final String bankId;
    @Nullable
    private final List<String> acceptedBankIds;
    private final long blockHeightAtOfferCreation;
    private final double makerFeePct;
    private final double takerFeePct;
    private final double penaltyFeePct;
    private final double buyerSecurityDepositPct;
    private final double sellerSecurityDepositPct;
    private final long maxTradeLimit;
    private final long maxTradePeriod;
    private final boolean useAutoClose;
    private final boolean useReOpenAfterAutoClose;
    private final long lowerClosePrice;
    private final long upperClosePrice;
    private final boolean isPrivateOffer;
    @Nullable
    private final String challengeHash;
    @Nullable
    private final String extraInfo;

    public OfferPayload(String id, long date, @Nullable NodeAddress ownerNodeAddress, PubKeyRing pubKeyRing, OfferDirection direction, long price, double marketPriceMarginPct, boolean useMarketBasedPrice, long amount, long minAmount, double makerFeePct, double takerFeePct, double penaltyFeePct, double buyerSecurityDepositPct, double sellerSecurityDepositPct, String baseCurrencyCode, String counterCurrencyCode, String paymentMethodId, String makerPaymentAccountId, @Nullable String countryCode, @Nullable List<String> acceptedCountryCodes, @Nullable String bankId, @Nullable List<String> acceptedBankIds, String versionNr, long blockHeightAtOfferCreation, long maxTradeLimit, long maxTradePeriod, boolean useAutoClose, boolean useReOpenAfterAutoClose, long lowerClosePrice, long upperClosePrice, boolean isPrivateOffer, @Nullable String challengeHash, @Nullable Map<String, String> extraDataMap, int protocolVersion, @Nullable NodeAddress arbitratorSigner, @Nullable byte[] arbitratorSignature, @Nullable List<String> reserveTxKeyImages, @Nullable String extraInfo) {
        this.id = id;
        this.date = date;
        this.ownerNodeAddress = ownerNodeAddress;
        this.pubKeyRing = pubKeyRing;
        this.baseCurrencyCode = baseCurrencyCode;
        this.counterCurrencyCode = counterCurrencyCode;
        this.direction = direction;
        this.price = price;
        this.amount = amount;
        this.minAmount = minAmount;
        this.makerFeePct = makerFeePct;
        this.takerFeePct = takerFeePct;
        this.penaltyFeePct = penaltyFeePct;
        this.buyerSecurityDepositPct = buyerSecurityDepositPct;
        this.sellerSecurityDepositPct = sellerSecurityDepositPct;
        this.paymentMethodId = paymentMethodId;
        this.makerPaymentAccountId = makerPaymentAccountId;
        this.extraDataMap = extraDataMap;
        this.versionNr = versionNr;
        this.protocolVersion = protocolVersion;
        this.arbitratorSigner = arbitratorSigner;
        this.arbitratorSignature = arbitratorSignature;
        this.reserveTxKeyImages = reserveTxKeyImages;
        this.marketPriceMarginPct = marketPriceMarginPct;
        this.useMarketBasedPrice = useMarketBasedPrice;
        this.countryCode = countryCode;
        this.acceptedCountryCodes = acceptedCountryCodes;
        this.bankId = bankId;
        this.acceptedBankIds = acceptedBankIds;
        this.blockHeightAtOfferCreation = blockHeightAtOfferCreation;
        this.maxTradeLimit = maxTradeLimit;
        this.maxTradePeriod = maxTradePeriod;
        this.useAutoClose = useAutoClose;
        this.useReOpenAfterAutoClose = useReOpenAfterAutoClose;
        this.lowerClosePrice = lowerClosePrice;
        this.upperClosePrice = upperClosePrice;
        this.isPrivateOffer = isPrivateOffer;
        this.challengeHash = challengeHash;
        this.extraInfo = extraInfo;
    }

    public byte[] getHash() {
        if (this.hash == null) {
            this.hash = Hash.getSha256Hash(this.toProtoMessage().toByteArray());
        }
        return this.hash;
    }

    public byte[] getSignatureHash() {
        OfferPayload signee = new OfferPayload(this.id, this.date, null, this.pubKeyRing, this.direction, this.price, 0.0, false, this.amount, this.minAmount, this.makerFeePct, this.takerFeePct, this.penaltyFeePct, this.buyerSecurityDepositPct, this.sellerSecurityDepositPct, this.baseCurrencyCode, this.counterCurrencyCode, this.paymentMethodId, this.makerPaymentAccountId, this.countryCode, this.acceptedCountryCodes, this.bankId, this.acceptedBankIds, this.versionNr, this.blockHeightAtOfferCreation, this.maxTradeLimit, this.maxTradePeriod, this.useAutoClose, this.useReOpenAfterAutoClose, this.lowerClosePrice, this.upperClosePrice, this.isPrivateOffer, this.challengeHash, this.extraDataMap, this.protocolVersion, this.arbitratorSigner, null, this.reserveTxKeyImages, null);
        return signee.getHash();
    }

    @Override
    public long getTTL() {
        return TTL;
    }

    @Override
    public PublicKey getOwnerPubKey() {
        return this.pubKeyRing.getSignaturePubKey();
    }

    public String getCurrencyCode() {
        return this.getBaseCurrencyCode().equals("XMR") ? this.getCounterCurrencyCode() : this.getBaseCurrencyCode();
    }

    public BigInteger getMaxMakerFee() {
        return HavenoUtils.multiply(BigInteger.valueOf(this.getAmount()), this.getMakerFeePct());
    }

    public BigInteger getMaxBuyerSecurityDeposit() {
        return this.getBuyerSecurityDepositForTradeAmount(BigInteger.valueOf(this.getAmount()));
    }

    public BigInteger getMaxSellerSecurityDeposit() {
        return this.getSellerSecurityDepositForTradeAmount(BigInteger.valueOf(this.getAmount()));
    }

    public BigInteger getBuyerSecurityDepositForTradeAmount(BigInteger tradeAmount) {
        boolean isBuyerTaker;
        BigInteger securityDepositUnadjusted = HavenoUtils.multiply(tradeAmount, this.getBuyerSecurityDepositPct());
        boolean bl = isBuyerTaker = this.getDirection() == OfferDirection.SELL;
        if (this.isPrivateOffer() && isBuyerTaker) {
            return securityDepositUnadjusted;
        }
        return Restrictions.getMinSecurityDeposit().max(securityDepositUnadjusted);
    }

    public BigInteger getSellerSecurityDepositForTradeAmount(BigInteger tradeAmount) {
        BigInteger securityDepositUnadjusted = HavenoUtils.multiply(tradeAmount, this.getSellerSecurityDepositPct());
        return Restrictions.getMinSecurityDeposit().max(securityDepositUnadjusted);
    }

    public boolean isBuyerAsTakerWithoutDeposit() {
        return this.getDirection() == OfferDirection.SELL && this.getBuyerSecurityDepositPct() == 0.0;
    }

    @Override
    public StoragePayload toProtoMessage() {
        OfferPayload.Builder builder = protobuf.OfferPayload.newBuilder().setId(this.id).setDate(this.date).setPubKeyRing(this.pubKeyRing.toProtoMessage()).setDirection(OfferDirection.toProtoMessage(this.direction)).setPrice(this.price).setMarketPriceMarginPct(this.marketPriceMarginPct).setUseMarketBasedPrice(this.useMarketBasedPrice).setAmount(this.amount).setMinAmount(this.minAmount).setMakerFeePct(this.makerFeePct).setTakerFeePct(this.takerFeePct).setPenaltyFeePct(this.penaltyFeePct).setBuyerSecurityDepositPct(this.buyerSecurityDepositPct).setSellerSecurityDepositPct(this.sellerSecurityDepositPct).setBaseCurrencyCode(this.baseCurrencyCode).setCounterCurrencyCode(this.counterCurrencyCode).setPaymentMethodId(this.paymentMethodId).setMakerPaymentAccountId(this.makerPaymentAccountId).setVersionNr(this.versionNr).setBlockHeightAtOfferCreation(this.blockHeightAtOfferCreation).setMaxTradeLimit(this.maxTradeLimit).setMaxTradePeriod(this.maxTradePeriod).setUseAutoClose(this.useAutoClose).setUseReOpenAfterAutoClose(this.useReOpenAfterAutoClose).setLowerClosePrice(this.lowerClosePrice).setUpperClosePrice(this.upperClosePrice).setIsPrivateOffer(this.isPrivateOffer).setProtocolVersion(this.protocolVersion);
        Optional.ofNullable(this.ownerNodeAddress).ifPresent(e -> builder.setOwnerNodeAddress(this.ownerNodeAddress.toProtoMessage()));
        Optional.ofNullable(this.countryCode).ifPresent(builder::setCountryCode);
        Optional.ofNullable(this.bankId).ifPresent(builder::setBankId);
        Optional.ofNullable(this.acceptedBankIds).ifPresent(builder::addAllAcceptedBankIds);
        Optional.ofNullable(this.acceptedCountryCodes).ifPresent(builder::addAllAcceptedCountryCodes);
        Optional.ofNullable(this.challengeHash).ifPresent(builder::setChallengeHash);
        Optional.ofNullable(this.extraDataMap).ifPresent(builder::putAllExtraData);
        Optional.ofNullable(this.arbitratorSigner).ifPresent(e -> builder.setArbitratorSigner(this.arbitratorSigner.toProtoMessage()));
        Optional.ofNullable(this.arbitratorSignature).ifPresent(e -> builder.setArbitratorSignature(ByteString.copyFrom(e)));
        Optional.ofNullable(this.reserveTxKeyImages).ifPresent(builder::addAllReserveTxKeyImages);
        Optional.ofNullable(this.extraInfo).ifPresent(builder::setExtraInfo);
        return StoragePayload.newBuilder().setOfferPayload(builder).build();
    }

    public static OfferPayload fromProto(protobuf.OfferPayload proto) {
        ArrayList<String> acceptedBankIds = proto.getAcceptedBankIdsList().isEmpty() ? null : new ArrayList<String>(proto.getAcceptedBankIdsList());
        ArrayList<String> acceptedCountryCodes = proto.getAcceptedCountryCodesList().isEmpty() ? null : new ArrayList<String>(proto.getAcceptedCountryCodesList());
        ArrayList<String> reserveTxKeyImages = proto.getReserveTxKeyImagesList().isEmpty() ? null : new ArrayList<String>(proto.getReserveTxKeyImagesList());
        Map<String, String> extraDataMapMap = CollectionUtils.isEmpty(proto.getExtraDataMap()) ? null : proto.getExtraDataMap();
        return new OfferPayload(proto.getId(), proto.getDate(), proto.hasOwnerNodeAddress() ? NodeAddress.fromProto(proto.getOwnerNodeAddress()) : null, PubKeyRing.fromProto(proto.getPubKeyRing()), OfferDirection.fromProto(proto.getDirection()), proto.getPrice(), proto.getMarketPriceMarginPct(), proto.getUseMarketBasedPrice(), proto.getAmount(), proto.getMinAmount(), proto.getMakerFeePct(), proto.getTakerFeePct(), proto.getPenaltyFeePct(), proto.getBuyerSecurityDepositPct(), proto.getSellerSecurityDepositPct(), proto.getBaseCurrencyCode(), proto.getCounterCurrencyCode(), proto.getPaymentMethodId(), proto.getMakerPaymentAccountId(), ProtoUtil.stringOrNullFromProto(proto.getCountryCode()), acceptedCountryCodes, ProtoUtil.stringOrNullFromProto(proto.getBankId()), acceptedBankIds, proto.getVersionNr(), proto.getBlockHeightAtOfferCreation(), proto.getMaxTradeLimit(), proto.getMaxTradePeriod(), proto.getUseAutoClose(), proto.getUseReOpenAfterAutoClose(), proto.getLowerClosePrice(), proto.getUpperClosePrice(), proto.getIsPrivateOffer(), ProtoUtil.stringOrNullFromProto(proto.getChallengeHash()), extraDataMapMap, proto.getProtocolVersion(), proto.hasArbitratorSigner() ? NodeAddress.fromProto(proto.getArbitratorSigner()) : null, ProtoUtil.byteArrayOrNullFromProto(proto.getArbitratorSignature()), reserveTxKeyImages, ProtoUtil.stringOrNullFromProto(proto.getExtraInfo()));
    }

    public String toString() {
        return "OfferPayload{\r\n     id='" + this.id + "',\r\n     date=" + this.date + ",\r\n     baseCurrencyCode='" + this.baseCurrencyCode + "',\r\n     counterCurrencyCode='" + this.counterCurrencyCode + "',\r\n     price=" + this.price + ",\r\n     amount=" + this.amount + ",\r\n     minAmount=" + this.minAmount + ",\r\n     makerFeePct=" + this.makerFeePct + ",\r\n     takerFeePct=" + this.takerFeePct + ",\r\n     penaltyFeePct=" + this.penaltyFeePct + ",\r\n     buyerSecurityDepositPct=" + this.buyerSecurityDepositPct + ",\r\n     sellerSecurityDeposiPct=" + this.sellerSecurityDepositPct + ",\r\n     paymentMethodId='" + this.paymentMethodId + "',\r\n     makerPaymentAccountId='" + this.makerPaymentAccountId + "',\r\n     ownerNodeAddress=" + String.valueOf(this.ownerNodeAddress) + ",\r\n     direction=" + String.valueOf((Object)this.direction) + ",\r\n     versionNr='" + this.versionNr + "',\r\n     protocolVersion=" + this.protocolVersion + ",\r\n     pubKeyRing=" + String.valueOf(this.pubKeyRing) + ",\r\n     hash=" + (this.hash != null ? Hex.encode(this.hash) : "null") + ",\r\n     extraDataMap=" + String.valueOf(this.extraDataMap) + ",\r\n     reserveTxKeyImages=" + String.valueOf(this.reserveTxKeyImages) + ",\r\n     marketPriceMargin=" + this.marketPriceMarginPct + ",\r\n     useMarketBasedPrice=" + this.useMarketBasedPrice + ",\r\n     countryCode='" + this.countryCode + "',\r\n     acceptedCountryCodes=" + String.valueOf(this.acceptedCountryCodes) + ",\r\n     bankId='" + this.bankId + "',\r\n     acceptedBankIds=" + String.valueOf(this.acceptedBankIds) + ",\r\n     blockHeightAtOfferCreation=" + this.blockHeightAtOfferCreation + ",\r\n     maxTradeLimit=" + this.maxTradeLimit + ",\r\n     maxTradePeriod=" + this.maxTradePeriod + ",\r\n     useAutoClose=" + this.useAutoClose + ",\r\n     useReOpenAfterAutoClose=" + this.useReOpenAfterAutoClose + ",\r\n     lowerClosePrice=" + this.lowerClosePrice + ",\r\n     upperClosePrice=" + this.upperClosePrice + ",\r\n     isPrivateOffer=" + this.isPrivateOffer + ",\r\n     challengeHash='" + this.challengeHash + ",\r\n     arbitratorSigner=" + String.valueOf(this.arbitratorSigner) + ",\r\n     arbitratorSignature=" + Utilities.bytesAsHexString(this.arbitratorSignature) + ",\r\n     extraInfo='" + this.extraInfo + "\r\n} ";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OfferPayload)) {
            return false;
        }
        OfferPayload other = (OfferPayload)o;
        if (this.getDate() != other.getDate()) {
            return false;
        }
        if (this.getPrice() != other.getPrice()) {
            return false;
        }
        if (this.getAmount() != other.getAmount()) {
            return false;
        }
        if (this.getMinAmount() != other.getMinAmount()) {
            return false;
        }
        if (this.getProtocolVersion() != other.getProtocolVersion()) {
            return false;
        }
        if (Double.compare(this.getMarketPriceMarginPct(), other.getMarketPriceMarginPct()) != 0) {
            return false;
        }
        if (this.isUseMarketBasedPrice() != other.isUseMarketBasedPrice()) {
            return false;
        }
        if (this.getBlockHeightAtOfferCreation() != other.getBlockHeightAtOfferCreation()) {
            return false;
        }
        if (Double.compare(this.getMakerFeePct(), other.getMakerFeePct()) != 0) {
            return false;
        }
        if (Double.compare(this.getTakerFeePct(), other.getTakerFeePct()) != 0) {
            return false;
        }
        if (Double.compare(this.getPenaltyFeePct(), other.getPenaltyFeePct()) != 0) {
            return false;
        }
        if (Double.compare(this.getBuyerSecurityDepositPct(), other.getBuyerSecurityDepositPct()) != 0) {
            return false;
        }
        if (Double.compare(this.getSellerSecurityDepositPct(), other.getSellerSecurityDepositPct()) != 0) {
            return false;
        }
        if (this.getMaxTradeLimit() != other.getMaxTradeLimit()) {
            return false;
        }
        if (this.getMaxTradePeriod() != other.getMaxTradePeriod()) {
            return false;
        }
        if (this.isUseAutoClose() != other.isUseAutoClose()) {
            return false;
        }
        if (this.isUseReOpenAfterAutoClose() != other.isUseReOpenAfterAutoClose()) {
            return false;
        }
        if (this.getLowerClosePrice() != other.getLowerClosePrice()) {
            return false;
        }
        if (this.getUpperClosePrice() != other.getUpperClosePrice()) {
            return false;
        }
        if (this.isPrivateOffer() != other.isPrivateOffer()) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$baseCurrencyCode = this.getBaseCurrencyCode();
        String other$baseCurrencyCode = other.getBaseCurrencyCode();
        if (this$baseCurrencyCode == null ? other$baseCurrencyCode != null : !this$baseCurrencyCode.equals(other$baseCurrencyCode)) {
            return false;
        }
        String this$counterCurrencyCode = this.getCounterCurrencyCode();
        String other$counterCurrencyCode = other.getCounterCurrencyCode();
        if (this$counterCurrencyCode == null ? other$counterCurrencyCode != null : !this$counterCurrencyCode.equals(other$counterCurrencyCode)) {
            return false;
        }
        String this$paymentMethodId = this.getPaymentMethodId();
        String other$paymentMethodId = other.getPaymentMethodId();
        if (this$paymentMethodId == null ? other$paymentMethodId != null : !this$paymentMethodId.equals(other$paymentMethodId)) {
            return false;
        }
        String this$makerPaymentAccountId = this.getMakerPaymentAccountId();
        String other$makerPaymentAccountId = other.getMakerPaymentAccountId();
        if (this$makerPaymentAccountId == null ? other$makerPaymentAccountId != null : !this$makerPaymentAccountId.equals(other$makerPaymentAccountId)) {
            return false;
        }
        NodeAddress this$ownerNodeAddress = this.getOwnerNodeAddress();
        NodeAddress other$ownerNodeAddress = other.getOwnerNodeAddress();
        if (this$ownerNodeAddress == null ? other$ownerNodeAddress != null : !((Object)this$ownerNodeAddress).equals(other$ownerNodeAddress)) {
            return false;
        }
        OfferDirection this$direction = this.getDirection();
        OfferDirection other$direction = other.getDirection();
        if (this$direction == null ? other$direction != null : !((Object)((Object)this$direction)).equals((Object)other$direction)) {
            return false;
        }
        String this$versionNr = this.getVersionNr();
        String other$versionNr = other.getVersionNr();
        if (this$versionNr == null ? other$versionNr != null : !this$versionNr.equals(other$versionNr)) {
            return false;
        }
        PubKeyRing this$pubKeyRing = this.getPubKeyRing();
        PubKeyRing other$pubKeyRing = other.getPubKeyRing();
        if (this$pubKeyRing == null ? other$pubKeyRing != null : !((Object)this$pubKeyRing).equals(other$pubKeyRing)) {
            return false;
        }
        Map<String, String> this$extraDataMap = this.getExtraDataMap();
        Map<String, String> other$extraDataMap = other.getExtraDataMap();
        if (this$extraDataMap == null ? other$extraDataMap != null : !((Object)this$extraDataMap).equals(other$extraDataMap)) {
            return false;
        }
        NodeAddress this$arbitratorSigner = this.getArbitratorSigner();
        NodeAddress other$arbitratorSigner = other.getArbitratorSigner();
        if (this$arbitratorSigner == null ? other$arbitratorSigner != null : !((Object)this$arbitratorSigner).equals(other$arbitratorSigner)) {
            return false;
        }
        if (!Arrays.equals(this.getArbitratorSignature(), other.getArbitratorSignature())) {
            return false;
        }
        List<String> this$reserveTxKeyImages = this.getReserveTxKeyImages();
        List<String> other$reserveTxKeyImages = other.getReserveTxKeyImages();
        if (this$reserveTxKeyImages == null ? other$reserveTxKeyImages != null : !((Object)this$reserveTxKeyImages).equals(other$reserveTxKeyImages)) {
            return false;
        }
        String this$countryCode = this.getCountryCode();
        String other$countryCode = other.getCountryCode();
        if (this$countryCode == null ? other$countryCode != null : !this$countryCode.equals(other$countryCode)) {
            return false;
        }
        List<String> this$acceptedCountryCodes = this.getAcceptedCountryCodes();
        List<String> other$acceptedCountryCodes = other.getAcceptedCountryCodes();
        if (this$acceptedCountryCodes == null ? other$acceptedCountryCodes != null : !((Object)this$acceptedCountryCodes).equals(other$acceptedCountryCodes)) {
            return false;
        }
        String this$bankId = this.getBankId();
        String other$bankId = other.getBankId();
        if (this$bankId == null ? other$bankId != null : !this$bankId.equals(other$bankId)) {
            return false;
        }
        List<String> this$acceptedBankIds = this.getAcceptedBankIds();
        List<String> other$acceptedBankIds = other.getAcceptedBankIds();
        if (this$acceptedBankIds == null ? other$acceptedBankIds != null : !((Object)this$acceptedBankIds).equals(other$acceptedBankIds)) {
            return false;
        }
        String this$challengeHash = this.getChallengeHash();
        String other$challengeHash = other.getChallengeHash();
        if (this$challengeHash == null ? other$challengeHash != null : !this$challengeHash.equals(other$challengeHash)) {
            return false;
        }
        String this$extraInfo = this.getExtraInfo();
        String other$extraInfo = other.getExtraInfo();
        return !(this$extraInfo == null ? other$extraInfo != null : !this$extraInfo.equals(other$extraInfo));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $date = this.getDate();
        result = result * 59 + (int)($date >>> 32 ^ $date);
        long $price = this.getPrice();
        result = result * 59 + (int)($price >>> 32 ^ $price);
        long $amount = this.getAmount();
        result = result * 59 + (int)($amount >>> 32 ^ $amount);
        long $minAmount = this.getMinAmount();
        result = result * 59 + (int)($minAmount >>> 32 ^ $minAmount);
        result = result * 59 + this.getProtocolVersion();
        long $marketPriceMarginPct = Double.doubleToLongBits(this.getMarketPriceMarginPct());
        result = result * 59 + (int)($marketPriceMarginPct >>> 32 ^ $marketPriceMarginPct);
        result = result * 59 + (this.isUseMarketBasedPrice() ? 79 : 97);
        long $blockHeightAtOfferCreation = this.getBlockHeightAtOfferCreation();
        result = result * 59 + (int)($blockHeightAtOfferCreation >>> 32 ^ $blockHeightAtOfferCreation);
        long $makerFeePct = Double.doubleToLongBits(this.getMakerFeePct());
        result = result * 59 + (int)($makerFeePct >>> 32 ^ $makerFeePct);
        long $takerFeePct = Double.doubleToLongBits(this.getTakerFeePct());
        result = result * 59 + (int)($takerFeePct >>> 32 ^ $takerFeePct);
        long $penaltyFeePct = Double.doubleToLongBits(this.getPenaltyFeePct());
        result = result * 59 + (int)($penaltyFeePct >>> 32 ^ $penaltyFeePct);
        long $buyerSecurityDepositPct = Double.doubleToLongBits(this.getBuyerSecurityDepositPct());
        result = result * 59 + (int)($buyerSecurityDepositPct >>> 32 ^ $buyerSecurityDepositPct);
        long $sellerSecurityDepositPct = Double.doubleToLongBits(this.getSellerSecurityDepositPct());
        result = result * 59 + (int)($sellerSecurityDepositPct >>> 32 ^ $sellerSecurityDepositPct);
        long $maxTradeLimit = this.getMaxTradeLimit();
        result = result * 59 + (int)($maxTradeLimit >>> 32 ^ $maxTradeLimit);
        long $maxTradePeriod = this.getMaxTradePeriod();
        result = result * 59 + (int)($maxTradePeriod >>> 32 ^ $maxTradePeriod);
        result = result * 59 + (this.isUseAutoClose() ? 79 : 97);
        result = result * 59 + (this.isUseReOpenAfterAutoClose() ? 79 : 97);
        long $lowerClosePrice = this.getLowerClosePrice();
        result = result * 59 + (int)($lowerClosePrice >>> 32 ^ $lowerClosePrice);
        long $upperClosePrice = this.getUpperClosePrice();
        result = result * 59 + (int)($upperClosePrice >>> 32 ^ $upperClosePrice);
        result = result * 59 + (this.isPrivateOffer() ? 79 : 97);
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $baseCurrencyCode = this.getBaseCurrencyCode();
        result = result * 59 + ($baseCurrencyCode == null ? 43 : $baseCurrencyCode.hashCode());
        String $counterCurrencyCode = this.getCounterCurrencyCode();
        result = result * 59 + ($counterCurrencyCode == null ? 43 : $counterCurrencyCode.hashCode());
        String $paymentMethodId = this.getPaymentMethodId();
        result = result * 59 + ($paymentMethodId == null ? 43 : $paymentMethodId.hashCode());
        String $makerPaymentAccountId = this.getMakerPaymentAccountId();
        result = result * 59 + ($makerPaymentAccountId == null ? 43 : $makerPaymentAccountId.hashCode());
        NodeAddress $ownerNodeAddress = this.getOwnerNodeAddress();
        result = result * 59 + ($ownerNodeAddress == null ? 43 : ((Object)$ownerNodeAddress).hashCode());
        OfferDirection $direction = this.getDirection();
        result = result * 59 + ($direction == null ? 43 : ((Object)((Object)$direction)).hashCode());
        String $versionNr = this.getVersionNr();
        result = result * 59 + ($versionNr == null ? 43 : $versionNr.hashCode());
        PubKeyRing $pubKeyRing = this.getPubKeyRing();
        result = result * 59 + ($pubKeyRing == null ? 43 : ((Object)$pubKeyRing).hashCode());
        Map<String, String> $extraDataMap = this.getExtraDataMap();
        result = result * 59 + ($extraDataMap == null ? 43 : ((Object)$extraDataMap).hashCode());
        NodeAddress $arbitratorSigner = this.getArbitratorSigner();
        result = result * 59 + ($arbitratorSigner == null ? 43 : ((Object)$arbitratorSigner).hashCode());
        result = result * 59 + Arrays.hashCode(this.getArbitratorSignature());
        List<String> $reserveTxKeyImages = this.getReserveTxKeyImages();
        result = result * 59 + ($reserveTxKeyImages == null ? 43 : ((Object)$reserveTxKeyImages).hashCode());
        String $countryCode = this.getCountryCode();
        result = result * 59 + ($countryCode == null ? 43 : $countryCode.hashCode());
        List<String> $acceptedCountryCodes = this.getAcceptedCountryCodes();
        result = result * 59 + ($acceptedCountryCodes == null ? 43 : ((Object)$acceptedCountryCodes).hashCode());
        String $bankId = this.getBankId();
        result = result * 59 + ($bankId == null ? 43 : $bankId.hashCode());
        List<String> $acceptedBankIds = this.getAcceptedBankIds();
        result = result * 59 + ($acceptedBankIds == null ? 43 : ((Object)$acceptedBankIds).hashCode());
        String $challengeHash = this.getChallengeHash();
        result = result * 59 + ($challengeHash == null ? 43 : $challengeHash.hashCode());
        String $extraInfo = this.getExtraInfo();
        result = result * 59 + ($extraInfo == null ? 43 : $extraInfo.hashCode());
        return result;
    }

    public String getId() {
        return this.id;
    }

    public long getDate() {
        return this.date;
    }

    public String getBaseCurrencyCode() {
        return this.baseCurrencyCode;
    }

    public String getCounterCurrencyCode() {
        return this.counterCurrencyCode;
    }

    public long getPrice() {
        return this.price;
    }

    public long getAmount() {
        return this.amount;
    }

    public long getMinAmount() {
        return this.minAmount;
    }

    public String getPaymentMethodId() {
        return this.paymentMethodId;
    }

    public String getMakerPaymentAccountId() {
        return this.makerPaymentAccountId;
    }

    @Override
    public NodeAddress getOwnerNodeAddress() {
        return this.ownerNodeAddress;
    }

    public OfferDirection getDirection() {
        return this.direction;
    }

    public String getVersionNr() {
        return this.versionNr;
    }

    public int getProtocolVersion() {
        return this.protocolVersion;
    }

    public PubKeyRing getPubKeyRing() {
        return this.pubKeyRing;
    }

    @Override
    @Nullable
    public Map<String, String> getExtraDataMap() {
        return this.extraDataMap;
    }

    @Nullable
    public NodeAddress getArbitratorSigner() {
        return this.arbitratorSigner;
    }

    @Nullable
    public byte[] getArbitratorSignature() {
        return this.arbitratorSignature;
    }

    @Nullable
    public List<String> getReserveTxKeyImages() {
        return this.reserveTxKeyImages;
    }

    public double getMarketPriceMarginPct() {
        return this.marketPriceMarginPct;
    }

    public boolean isUseMarketBasedPrice() {
        return this.useMarketBasedPrice;
    }

    @Nullable
    public String getCountryCode() {
        return this.countryCode;
    }

    @Nullable
    public List<String> getAcceptedCountryCodes() {
        return this.acceptedCountryCodes;
    }

    @Nullable
    public String getBankId() {
        return this.bankId;
    }

    @Nullable
    public List<String> getAcceptedBankIds() {
        return this.acceptedBankIds;
    }

    public long getBlockHeightAtOfferCreation() {
        return this.blockHeightAtOfferCreation;
    }

    public double getMakerFeePct() {
        return this.makerFeePct;
    }

    public double getTakerFeePct() {
        return this.takerFeePct;
    }

    public double getPenaltyFeePct() {
        return this.penaltyFeePct;
    }

    public double getBuyerSecurityDepositPct() {
        return this.buyerSecurityDepositPct;
    }

    public double getSellerSecurityDepositPct() {
        return this.sellerSecurityDepositPct;
    }

    public long getMaxTradeLimit() {
        return this.maxTradeLimit;
    }

    public long getMaxTradePeriod() {
        return this.maxTradePeriod;
    }

    public boolean isUseAutoClose() {
        return this.useAutoClose;
    }

    public boolean isUseReOpenAfterAutoClose() {
        return this.useReOpenAfterAutoClose;
    }

    public long getLowerClosePrice() {
        return this.lowerClosePrice;
    }

    public long getUpperClosePrice() {
        return this.upperClosePrice;
    }

    public boolean isPrivateOffer() {
        return this.isPrivateOffer;
    }

    @Nullable
    public String getChallengeHash() {
        return this.challengeHash;
    }

    @Nullable
    public String getExtraInfo() {
        return this.extraInfo;
    }

    public void setArbitratorSigner(@Nullable NodeAddress arbitratorSigner) {
        this.arbitratorSigner = arbitratorSigner;
    }

    public void setArbitratorSignature(@Nullable byte[] arbitratorSignature) {
        this.arbitratorSignature = arbitratorSignature;
    }

    public void setReserveTxKeyImages(@Nullable List<String> reserveTxKeyImages) {
        this.reserveTxKeyImages = reserveTxKeyImages;
    }

    public static class JsonSerializer
    implements com.google.gson.JsonSerializer<OfferPayload> {
        @Override
        public JsonElement serialize(OfferPayload offerPayload, Type type, JsonSerializationContext context) {
            JsonObject object = new JsonObject();
            object.add("id", context.serialize(offerPayload.getId()));
            object.add("date", context.serialize(offerPayload.getDate()));
            object.add("ownerNodeAddress", context.serialize(offerPayload.getOwnerNodeAddress()));
            object.add("direction", context.serialize((Object)offerPayload.getDirection()));
            object.add("price", context.serialize(offerPayload.getPrice()));
            object.add("marketPriceMargin", context.serialize(offerPayload.getMarketPriceMarginPct()));
            object.add("useMarketBasedPrice", context.serialize(offerPayload.isUseMarketBasedPrice()));
            object.add("amount", context.serialize(offerPayload.getAmount()));
            object.add("minAmount", context.serialize(offerPayload.getMinAmount()));
            object.add("makerFeePct", context.serialize(offerPayload.getMakerFeePct()));
            object.add("takerFeePct", context.serialize(offerPayload.getTakerFeePct()));
            object.add("penaltyFeePct", context.serialize(offerPayload.getPenaltyFeePct()));
            object.add("buyerSecurityDepositPct", context.serialize(offerPayload.getBuyerSecurityDepositPct()));
            object.add("sellerSecurityDepositPct", context.serialize(offerPayload.getSellerSecurityDepositPct()));
            object.add("baseCurrencyCode", context.serialize(offerPayload.getBaseCurrencyCode()));
            object.add("counterCurrencyCode", context.serialize(offerPayload.getCounterCurrencyCode()));
            object.add("paymentMethodId", context.serialize(offerPayload.getPaymentMethodId()));
            object.add("makerPaymentAccountId", context.serialize(offerPayload.getMakerPaymentAccountId()));
            object.add("versionNr", context.serialize(offerPayload.getVersionNr()));
            object.add("blockHeightAtOfferCreation", context.serialize(offerPayload.getBlockHeightAtOfferCreation()));
            object.add("maxTradeLimit", context.serialize(offerPayload.getMaxTradeLimit()));
            object.add("maxTradePeriod", context.serialize(offerPayload.getMaxTradePeriod()));
            object.add("useAutoClose", context.serialize(offerPayload.isUseAutoClose()));
            object.add("useReOpenAfterAutoClose", context.serialize(offerPayload.isUseReOpenAfterAutoClose()));
            object.add("lowerClosePrice", context.serialize(offerPayload.getLowerClosePrice()));
            object.add("upperClosePrice", context.serialize(offerPayload.getUpperClosePrice()));
            object.add("isPrivateOffer", context.serialize(offerPayload.isPrivateOffer()));
            object.add("extraDataMap", context.serialize(offerPayload.getExtraDataMap()));
            object.add("protocolVersion", context.serialize(offerPayload.getProtocolVersion()));
            object.add("arbitratorSigner", context.serialize(offerPayload.getArbitratorSigner()));
            object.add("arbitratorSignature", context.serialize(offerPayload.getArbitratorSignature()));
            object.add("extraInfo", context.serialize(offerPayload.getExtraInfo()));
            return object;
        }
    }
}

