/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.offer;

import haveno.common.app.Capabilities;
import haveno.common.app.Capability;
import haveno.common.config.Config;
import haveno.common.util.Utilities;
import haveno.core.offer.Offer;
import haveno.core.trade.HavenoUtils;
import java.math.BigInteger;
import java.util.Date;
import java.util.Map;

public class OfferRestrictions {
    private static final Date REQUIRE_TOR_NODE_ADDRESS_V3_DATE = Utilities.getUTCDate(2021, 7, 15);
    public static BigInteger TOLERATED_SMALL_TRADE_AMOUNT = HavenoUtils.xmrToAtomicUnits(3.0);

    public static boolean requiresNodeAddressUpdate() {
        return new Date().after(REQUIRE_TOR_NODE_ADDRESS_V3_DATE) && Config.baseCurrencyNetwork().isMainnet();
    }

    static boolean hasOfferMandatoryCapability(Offer offer, Capability mandatoryCapability) {
        Map<String, String> extraDataMap = offer.getExtraDataMap();
        if (extraDataMap != null && extraDataMap.containsKey("capabilities")) {
            String commaSeparatedOrdinals = extraDataMap.get("capabilities");
            Capabilities capabilities = Capabilities.fromStringList(commaSeparatedOrdinals);
            return Capabilities.hasMandatoryCapability(capabilities, mandatoryCapability);
        }
        return false;
    }
}

