/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.offer;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import haveno.common.app.Capabilities;
import haveno.common.util.MathUtils;
import haveno.common.util.Utilities;
import haveno.core.account.witness.AccountAgeWitnessService;
import haveno.core.filter.FilterManager;
import haveno.core.locale.CurrencyUtil;
import haveno.core.locale.Res;
import haveno.core.monetary.Price;
import haveno.core.monetary.Volume;
import haveno.core.offer.Offer;
import haveno.core.offer.OfferDirection;
import haveno.core.payment.AustraliaPayidAccount;
import haveno.core.payment.CashAppAccount;
import haveno.core.payment.CashAtAtmAccount;
import haveno.core.payment.F2FAccount;
import haveno.core.payment.PayByMailAccount;
import haveno.core.payment.PayPalAccount;
import haveno.core.payment.PaymentAccount;
import haveno.core.provider.price.MarketPrice;
import haveno.core.provider.price.PriceFeedService;
import haveno.core.trade.statistics.ReferralIdService;
import haveno.core.user.AutoConfirmSettings;
import haveno.core.user.Preferences;
import haveno.core.util.coin.CoinFormatter;
import haveno.core.xmr.wallet.Restrictions;
import haveno.network.p2p.P2PService;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class OfferUtil {
    private static final Logger log = LoggerFactory.getLogger(OfferUtil.class);
    private final AccountAgeWitnessService accountAgeWitnessService;
    private final FilterManager filterManager;
    private final Preferences preferences;
    private final PriceFeedService priceFeedService;
    private final P2PService p2PService;
    private final ReferralIdService referralIdService;

    @Inject
    public OfferUtil(AccountAgeWitnessService accountAgeWitnessService, FilterManager filterManager, Preferences preferences, PriceFeedService priceFeedService, P2PService p2PService, ReferralIdService referralIdService) {
        this.accountAgeWitnessService = accountAgeWitnessService;
        this.filterManager = filterManager;
        this.preferences = preferences;
        this.priceFeedService = priceFeedService;
        this.p2PService = p2PService;
        this.referralIdService = referralIdService;
    }

    public static String getRandomOfferId() {
        return Utilities.getRandomPrefix(5, 8) + "-" + String.valueOf(UUID.randomUUID()) + "-" + OfferUtil.getStrippedVersion();
    }

    public static String getStrippedVersion() {
        return "1.1.1".replace(".", "");
    }

    public boolean isBuyOffer(OfferDirection direction) {
        return direction == OfferDirection.BUY;
    }

    public long getMaxTradeLimit(PaymentAccount paymentAccount, String currencyCode, OfferDirection direction, boolean buyerAsTakerWithoutDeposit) {
        return paymentAccount != null ? this.accountAgeWitnessService.getMyTradeLimit(paymentAccount, currencyCode, direction, buyerAsTakerWithoutDeposit) : 0L;
    }

    public boolean isBalanceSufficient(BigInteger cost, BigInteger balance) {
        return cost != null && balance.compareTo(cost) >= 0;
    }

    public BigInteger getBalanceShortage(BigInteger cost, BigInteger balance) {
        if (cost != null) {
            BigInteger shortage = cost.subtract(balance);
            return shortage.compareTo(BigInteger.ZERO) < 0 ? BigInteger.ZERO : shortage;
        }
        return BigInteger.ZERO;
    }

    public double calculateManualPrice(double volumeAsDouble, double amountAsDouble) {
        return volumeAsDouble / amountAsDouble;
    }

    public double calculateMarketPriceMarginPct(double manualPrice, double marketPrice) {
        return MathUtils.roundDouble(manualPrice / marketPrice, 4);
    }

    public boolean isBlockChainPaymentMethod(Offer offer) {
        return offer != null && offer.getPaymentMethod().isBlockchain();
    }

    public Optional<Volume> getFeeInUserFiatCurrency(BigInteger makerFee, CoinFormatter formatter) {
        String userCurrencyCode = this.preferences.getPreferredTradeCurrency().getCode();
        if (CurrencyUtil.isCryptoCurrency(userCurrencyCode)) {
            String countryCode = this.preferences.getUserCountry().code;
            userCurrencyCode = CurrencyUtil.getCurrencyByCountryCode(countryCode).getCode();
        }
        return this.getFeeInUserFiatCurrency(makerFee, userCurrencyCode, formatter);
    }

    public Map<String, String> getExtraDataMap(PaymentAccount paymentAccount, String currencyCode, OfferDirection direction) {
        HashMap<String, String> extraDataMap = new HashMap<String, String>();
        if (CurrencyUtil.isTraditionalCurrency(currencyCode)) {
            String myWitnessHashAsHex = this.accountAgeWitnessService.getMyWitnessHashAsHex(paymentAccount.getPaymentAccountPayload());
            extraDataMap.put("accountAgeWitnessHash", myWitnessHashAsHex);
        }
        if (this.referralIdService.getOptionalReferralId().isPresent()) {
            extraDataMap.put("referralId", this.referralIdService.getOptionalReferralId().get());
        }
        if (paymentAccount instanceof F2FAccount) {
            extraDataMap.put("f2fCity", ((F2FAccount)paymentAccount).getCity());
            extraDataMap.put("f2fExtraInfo", ((F2FAccount)paymentAccount).getExtraInfo());
        }
        if (paymentAccount instanceof PayByMailAccount) {
            extraDataMap.put("payByMailExtraInfo", ((PayByMailAccount)paymentAccount).getExtraInfo());
        }
        if (paymentAccount instanceof PayPalAccount) {
            extraDataMap.put("payPalExtraInfo", ((PayPalAccount)paymentAccount).getExtraInfo());
        }
        if (paymentAccount instanceof CashAppAccount) {
            extraDataMap.put("cashAppExtraInfo", ((CashAppAccount)paymentAccount).getExtraInfo());
        }
        if (paymentAccount instanceof AustraliaPayidAccount) {
            extraDataMap.put("australiaPayidExtraInfo", ((AustraliaPayidAccount)paymentAccount).getExtraInfo());
        }
        if (paymentAccount instanceof CashAtAtmAccount) {
            extraDataMap.put("cashAtAtmExtraInfo", ((CashAtAtmAccount)paymentAccount).getExtraInfo());
        }
        extraDataMap.put("capabilities", Capabilities.app.toStringList());
        if (currencyCode.equals("XMR") && direction == OfferDirection.SELL) {
            this.preferences.getAutoConfirmSettingsList().stream().filter(e -> e.getCurrencyCode().equals("XMR")).filter(AutoConfirmSettings::isEnabled).forEach(e -> extraDataMap.put("xmrAutoConf", "1"));
        }
        return extraDataMap.isEmpty() ? null : extraDataMap;
    }

    public void validateOfferData(double securityDeposit, PaymentAccount paymentAccount, String currencyCode) {
        Preconditions.checkNotNull(this.p2PService.getAddress(), "Address must not be null");
        Preconditions.checkArgument(securityDeposit <= Restrictions.getMaxSecurityDepositAsPercent(), "securityDeposit must not exceed " + Restrictions.getMaxSecurityDepositAsPercent());
        Preconditions.checkArgument(securityDeposit >= Restrictions.getMinSecurityDepositAsPercent(), "securityDeposit must not be less than " + Restrictions.getMinSecurityDepositAsPercent() + " but was " + securityDeposit);
        Preconditions.checkArgument(!this.filterManager.isCurrencyBanned(currencyCode), Res.get("offerbook.warning.currencyBanned"));
        Preconditions.checkArgument(!this.filterManager.isPaymentMethodBanned(paymentAccount.getPaymentMethod()), Res.get("offerbook.warning.paymentMethodBanned"));
    }

    private Optional<Volume> getFeeInUserFiatCurrency(BigInteger makerFee, String userCurrencyCode, CoinFormatter formatter) {
        MarketPrice marketPrice = this.priceFeedService.getMarketPrice(userCurrencyCode);
        if (marketPrice != null && makerFee != null) {
            long marketPriceAsLong = MathUtils.roundDoubleToLong(MathUtils.scaleUpByPowerOf10(marketPrice.getPrice(), 8));
            Price userCurrencyPrice = Price.valueOf(userCurrencyCode, marketPriceAsLong);
            return Optional.of(userCurrencyPrice.getVolumeByAmount(makerFee));
        }
        return Optional.empty();
    }

    public static boolean isTraditionalOffer(Offer offer) {
        return offer.getBaseCurrencyCode().equals("XMR");
    }

    public static boolean isCryptoOffer(Offer offer) {
        return offer.getCounterCurrencyCode().equals("XMR");
    }
}

