/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.offer;

import haveno.common.proto.ProtoUtil;
import haveno.core.offer.Offer;
import haveno.core.trade.Tradable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javax.annotation.Nullable;
import protobuf.OpenOffer;

public final class OpenOffer
implements Tradable {
    private final Offer offer;
    private State state;
    private boolean reserveExactAmount;
    @Nullable
    private String scheduledAmount;
    @Nullable
    private List<String> scheduledTxHashes;
    @Nullable
    String splitOutputTxHash;
    long splitOutputTxFee;
    @Nullable
    private String reserveTxHash;
    @Nullable
    private String reserveTxHex;
    @Nullable
    private String reserveTxKey;
    private String challenge;
    private final long triggerPrice;
    private transient long mempoolStatus = -1L;
    private final transient ObjectProperty<State> stateProperty = new SimpleObjectProperty<State>(this.state);
    transient boolean isProcessing = false;
    transient int numProcessingAttempts = 0;
    private boolean deactivatedByTrigger;
    private String groupId;

    public OpenOffer(Offer offer) {
        this(offer, 0L, false);
    }

    public OpenOffer(Offer offer, long triggerPrice) {
        this(offer, triggerPrice, false);
    }

    public OpenOffer(Offer offer, long triggerPrice, boolean reserveExactAmount) {
        this.offer = offer;
        this.triggerPrice = triggerPrice;
        this.reserveExactAmount = reserveExactAmount;
        this.challenge = offer.getChallenge();
        this.groupId = UUID.randomUUID().toString();
        this.state = State.PENDING;
    }

    public OpenOffer(Offer offer, long triggerPrice, OpenOffer openOffer) {
        this.offer = offer;
        this.triggerPrice = triggerPrice;
        this.state = openOffer.state;
        this.reserveExactAmount = openOffer.reserveExactAmount;
        this.scheduledAmount = openOffer.scheduledAmount;
        this.scheduledTxHashes = openOffer.scheduledTxHashes == null ? null : new ArrayList<String>(openOffer.scheduledTxHashes);
        this.splitOutputTxHash = openOffer.splitOutputTxHash;
        this.splitOutputTxFee = openOffer.splitOutputTxFee;
        this.reserveTxHash = openOffer.reserveTxHash;
        this.reserveTxHex = openOffer.reserveTxHex;
        this.reserveTxKey = openOffer.reserveTxKey;
        this.challenge = openOffer.challenge;
        this.deactivatedByTrigger = openOffer.deactivatedByTrigger;
        this.groupId = openOffer.groupId;
    }

    private OpenOffer(Offer offer, State state, long triggerPrice, boolean reserveExactAmount, @Nullable String scheduledAmount, @Nullable List<String> scheduledTxHashes, String splitOutputTxHash, long splitOutputTxFee, @Nullable String reserveTxHash, @Nullable String reserveTxHex, @Nullable String reserveTxKey, @Nullable String challenge, boolean deactivatedByTrigger, @Nullable String groupId) {
        this.offer = offer;
        this.state = state;
        this.triggerPrice = triggerPrice;
        this.reserveExactAmount = reserveExactAmount;
        this.scheduledTxHashes = scheduledTxHashes;
        this.splitOutputTxHash = splitOutputTxHash;
        this.splitOutputTxFee = splitOutputTxFee;
        this.reserveTxHash = reserveTxHash;
        this.reserveTxHex = reserveTxHex;
        this.reserveTxKey = reserveTxKey;
        this.challenge = challenge;
        this.deactivatedByTrigger = deactivatedByTrigger;
        if (groupId == null) {
            groupId = UUID.randomUUID().toString();
        }
        this.groupId = groupId;
        if (this.state == State.RESERVED) {
            this.setState(State.AVAILABLE);
        }
    }

    @Override
    public protobuf.Tradable toProtoMessage() {
        OpenOffer.Builder builder = protobuf.OpenOffer.newBuilder().setOffer(this.offer.toProtoMessage()).setTriggerPrice(this.triggerPrice).setState(OpenOffer.State.valueOf(this.state.name())).setSplitOutputTxFee(this.splitOutputTxFee).setReserveExactAmount(this.reserveExactAmount).setDeactivatedByTrigger(this.deactivatedByTrigger);
        Optional.ofNullable(this.scheduledAmount).ifPresent(e -> builder.setScheduledAmount(this.scheduledAmount));
        Optional.ofNullable(this.scheduledTxHashes).ifPresent(e -> builder.addAllScheduledTxHashes(this.scheduledTxHashes));
        Optional.ofNullable(this.splitOutputTxHash).ifPresent(e -> builder.setSplitOutputTxHash(this.splitOutputTxHash));
        Optional.ofNullable(this.reserveTxHash).ifPresent(e -> builder.setReserveTxHash(this.reserveTxHash));
        Optional.ofNullable(this.reserveTxHex).ifPresent(e -> builder.setReserveTxHex(this.reserveTxHex));
        Optional.ofNullable(this.reserveTxKey).ifPresent(e -> builder.setReserveTxKey(this.reserveTxKey));
        Optional.ofNullable(this.challenge).ifPresent(e -> builder.setChallenge(this.challenge));
        Optional.ofNullable(this.groupId).ifPresent(e -> builder.setGroupId(this.groupId));
        return protobuf.Tradable.newBuilder().setOpenOffer(builder).build();
    }

    public static Tradable fromProto(protobuf.OpenOffer proto) {
        OpenOffer openOffer = new OpenOffer(Offer.fromProto(proto.getOffer()), ProtoUtil.enumFromProto(State.class, proto.getState().name()), proto.getTriggerPrice(), proto.getReserveExactAmount(), proto.getScheduledAmount(), proto.getScheduledTxHashesList(), ProtoUtil.stringOrNullFromProto(proto.getSplitOutputTxHash()), proto.getSplitOutputTxFee(), ProtoUtil.stringOrNullFromProto(proto.getReserveTxHash()), ProtoUtil.stringOrNullFromProto(proto.getReserveTxHex()), ProtoUtil.stringOrNullFromProto(proto.getReserveTxKey()), ProtoUtil.stringOrNullFromProto(proto.getChallenge()), proto.getDeactivatedByTrigger(), ProtoUtil.stringOrNullFromProto(proto.getGroupId()));
        return openOffer;
    }

    @Override
    public Date getDate() {
        return this.offer.getDate();
    }

    @Override
    public String getId() {
        return this.offer.getId();
    }

    @Override
    public String getShortId() {
        return this.offer.getShortId();
    }

    public void setState(State state) {
        this.state = state;
        this.stateProperty.set(state);
        if (state == State.AVAILABLE) {
            this.deactivatedByTrigger = false;
        }
    }

    public void deactivate(boolean deactivatedByTrigger) {
        this.deactivatedByTrigger = deactivatedByTrigger;
        this.setState(State.DEACTIVATED);
    }

    public ReadOnlyObjectProperty<State> stateProperty() {
        return this.stateProperty;
    }

    public boolean isPending() {
        return this.state == State.PENDING;
    }

    public boolean isAvailable() {
        return this.state == State.AVAILABLE;
    }

    public boolean isDeactivated() {
        return this.state == State.DEACTIVATED;
    }

    public boolean isCanceled() {
        return this.state == State.CANCELED;
    }

    public String toString() {
        return "OpenOffer{,\n     offer=" + String.valueOf(this.offer) + ",\n     state=" + String.valueOf((Object)this.state) + ",\n     triggerPrice=" + this.triggerPrice + ",\n     reserveExactAmount=" + this.reserveExactAmount + ",\n     scheduledAmount=" + this.scheduledAmount + ",\n     splitOutputTxFee=" + this.splitOutputTxFee + ",\n     groupId=" + this.groupId + "\n}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OpenOffer)) {
            return false;
        }
        OpenOffer other = (OpenOffer)o;
        if (this.isReserveExactAmount() != other.isReserveExactAmount()) {
            return false;
        }
        if (this.getSplitOutputTxFee() != other.getSplitOutputTxFee()) {
            return false;
        }
        if (this.getTriggerPrice() != other.getTriggerPrice()) {
            return false;
        }
        if (this.isDeactivatedByTrigger() != other.isDeactivatedByTrigger()) {
            return false;
        }
        Offer this$offer = this.getOffer();
        Offer other$offer = other.getOffer();
        if (this$offer == null ? other$offer != null : !((Object)this$offer).equals(other$offer)) {
            return false;
        }
        State this$state = this.getState();
        State other$state = other.getState();
        if (this$state == null ? other$state != null : !((Object)((Object)this$state)).equals((Object)other$state)) {
            return false;
        }
        String this$scheduledAmount = this.getScheduledAmount();
        String other$scheduledAmount = other.getScheduledAmount();
        if (this$scheduledAmount == null ? other$scheduledAmount != null : !this$scheduledAmount.equals(other$scheduledAmount)) {
            return false;
        }
        List<String> this$scheduledTxHashes = this.getScheduledTxHashes();
        List<String> other$scheduledTxHashes = other.getScheduledTxHashes();
        if (this$scheduledTxHashes == null ? other$scheduledTxHashes != null : !((Object)this$scheduledTxHashes).equals(other$scheduledTxHashes)) {
            return false;
        }
        String this$splitOutputTxHash = this.getSplitOutputTxHash();
        String other$splitOutputTxHash = other.getSplitOutputTxHash();
        if (this$splitOutputTxHash == null ? other$splitOutputTxHash != null : !this$splitOutputTxHash.equals(other$splitOutputTxHash)) {
            return false;
        }
        String this$reserveTxHash = this.getReserveTxHash();
        String other$reserveTxHash = other.getReserveTxHash();
        if (this$reserveTxHash == null ? other$reserveTxHash != null : !this$reserveTxHash.equals(other$reserveTxHash)) {
            return false;
        }
        String this$reserveTxHex = this.getReserveTxHex();
        String other$reserveTxHex = other.getReserveTxHex();
        if (this$reserveTxHex == null ? other$reserveTxHex != null : !this$reserveTxHex.equals(other$reserveTxHex)) {
            return false;
        }
        String this$reserveTxKey = this.getReserveTxKey();
        String other$reserveTxKey = other.getReserveTxKey();
        if (this$reserveTxKey == null ? other$reserveTxKey != null : !this$reserveTxKey.equals(other$reserveTxKey)) {
            return false;
        }
        String this$challenge = this.getChallenge();
        String other$challenge = other.getChallenge();
        if (this$challenge == null ? other$challenge != null : !this$challenge.equals(other$challenge)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        return !(this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isReserveExactAmount() ? 79 : 97);
        long $splitOutputTxFee = this.getSplitOutputTxFee();
        result = result * 59 + (int)($splitOutputTxFee >>> 32 ^ $splitOutputTxFee);
        long $triggerPrice = this.getTriggerPrice();
        result = result * 59 + (int)($triggerPrice >>> 32 ^ $triggerPrice);
        result = result * 59 + (this.isDeactivatedByTrigger() ? 79 : 97);
        Offer $offer = this.getOffer();
        result = result * 59 + ($offer == null ? 43 : ((Object)$offer).hashCode());
        State $state = this.getState();
        result = result * 59 + ($state == null ? 43 : ((Object)((Object)$state)).hashCode());
        String $scheduledAmount = this.getScheduledAmount();
        result = result * 59 + ($scheduledAmount == null ? 43 : $scheduledAmount.hashCode());
        List<String> $scheduledTxHashes = this.getScheduledTxHashes();
        result = result * 59 + ($scheduledTxHashes == null ? 43 : ((Object)$scheduledTxHashes).hashCode());
        String $splitOutputTxHash = this.getSplitOutputTxHash();
        result = result * 59 + ($splitOutputTxHash == null ? 43 : $splitOutputTxHash.hashCode());
        String $reserveTxHash = this.getReserveTxHash();
        result = result * 59 + ($reserveTxHash == null ? 43 : $reserveTxHash.hashCode());
        String $reserveTxHex = this.getReserveTxHex();
        result = result * 59 + ($reserveTxHex == null ? 43 : $reserveTxHex.hashCode());
        String $reserveTxKey = this.getReserveTxKey();
        result = result * 59 + ($reserveTxKey == null ? 43 : $reserveTxKey.hashCode());
        String $challenge = this.getChallenge();
        result = result * 59 + ($challenge == null ? 43 : $challenge.hashCode());
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        return result;
    }

    @Override
    public Offer getOffer() {
        return this.offer;
    }

    public State getState() {
        return this.state;
    }

    public void setReserveExactAmount(boolean reserveExactAmount) {
        this.reserveExactAmount = reserveExactAmount;
    }

    public boolean isReserveExactAmount() {
        return this.reserveExactAmount;
    }

    public void setScheduledAmount(@Nullable String scheduledAmount) {
        this.scheduledAmount = scheduledAmount;
    }

    @Nullable
    public String getScheduledAmount() {
        return this.scheduledAmount;
    }

    public void setScheduledTxHashes(@Nullable List<String> scheduledTxHashes) {
        this.scheduledTxHashes = scheduledTxHashes;
    }

    @Nullable
    public List<String> getScheduledTxHashes() {
        return this.scheduledTxHashes;
    }

    public void setSplitOutputTxHash(@Nullable String splitOutputTxHash) {
        this.splitOutputTxHash = splitOutputTxHash;
    }

    @Nullable
    public String getSplitOutputTxHash() {
        return this.splitOutputTxHash;
    }

    public long getSplitOutputTxFee() {
        return this.splitOutputTxFee;
    }

    public void setSplitOutputTxFee(long splitOutputTxFee) {
        this.splitOutputTxFee = splitOutputTxFee;
    }

    public void setReserveTxHash(@Nullable String reserveTxHash) {
        this.reserveTxHash = reserveTxHash;
    }

    @Nullable
    public String getReserveTxHash() {
        return this.reserveTxHash;
    }

    public void setReserveTxHex(@Nullable String reserveTxHex) {
        this.reserveTxHex = reserveTxHex;
    }

    @Nullable
    public String getReserveTxHex() {
        return this.reserveTxHex;
    }

    public void setReserveTxKey(@Nullable String reserveTxKey) {
        this.reserveTxKey = reserveTxKey;
    }

    @Nullable
    public String getReserveTxKey() {
        return this.reserveTxKey;
    }

    public String getChallenge() {
        return this.challenge;
    }

    public void setChallenge(String challenge) {
        this.challenge = challenge;
    }

    public long getTriggerPrice() {
        return this.triggerPrice;
    }

    public long getMempoolStatus() {
        return this.mempoolStatus;
    }

    public void setMempoolStatus(long mempoolStatus) {
        this.mempoolStatus = mempoolStatus;
    }

    public boolean isProcessing() {
        return this.isProcessing;
    }

    public void setProcessing(boolean isProcessing) {
        this.isProcessing = isProcessing;
    }

    public int getNumProcessingAttempts() {
        return this.numProcessingAttempts;
    }

    public void setNumProcessingAttempts(int numProcessingAttempts) {
        this.numProcessingAttempts = numProcessingAttempts;
    }

    public boolean isDeactivatedByTrigger() {
        return this.deactivatedByTrigger;
    }

    public void setDeactivatedByTrigger(boolean deactivatedByTrigger) {
        this.deactivatedByTrigger = deactivatedByTrigger;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public static enum State {
        PENDING,
        AVAILABLE,
        RESERVED,
        CLOSED,
        CANCELED,
        DEACTIVATED;

    }
}

