/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.offer;

import com.google.protobuf.ByteString;
import haveno.common.proto.ProtoUtil;
import haveno.common.proto.persistable.PersistablePayload;
import haveno.core.util.JsonUtil;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import protobuf.SignedOffer;

public final class SignedOffer
implements PersistablePayload {
    private static final Logger log = LoggerFactory.getLogger(SignedOffer.class);
    private final long timeStamp;
    private int traderId;
    private final String offerId;
    private final long tradeAmount;
    private final long penaltyAmount;
    private final String reserveTxHash;
    private final String reserveTxHex;
    private final List<String> reserveTxKeyImages;
    private final long reserveTxMinerFee;
    private final byte[] arbitratorSignature;

    public SignedOffer(long timeStamp, int traderId, String offerId, long tradeAmount, long penaltyAmount, String reserveTxHash, String reserveTxHex, List<String> reserveTxKeyImages, long reserveTxMinerFee, byte[] arbitratorSignature) {
        this.timeStamp = timeStamp;
        this.traderId = traderId;
        this.offerId = offerId;
        this.tradeAmount = tradeAmount;
        this.penaltyAmount = penaltyAmount;
        this.reserveTxHash = reserveTxHash;
        this.reserveTxHex = reserveTxHex;
        this.reserveTxKeyImages = reserveTxKeyImages;
        this.reserveTxMinerFee = reserveTxMinerFee;
        this.arbitratorSignature = arbitratorSignature;
    }

    @Override
    public protobuf.SignedOffer toProtoMessage() {
        SignedOffer.Builder builder = protobuf.SignedOffer.newBuilder().setTimeStamp(this.timeStamp).setTraderId(this.traderId).setOfferId(this.offerId).setTradeAmount(this.tradeAmount).setPenaltyAmount(this.penaltyAmount).setReserveTxHash(this.reserveTxHash).setReserveTxHex(this.reserveTxHex).addAllReserveTxKeyImages(this.reserveTxKeyImages).setReserveTxMinerFee(this.reserveTxMinerFee).setArbitratorSignature(ByteString.copyFrom(this.arbitratorSignature));
        return builder.build();
    }

    public static SignedOffer fromProto(protobuf.SignedOffer proto) {
        return new SignedOffer(proto.getTimeStamp(), proto.getTraderId(), proto.getOfferId(), proto.getTradeAmount(), proto.getPenaltyAmount(), proto.getReserveTxHash(), proto.getReserveTxHex(), proto.getReserveTxKeyImagesList(), proto.getReserveTxMinerFee(), ProtoUtil.byteArrayOrNullFromProto(proto.getArbitratorSignature()));
    }

    public String toJson() {
        return JsonUtil.objectToJson(this);
    }

    public String toString() {
        return "SignedOffer{,\n     timeStamp=" + this.timeStamp + ",\n     traderId=" + this.traderId + ",\n     offerId=" + this.offerId + ",\n     tradeAmount=" + this.tradeAmount + ",\n     penaltyAmount=" + this.penaltyAmount + ",\n     reserveTxHash=" + this.reserveTxHash + ",\n     reserveTxHex=" + this.reserveTxHex + ",\n     reserveTxKeyImages=" + String.valueOf(this.reserveTxKeyImages) + ",\n     reserveTxMinerFee=" + this.reserveTxMinerFee + ",\n     arbitratorSignature=" + String.valueOf(this.arbitratorSignature) + "\n}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SignedOffer)) {
            return false;
        }
        SignedOffer other = (SignedOffer)o;
        if (this.getTimeStamp() != other.getTimeStamp()) {
            return false;
        }
        if (this.getTraderId() != other.getTraderId()) {
            return false;
        }
        if (this.getTradeAmount() != other.getTradeAmount()) {
            return false;
        }
        if (this.getPenaltyAmount() != other.getPenaltyAmount()) {
            return false;
        }
        if (this.getReserveTxMinerFee() != other.getReserveTxMinerFee()) {
            return false;
        }
        String this$offerId = this.getOfferId();
        String other$offerId = other.getOfferId();
        if (this$offerId == null ? other$offerId != null : !this$offerId.equals(other$offerId)) {
            return false;
        }
        String this$reserveTxHash = this.getReserveTxHash();
        String other$reserveTxHash = other.getReserveTxHash();
        if (this$reserveTxHash == null ? other$reserveTxHash != null : !this$reserveTxHash.equals(other$reserveTxHash)) {
            return false;
        }
        String this$reserveTxHex = this.getReserveTxHex();
        String other$reserveTxHex = other.getReserveTxHex();
        if (this$reserveTxHex == null ? other$reserveTxHex != null : !this$reserveTxHex.equals(other$reserveTxHex)) {
            return false;
        }
        List<String> this$reserveTxKeyImages = this.getReserveTxKeyImages();
        List<String> other$reserveTxKeyImages = other.getReserveTxKeyImages();
        if (this$reserveTxKeyImages == null ? other$reserveTxKeyImages != null : !((Object)this$reserveTxKeyImages).equals(other$reserveTxKeyImages)) {
            return false;
        }
        return Arrays.equals(this.getArbitratorSignature(), other.getArbitratorSignature());
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $timeStamp = this.getTimeStamp();
        result = result * 59 + (int)($timeStamp >>> 32 ^ $timeStamp);
        result = result * 59 + this.getTraderId();
        long $tradeAmount = this.getTradeAmount();
        result = result * 59 + (int)($tradeAmount >>> 32 ^ $tradeAmount);
        long $penaltyAmount = this.getPenaltyAmount();
        result = result * 59 + (int)($penaltyAmount >>> 32 ^ $penaltyAmount);
        long $reserveTxMinerFee = this.getReserveTxMinerFee();
        result = result * 59 + (int)($reserveTxMinerFee >>> 32 ^ $reserveTxMinerFee);
        String $offerId = this.getOfferId();
        result = result * 59 + ($offerId == null ? 43 : $offerId.hashCode());
        String $reserveTxHash = this.getReserveTxHash();
        result = result * 59 + ($reserveTxHash == null ? 43 : $reserveTxHash.hashCode());
        String $reserveTxHex = this.getReserveTxHex();
        result = result * 59 + ($reserveTxHex == null ? 43 : $reserveTxHex.hashCode());
        List<String> $reserveTxKeyImages = this.getReserveTxKeyImages();
        result = result * 59 + ($reserveTxKeyImages == null ? 43 : ((Object)$reserveTxKeyImages).hashCode());
        result = result * 59 + Arrays.hashCode(this.getArbitratorSignature());
        return result;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public int getTraderId() {
        return this.traderId;
    }

    public String getOfferId() {
        return this.offerId;
    }

    public long getTradeAmount() {
        return this.tradeAmount;
    }

    public long getPenaltyAmount() {
        return this.penaltyAmount;
    }

    public String getReserveTxHash() {
        return this.reserveTxHash;
    }

    public String getReserveTxHex() {
        return this.reserveTxHex;
    }

    public List<String> getReserveTxKeyImages() {
        return this.reserveTxKeyImages;
    }

    public long getReserveTxMinerFee() {
        return this.reserveTxMinerFee;
    }

    public byte[] getArbitratorSignature() {
        return this.arbitratorSignature;
    }
}

