/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.offer.availability;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import haveno.common.util.Tuple2;
import haveno.core.support.dispute.agent.DisputeAgent;
import haveno.core.support.dispute.agent.DisputeAgentManager;
import haveno.core.trade.statistics.TradeStatistics3;
import haveno.core.trade.statistics.TradeStatisticsManager;
import haveno.network.p2p.NodeAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DisputeAgentSelection {
    private static final Logger log = LoggerFactory.getLogger(DisputeAgentSelection.class);
    public static final int LOOK_BACK_RANGE = 100;

    public static <T extends DisputeAgent> T getLeastUsedArbitrator(TradeStatisticsManager tradeStatisticsManager, DisputeAgentManager<T> disputeAgentManager) {
        return DisputeAgentSelection.getLeastUsedDisputeAgent(tradeStatisticsManager, disputeAgentManager, null);
    }

    public static <T extends DisputeAgent> T getLeastUsedArbitrator(TradeStatisticsManager tradeStatisticsManager, DisputeAgentManager<T> disputeAgentManager, Set<NodeAddress> excludedArbitrator) {
        return DisputeAgentSelection.getLeastUsedDisputeAgent(tradeStatisticsManager, disputeAgentManager, excludedArbitrator);
    }

    private static <T extends DisputeAgent> T getLeastUsedDisputeAgent(TradeStatisticsManager tradeStatisticsManager, DisputeAgentManager<T> disputeAgentManager, Set<NodeAddress> excludedDisputeAgents) {
        List<TradeStatistics3> list = new ArrayList<TradeStatistics3>(tradeStatisticsManager.getObservableTradeStatisticsSet());
        list.sort(Comparator.comparing(TradeStatistics3::getDateAsLong));
        Collections.reverse(list);
        if (!list.isEmpty()) {
            int max = Math.min(list.size(), 100);
            list = list.subList(0, max);
        }
        List<String> lastAddressesUsedInTrades = list.stream().map(tradeStatistics3 -> tradeStatistics3.getArbitrator()).filter(Objects::nonNull).collect(Collectors.toList());
        Set<String> disputeAgents = disputeAgentManager.getObservableMap().values().stream().map(disputeAgent -> disputeAgent.getNodeAddress().getFullAddress()).collect(Collectors.toSet());
        if (excludedDisputeAgents != null) {
            disputeAgents.removeAll(excludedDisputeAgents.stream().map(NodeAddress::getFullAddress).collect(Collectors.toList()));
        }
        if (disputeAgents.isEmpty()) {
            return null;
        }
        String result = DisputeAgentSelection.getLeastUsedDisputeAgent(lastAddressesUsedInTrades, disputeAgents);
        Optional<DisputeAgent> optionalDisputeAgent = disputeAgentManager.getObservableMap().values().stream().filter(e -> e.getNodeAddress().getFullAddress().equals(result)).findAny();
        Preconditions.checkArgument(optionalDisputeAgent.isPresent(), "optionalDisputeAgent has to be present");
        return (T)optionalDisputeAgent.get();
    }

    @VisibleForTesting
    static String getLeastUsedDisputeAgent(List<String> lastAddressesUsedInTrades, Set<String> disputeAgents) {
        Preconditions.checkArgument(!disputeAgents.isEmpty(), "disputeAgents must not be empty");
        List<Tuple2> disputeAgentTuples = disputeAgents.stream().map(e -> new Tuple2<String, AtomicInteger>((String)e, new AtomicInteger(0))).collect(Collectors.toList());
        disputeAgentTuples.forEach(tuple -> {
            int count = (int)lastAddressesUsedInTrades.stream().filter(((String)tuple.first)::startsWith).mapToInt(e -> 1).count();
            ((AtomicInteger)tuple.second).set(count);
        });
        disputeAgentTuples.sort(Comparator.comparing(e -> (String)e.first));
        disputeAgentTuples.sort(Comparator.comparingInt(e -> ((AtomicInteger)e.second).get()));
        return (String)((Tuple2)disputeAgentTuples.get((int)0)).first;
    }

    public static <T extends DisputeAgent> T getRandomArbitrator(DisputeAgentManager<T> disputeAgentManager) {
        return DisputeAgentSelection.getRandomArbitrator(disputeAgentManager, null);
    }

    public static <T extends DisputeAgent> T getRandomArbitrator(DisputeAgentManager<T> disputeAgentManager, Set<NodeAddress> excludedArbitrator) {
        return DisputeAgentSelection.getRandomDisputeAgent(disputeAgentManager, excludedArbitrator);
    }

    private static <T extends DisputeAgent> T getRandomDisputeAgent(DisputeAgentManager<T> disputeAgentManager, Set<NodeAddress> excludedDisputeAgents) {
        Set<String> disputeAgents = disputeAgentManager.getObservableMap().values().stream().map(disputeAgent -> disputeAgent.getNodeAddress().getFullAddress()).collect(Collectors.toSet());
        if (excludedDisputeAgents != null) {
            disputeAgents.removeAll(excludedDisputeAgents.stream().map(NodeAddress::getFullAddress).collect(Collectors.toList()));
        }
        if (disputeAgents.isEmpty()) {
            return null;
        }
        String result = DisputeAgentSelection.getRandomDisputeAgent(disputeAgents);
        Optional<DisputeAgent> optionalDisputeAgent = disputeAgentManager.getObservableMap().values().stream().filter(e -> e.getNodeAddress().getFullAddress().equals(result)).findAny();
        Preconditions.checkArgument(optionalDisputeAgent.isPresent(), "optionalDisputeAgent has to be present");
        return (T)optionalDisputeAgent.get();
    }

    private static String getRandomDisputeAgent(Set<String> disputeAgents) {
        int randomIndex = new Random().nextInt(disputeAgents.size());
        ArrayList<String> elements = new ArrayList<String>(disputeAgents);
        return (String)elements.get(randomIndex);
    }
}

