/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.offer.availability;

import haveno.common.Timer;
import haveno.common.UserThread;
import haveno.common.crypto.PubKeyRing;
import haveno.common.handlers.ErrorMessageHandler;
import haveno.common.handlers.ResultHandler;
import haveno.common.proto.network.NetworkEnvelope;
import haveno.common.taskrunner.TaskRunner;
import haveno.core.offer.Offer;
import haveno.core.offer.availability.OfferAvailabilityModel;
import haveno.core.offer.availability.tasks.ProcessOfferAvailabilityResponse;
import haveno.core.offer.availability.tasks.SendOfferAvailabilityRequest;
import haveno.core.offer.messages.OfferAvailabilityResponse;
import haveno.core.offer.messages.OfferMessage;
import haveno.core.util.Validator;
import haveno.network.p2p.AckMessage;
import haveno.network.p2p.AckMessageSourceType;
import haveno.network.p2p.DecryptedDirectMessageListener;
import haveno.network.p2p.NodeAddress;
import haveno.network.p2p.SendDirectMessageListener;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OfferAvailabilityProtocol {
    private static final Logger log = LoggerFactory.getLogger(OfferAvailabilityProtocol.class);
    private static final long TIMEOUT = 90L;
    private final OfferAvailabilityModel model;
    private final ResultHandler resultHandler;
    private final ErrorMessageHandler errorMessageHandler;
    private final DecryptedDirectMessageListener decryptedDirectMessageListener;
    private TaskRunner<OfferAvailabilityModel> taskRunner;
    private Timer timeoutTimer;

    public OfferAvailabilityProtocol(OfferAvailabilityModel model, ResultHandler resultHandler, ErrorMessageHandler errorMessageHandler) {
        this.model = model;
        this.resultHandler = resultHandler;
        this.errorMessageHandler = errorMessageHandler;
        this.decryptedDirectMessageListener = (decryptedMessageWithPubKey, peersNodeAddress) -> {
            NetworkEnvelope networkEnvelope = decryptedMessageWithPubKey.getNetworkEnvelope();
            if (networkEnvelope instanceof OfferMessage) {
                OfferMessage offerMessage = (OfferMessage)networkEnvelope;
                Validator.nonEmptyStringOf(offerMessage.offerId);
                if (networkEnvelope instanceof OfferAvailabilityResponse && model.getOffer().getId().equals(offerMessage.offerId)) {
                    this.handleOfferAvailabilityResponse((OfferAvailabilityResponse)networkEnvelope, peersNodeAddress);
                }
            }
        };
    }

    private void cleanup() {
        this.stopTimeout();
        this.model.getP2PService().removeDecryptedDirectMessageListener(this.decryptedDirectMessageListener);
    }

    public void sendOfferAvailabilityRequest() {
        this.model.getOffer().setState(Offer.State.UNKNOWN);
        this.model.getP2PService().addDecryptedDirectMessageListener(this.decryptedDirectMessageListener);
        this.model.setPeerNodeAddress(this.model.getOffer().getMakerNodeAddress());
        this.taskRunner = new TaskRunner<OfferAvailabilityModel>(this.model, () -> this.handleTaskRunnerSuccess("TaskRunner at sendOfferAvailabilityRequest completed", null), errorMessage -> this.handleTaskRunnerFault(errorMessage, null));
        this.taskRunner.addTasks(SendOfferAvailabilityRequest.class);
        this.startTimeout();
        this.taskRunner.run();
    }

    public void cancel() {
        this.taskRunner.cancel();
        this.cleanup();
    }

    private void handleOfferAvailabilityResponse(OfferAvailabilityResponse message, NodeAddress peersNodeAddress) {
        log.info("Received OfferAvailabilityResponse from {} with offerId {} and uid {}", peersNodeAddress, message.getOfferId(), message.getUid());
        this.stopTimeout();
        this.startTimeout();
        this.model.setMessage(message);
        this.taskRunner = new TaskRunner<OfferAvailabilityModel>(this.model, () -> {
            this.handleTaskRunnerSuccess("TaskRunner at handle OfferAvailabilityResponse completed", message);
            this.stopTimeout();
            this.resultHandler.handleResult();
        }, errorMessage -> this.handleTaskRunnerFault(errorMessage, message));
        this.taskRunner.addTasks(ProcessOfferAvailabilityResponse.class);
        this.taskRunner.run();
    }

    private void startTimeout() {
        if (this.timeoutTimer == null) {
            this.timeoutTimer = UserThread.runAfter(() -> {
                log.debug("Timeout reached at " + String.valueOf(this));
                this.model.getOffer().setState(Offer.State.MAKER_OFFLINE);
                this.errorMessageHandler.handleErrorMessage("Timeout reached: Peer has not responded.");
            }, 90L);
        } else {
            log.warn("timeoutTimer already created. That must not happen.");
        }
    }

    private void stopTimeout() {
        if (this.timeoutTimer != null) {
            this.timeoutTimer.stop();
            this.timeoutTimer = null;
        }
    }

    private void handleTaskRunnerSuccess(String info, @Nullable OfferAvailabilityResponse message) {
        log.debug("handleTaskRunnerSuccess " + info);
        if (message != null) {
            this.sendAckMessage(message, true, null);
        }
    }

    private void handleTaskRunnerFault(String errorMessage, @Nullable OfferAvailabilityResponse message) {
        log.error(errorMessage);
        this.stopTimeout();
        this.errorMessageHandler.handleErrorMessage(errorMessage);
        if (message != null) {
            this.sendAckMessage(message, false, errorMessage);
        }
    }

    private void sendAckMessage(OfferAvailabilityResponse message, boolean result, @Nullable String errorMessage) {
        final String offerId = message.getOfferId();
        String sourceUid = message.getUid();
        final NodeAddress makersNodeAddress = this.model.getPeerNodeAddress();
        PubKeyRing makersPubKeyRing = this.model.getOffer().getPubKeyRing();
        log.info("Send AckMessage for OfferAvailabilityResponse to peer {} with offerId {} and sourceUid {}", makersNodeAddress, offerId, sourceUid);
        final AckMessage ackMessage = new AckMessage(this.model.getP2PService().getNetworkNode().getNodeAddress(), AckMessageSourceType.OFFER_MESSAGE, message.getClass().getSimpleName(), sourceUid, offerId, result, errorMessage);
        this.model.getP2PService().sendEncryptedDirectMessage(makersNodeAddress, makersPubKeyRing, ackMessage, new SendDirectMessageListener(){

            @Override
            public void onArrived() {
                log.info("AckMessage for OfferAvailabilityResponse arrived at makersNodeAddress {}. offerId={}, sourceUid={}", makersNodeAddress, offerId, ackMessage.getSourceUid());
            }

            @Override
            public void onFault(String errorMessage) {
                log.error("AckMessage for OfferAvailabilityResponse failed. AckMessage={}, makersNodeAddress={}, errorMessage={}", ackMessage, makersNodeAddress, errorMessage);
            }
        });
    }
}

