/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.offer.availability.tasks;

import com.google.common.base.Preconditions;
import haveno.common.taskrunner.Task;
import haveno.common.taskrunner.TaskRunner;
import haveno.core.offer.AvailabilityResult;
import haveno.core.offer.Offer;
import haveno.core.offer.availability.OfferAvailabilityModel;
import haveno.core.offer.messages.OfferAvailabilityResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessOfferAvailabilityResponse
extends Task<OfferAvailabilityModel> {
    private static final Logger log = LoggerFactory.getLogger(ProcessOfferAvailabilityResponse.class);

    public ProcessOfferAvailabilityResponse(TaskRunner<OfferAvailabilityModel> taskHandler, OfferAvailabilityModel model) {
        super(taskHandler, model);
    }

    @Override
    protected void run() {
        Offer offer = ((OfferAvailabilityModel)this.model).getOffer();
        try {
            this.runInterceptHook();
            Preconditions.checkArgument(offer.getState() != Offer.State.REMOVED, "Offer state must not be Offer.State.REMOVED");
            OfferAvailabilityResponse offerAvailabilityResponse = ((OfferAvailabilityModel)this.model).getMessage();
            if (offerAvailabilityResponse.getAvailabilityResult() != AvailabilityResult.AVAILABLE) {
                offer.setState(Offer.State.NOT_AVAILABLE);
                this.failed("Take offer attempt rejected because of: " + String.valueOf((Object)offerAvailabilityResponse.getAvailabilityResult()));
                return;
            }
            offer.setState(Offer.State.AVAILABLE);
            ((OfferAvailabilityModel)this.model).setMakerSignature(offerAvailabilityResponse.getMakerSignature());
            Preconditions.checkNotNull(((OfferAvailabilityModel)this.model).getMakerSignature());
            this.complete();
        }
        catch (Throwable t2) {
            offer.setErrorMessage("An error occurred.\nError message:\n" + t2.getMessage());
            this.failed(t2);
        }
    }
}

