/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.offer.messages;

import haveno.common.app.Capabilities;
import haveno.common.app.Version;
import haveno.common.crypto.PubKeyRing;
import haveno.core.offer.messages.OfferMessage;
import haveno.core.proto.CoreProtoResolver;
import haveno.core.trade.messages.InitTradeRequest;
import haveno.network.p2p.SupportedCapabilitiesMessage;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import protobuf.NetworkEnvelope;
import protobuf.OfferAvailabilityRequest;

public final class OfferAvailabilityRequest
extends OfferMessage
implements SupportedCapabilitiesMessage {
    private static final Logger log = LoggerFactory.getLogger(OfferAvailabilityRequest.class);
    private final PubKeyRing pubKeyRing;
    private final long takersTradePrice;
    @Nullable
    private final Capabilities supportedCapabilities;
    private final boolean isTakerApiUser;
    private final InitTradeRequest tradeRequest;

    public OfferAvailabilityRequest(String offerId, PubKeyRing pubKeyRing, long takersTradePrice, boolean isTakerApiUser, InitTradeRequest tradeRequest) {
        this(offerId, pubKeyRing, takersTradePrice, isTakerApiUser, Capabilities.app, Version.getP2PMessageVersion(), UUID.randomUUID().toString(), tradeRequest);
    }

    private OfferAvailabilityRequest(String offerId, PubKeyRing pubKeyRing, long takersTradePrice, boolean isTakerApiUser, @Nullable Capabilities supportedCapabilities, String messageVersion, @Nullable String uid, InitTradeRequest tradeRequest) {
        super(messageVersion, offerId, uid);
        this.pubKeyRing = pubKeyRing;
        this.takersTradePrice = takersTradePrice;
        this.isTakerApiUser = isTakerApiUser;
        this.supportedCapabilities = supportedCapabilities;
        this.tradeRequest = tradeRequest;
    }

    @Override
    public NetworkEnvelope toProtoNetworkEnvelope() {
        OfferAvailabilityRequest.Builder builder = protobuf.OfferAvailabilityRequest.newBuilder().setOfferId(this.offerId).setPubKeyRing(this.pubKeyRing.toProtoMessage()).setTakersTradePrice(this.takersTradePrice).setIsTakerApiUser(this.isTakerApiUser).setTradeRequest(this.tradeRequest.toProtoNetworkEnvelope().getInitTradeRequest());
        Optional.ofNullable(this.supportedCapabilities).ifPresent(e -> builder.addAllSupportedCapabilities(Capabilities.toIntList(this.supportedCapabilities)));
        Optional.ofNullable(this.uid).ifPresent(e -> builder.setUid(this.uid));
        return this.getNetworkEnvelopeBuilder().setOfferAvailabilityRequest(builder).build();
    }

    public static OfferAvailabilityRequest fromProto(protobuf.OfferAvailabilityRequest proto, CoreProtoResolver coreProtoResolver, String messageVersion) {
        return new OfferAvailabilityRequest(proto.getOfferId(), PubKeyRing.fromProto(proto.getPubKeyRing()), proto.getTakersTradePrice(), proto.getIsTakerApiUser(), Capabilities.fromIntList(proto.getSupportedCapabilitiesList()), messageVersion, proto.getUid().isEmpty() ? null : proto.getUid(), InitTradeRequest.fromProto(proto.getTradeRequest(), coreProtoResolver, messageVersion));
    }

    public PubKeyRing getPubKeyRing() {
        return this.pubKeyRing;
    }

    public long getTakersTradePrice() {
        return this.takersTradePrice;
    }

    @Override
    @Nullable
    public Capabilities getSupportedCapabilities() {
        return this.supportedCapabilities;
    }

    public boolean isTakerApiUser() {
        return this.isTakerApiUser;
    }

    public InitTradeRequest getTradeRequest() {
        return this.tradeRequest;
    }

    @Override
    public String toString() {
        return "OfferAvailabilityRequest(pubKeyRing=" + String.valueOf(this.getPubKeyRing()) + ", takersTradePrice=" + this.getTakersTradePrice() + ", supportedCapabilities=" + String.valueOf(this.getSupportedCapabilities()) + ", isTakerApiUser=" + this.isTakerApiUser() + ", tradeRequest=" + String.valueOf(this.getTradeRequest()) + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OfferAvailabilityRequest)) {
            return false;
        }
        OfferAvailabilityRequest other = (OfferAvailabilityRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getTakersTradePrice() != other.getTakersTradePrice()) {
            return false;
        }
        if (this.isTakerApiUser() != other.isTakerApiUser()) {
            return false;
        }
        PubKeyRing this$pubKeyRing = this.getPubKeyRing();
        PubKeyRing other$pubKeyRing = other.getPubKeyRing();
        if (this$pubKeyRing == null ? other$pubKeyRing != null : !((Object)this$pubKeyRing).equals(other$pubKeyRing)) {
            return false;
        }
        Capabilities this$supportedCapabilities = this.getSupportedCapabilities();
        Capabilities other$supportedCapabilities = other.getSupportedCapabilities();
        if (this$supportedCapabilities == null ? other$supportedCapabilities != null : !((Object)this$supportedCapabilities).equals(other$supportedCapabilities)) {
            return false;
        }
        InitTradeRequest this$tradeRequest = this.getTradeRequest();
        InitTradeRequest other$tradeRequest = other.getTradeRequest();
        return !(this$tradeRequest == null ? other$tradeRequest != null : !((Object)this$tradeRequest).equals(other$tradeRequest));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof OfferAvailabilityRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        long $takersTradePrice = this.getTakersTradePrice();
        result = result * 59 + (int)($takersTradePrice >>> 32 ^ $takersTradePrice);
        result = result * 59 + (this.isTakerApiUser() ? 79 : 97);
        PubKeyRing $pubKeyRing = this.getPubKeyRing();
        result = result * 59 + ($pubKeyRing == null ? 43 : ((Object)$pubKeyRing).hashCode());
        Capabilities $supportedCapabilities = this.getSupportedCapabilities();
        result = result * 59 + ($supportedCapabilities == null ? 43 : ((Object)$supportedCapabilities).hashCode());
        InitTradeRequest $tradeRequest = this.getTradeRequest();
        result = result * 59 + ($tradeRequest == null ? 43 : ((Object)$tradeRequest).hashCode());
        return result;
    }
}

