/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.offer.messages;

import com.google.protobuf.ByteString;
import haveno.common.app.Capabilities;
import haveno.common.app.Version;
import haveno.common.proto.ProtoUtil;
import haveno.core.offer.AvailabilityResult;
import haveno.core.offer.messages.OfferMessage;
import haveno.network.p2p.SupportedCapabilitiesMessage;
import java.util.Arrays;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import protobuf.NetworkEnvelope;
import protobuf.OfferAvailabilityResponse;

public final class OfferAvailabilityResponse
extends OfferMessage
implements SupportedCapabilitiesMessage {
    private final AvailabilityResult availabilityResult;
    @Nullable
    private final Capabilities supportedCapabilities;
    @Nullable
    private final byte[] makerSignature;

    public OfferAvailabilityResponse(String offerId, AvailabilityResult availabilityResult, @Nullable byte[] makerSignature) {
        this(offerId, availabilityResult, Capabilities.app, Version.getP2PMessageVersion(), UUID.randomUUID().toString(), makerSignature);
    }

    private OfferAvailabilityResponse(String offerId, AvailabilityResult availabilityResult, @Nullable Capabilities supportedCapabilities, String messageVersion, @Nullable String uid, byte[] makerSignature) {
        super(messageVersion, offerId, uid);
        this.availabilityResult = availabilityResult;
        this.supportedCapabilities = supportedCapabilities;
        this.makerSignature = makerSignature;
    }

    @Override
    public NetworkEnvelope toProtoNetworkEnvelope() {
        OfferAvailabilityResponse.Builder builder = protobuf.OfferAvailabilityResponse.newBuilder().setOfferId(this.offerId).setAvailabilityResult(protobuf.AvailabilityResult.valueOf(this.availabilityResult.name()));
        Optional.ofNullable(this.supportedCapabilities).ifPresent(e -> builder.addAllSupportedCapabilities(Capabilities.toIntList(this.supportedCapabilities)));
        Optional.ofNullable(this.uid).ifPresent(e -> builder.setUid(this.uid));
        Optional.ofNullable(this.makerSignature).ifPresent(e -> builder.setMakerSignature(ByteString.copyFrom(e)));
        return this.getNetworkEnvelopeBuilder().setOfferAvailabilityResponse(builder).build();
    }

    public static OfferAvailabilityResponse fromProto(protobuf.OfferAvailabilityResponse proto, String messageVersion) {
        return new OfferAvailabilityResponse(proto.getOfferId(), ProtoUtil.enumFromProto(AvailabilityResult.class, proto.getAvailabilityResult().name()), Capabilities.fromIntList(proto.getSupportedCapabilitiesList()), messageVersion, proto.getUid().isEmpty() ? null : proto.getUid(), ProtoUtil.byteArrayOrNullFromProto(proto.getMakerSignature()));
    }

    public AvailabilityResult getAvailabilityResult() {
        return this.availabilityResult;
    }

    @Override
    @Nullable
    public Capabilities getSupportedCapabilities() {
        return this.supportedCapabilities;
    }

    @Nullable
    public byte[] getMakerSignature() {
        return this.makerSignature;
    }

    @Override
    public String toString() {
        return "OfferAvailabilityResponse(availabilityResult=" + String.valueOf((Object)this.getAvailabilityResult()) + ", supportedCapabilities=" + String.valueOf(this.getSupportedCapabilities()) + ", makerSignature=" + Arrays.toString(this.getMakerSignature()) + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OfferAvailabilityResponse)) {
            return false;
        }
        OfferAvailabilityResponse other = (OfferAvailabilityResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AvailabilityResult this$availabilityResult = this.getAvailabilityResult();
        AvailabilityResult other$availabilityResult = other.getAvailabilityResult();
        if (this$availabilityResult == null ? other$availabilityResult != null : !((Object)((Object)this$availabilityResult)).equals((Object)other$availabilityResult)) {
            return false;
        }
        Capabilities this$supportedCapabilities = this.getSupportedCapabilities();
        Capabilities other$supportedCapabilities = other.getSupportedCapabilities();
        if (this$supportedCapabilities == null ? other$supportedCapabilities != null : !((Object)this$supportedCapabilities).equals(other$supportedCapabilities)) {
            return false;
        }
        return Arrays.equals(this.getMakerSignature(), other.getMakerSignature());
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof OfferAvailabilityResponse;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        AvailabilityResult $availabilityResult = this.getAvailabilityResult();
        result = result * 59 + ($availabilityResult == null ? 43 : ((Object)((Object)$availabilityResult)).hashCode());
        Capabilities $supportedCapabilities = this.getSupportedCapabilities();
        result = result * 59 + ($supportedCapabilities == null ? 43 : ((Object)$supportedCapabilities).hashCode());
        result = result * 59 + Arrays.hashCode(this.getMakerSignature());
        return result;
    }
}

