/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.offer.messages;

import haveno.common.crypto.PubKeyRing;
import haveno.core.offer.OfferPayload;
import haveno.core.offer.messages.OfferMessage;
import haveno.network.p2p.DirectMessage;
import haveno.network.p2p.NodeAddress;
import java.util.ArrayList;
import java.util.List;
import protobuf.NetworkEnvelope;
import protobuf.SignOfferRequest;

public final class SignOfferRequest
extends OfferMessage
implements DirectMessage {
    private final NodeAddress senderNodeAddress;
    private final PubKeyRing pubKeyRing;
    private final String senderAccountId;
    private final OfferPayload offerPayload;
    private final long currentDate;
    private final String reserveTxHash;
    private final String reserveTxHex;
    private final String reserveTxKey;
    private final List<String> reserveTxKeyImages;
    private final String payoutAddress;

    public SignOfferRequest(String offerId, NodeAddress senderNodeAddress, PubKeyRing pubKeyRing, String senderAccountId, OfferPayload offerPayload, String uid, String messageVersion, long currentDate, String reserveTxHash, String reserveTxHex, String reserveTxKey, List<String> reserveTxKeyImages, String payoutAddress) {
        super(messageVersion, offerId, uid);
        this.senderNodeAddress = senderNodeAddress;
        this.pubKeyRing = pubKeyRing;
        this.senderAccountId = senderAccountId;
        this.offerPayload = offerPayload;
        this.currentDate = currentDate;
        this.reserveTxHash = reserveTxHash;
        this.reserveTxHex = reserveTxHex;
        this.reserveTxKey = reserveTxKey;
        this.reserveTxKeyImages = reserveTxKeyImages;
        this.payoutAddress = payoutAddress;
    }

    @Override
    public NetworkEnvelope toProtoNetworkEnvelope() {
        SignOfferRequest.Builder builder = protobuf.SignOfferRequest.newBuilder().setOfferId(this.offerId).setSenderNodeAddress(this.senderNodeAddress.toProtoMessage()).setPubKeyRing(this.pubKeyRing.toProtoMessage()).setSenderAccountId(this.senderAccountId).setOfferPayload(this.offerPayload.toProtoMessage().getOfferPayload()).setUid(this.uid).setCurrentDate(this.currentDate).setReserveTxHash(this.reserveTxHash).setReserveTxHex(this.reserveTxHex).setReserveTxKey(this.reserveTxKey).addAllReserveTxKeyImages(this.reserveTxKeyImages).setPayoutAddress(this.payoutAddress);
        return this.getNetworkEnvelopeBuilder().setSignOfferRequest(builder).build();
    }

    public static SignOfferRequest fromProto(protobuf.SignOfferRequest proto, String messageVersion) {
        return new SignOfferRequest(proto.getOfferId(), NodeAddress.fromProto(proto.getSenderNodeAddress()), PubKeyRing.fromProto(proto.getPubKeyRing()), proto.getSenderAccountId(), OfferPayload.fromProto(proto.getOfferPayload()), proto.getUid(), messageVersion, proto.getCurrentDate(), proto.getReserveTxHash(), proto.getReserveTxHex(), proto.getReserveTxKey(), new ArrayList<String>(proto.getReserveTxKeyImagesList()), proto.getPayoutAddress());
    }

    @Override
    public String toString() {
        return "SignOfferRequest {\n     senderNodeAddress=" + String.valueOf(this.senderNodeAddress) + ",\n     pubKeyRing=" + String.valueOf(this.pubKeyRing) + ",\n     currentDate=" + this.currentDate + ",\n     reserveTxHash='" + this.reserveTxHash + ",\n     reserveTxHex='" + this.reserveTxHex + ",\n     reserveTxKey='" + this.reserveTxKey + ",\n     reserveTxKeyImages='" + String.valueOf(this.reserveTxKeyImages) + ",\n     payoutAddress='" + this.payoutAddress + "\n} " + super.toString();
    }

    public NodeAddress getSenderNodeAddress() {
        return this.senderNodeAddress;
    }

    public PubKeyRing getPubKeyRing() {
        return this.pubKeyRing;
    }

    public String getSenderAccountId() {
        return this.senderAccountId;
    }

    public OfferPayload getOfferPayload() {
        return this.offerPayload;
    }

    public long getCurrentDate() {
        return this.currentDate;
    }

    public String getReserveTxHash() {
        return this.reserveTxHash;
    }

    public String getReserveTxHex() {
        return this.reserveTxHex;
    }

    public String getReserveTxKey() {
        return this.reserveTxKey;
    }

    public List<String> getReserveTxKeyImages() {
        return this.reserveTxKeyImages;
    }

    public String getPayoutAddress() {
        return this.payoutAddress;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SignOfferRequest)) {
            return false;
        }
        SignOfferRequest other = (SignOfferRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getCurrentDate() != other.getCurrentDate()) {
            return false;
        }
        NodeAddress this$senderNodeAddress = this.getSenderNodeAddress();
        NodeAddress other$senderNodeAddress = other.getSenderNodeAddress();
        if (this$senderNodeAddress == null ? other$senderNodeAddress != null : !((Object)this$senderNodeAddress).equals(other$senderNodeAddress)) {
            return false;
        }
        PubKeyRing this$pubKeyRing = this.getPubKeyRing();
        PubKeyRing other$pubKeyRing = other.getPubKeyRing();
        if (this$pubKeyRing == null ? other$pubKeyRing != null : !((Object)this$pubKeyRing).equals(other$pubKeyRing)) {
            return false;
        }
        String this$senderAccountId = this.getSenderAccountId();
        String other$senderAccountId = other.getSenderAccountId();
        if (this$senderAccountId == null ? other$senderAccountId != null : !this$senderAccountId.equals(other$senderAccountId)) {
            return false;
        }
        OfferPayload this$offerPayload = this.getOfferPayload();
        OfferPayload other$offerPayload = other.getOfferPayload();
        if (this$offerPayload == null ? other$offerPayload != null : !((Object)this$offerPayload).equals(other$offerPayload)) {
            return false;
        }
        String this$reserveTxHash = this.getReserveTxHash();
        String other$reserveTxHash = other.getReserveTxHash();
        if (this$reserveTxHash == null ? other$reserveTxHash != null : !this$reserveTxHash.equals(other$reserveTxHash)) {
            return false;
        }
        String this$reserveTxHex = this.getReserveTxHex();
        String other$reserveTxHex = other.getReserveTxHex();
        if (this$reserveTxHex == null ? other$reserveTxHex != null : !this$reserveTxHex.equals(other$reserveTxHex)) {
            return false;
        }
        String this$reserveTxKey = this.getReserveTxKey();
        String other$reserveTxKey = other.getReserveTxKey();
        if (this$reserveTxKey == null ? other$reserveTxKey != null : !this$reserveTxKey.equals(other$reserveTxKey)) {
            return false;
        }
        List<String> this$reserveTxKeyImages = this.getReserveTxKeyImages();
        List<String> other$reserveTxKeyImages = other.getReserveTxKeyImages();
        if (this$reserveTxKeyImages == null ? other$reserveTxKeyImages != null : !((Object)this$reserveTxKeyImages).equals(other$reserveTxKeyImages)) {
            return false;
        }
        String this$payoutAddress = this.getPayoutAddress();
        String other$payoutAddress = other.getPayoutAddress();
        return !(this$payoutAddress == null ? other$payoutAddress != null : !this$payoutAddress.equals(other$payoutAddress));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof SignOfferRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        long $currentDate = this.getCurrentDate();
        result = result * 59 + (int)($currentDate >>> 32 ^ $currentDate);
        NodeAddress $senderNodeAddress = this.getSenderNodeAddress();
        result = result * 59 + ($senderNodeAddress == null ? 43 : ((Object)$senderNodeAddress).hashCode());
        PubKeyRing $pubKeyRing = this.getPubKeyRing();
        result = result * 59 + ($pubKeyRing == null ? 43 : ((Object)$pubKeyRing).hashCode());
        String $senderAccountId = this.getSenderAccountId();
        result = result * 59 + ($senderAccountId == null ? 43 : $senderAccountId.hashCode());
        OfferPayload $offerPayload = this.getOfferPayload();
        result = result * 59 + ($offerPayload == null ? 43 : ((Object)$offerPayload).hashCode());
        String $reserveTxHash = this.getReserveTxHash();
        result = result * 59 + ($reserveTxHash == null ? 43 : $reserveTxHash.hashCode());
        String $reserveTxHex = this.getReserveTxHex();
        result = result * 59 + ($reserveTxHex == null ? 43 : $reserveTxHex.hashCode());
        String $reserveTxKey = this.getReserveTxKey();
        result = result * 59 + ($reserveTxKey == null ? 43 : $reserveTxKey.hashCode());
        List<String> $reserveTxKeyImages = this.getReserveTxKeyImages();
        result = result * 59 + ($reserveTxKeyImages == null ? 43 : ((Object)$reserveTxKeyImages).hashCode());
        String $payoutAddress = this.getPayoutAddress();
        result = result * 59 + ($payoutAddress == null ? 43 : $payoutAddress.hashCode());
        return result;
    }
}

