/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.offer.placeoffer;

import haveno.common.Timer;
import haveno.common.UserThread;
import haveno.common.handlers.ErrorMessageHandler;
import haveno.common.taskrunner.TaskRunner;
import haveno.core.locale.Res;
import haveno.core.offer.messages.SignOfferResponse;
import haveno.core.offer.placeoffer.PlaceOfferModel;
import haveno.core.offer.placeoffer.tasks.MakerProcessSignOfferResponse;
import haveno.core.offer.placeoffer.tasks.MakerReserveOfferFunds;
import haveno.core.offer.placeoffer.tasks.MakerSendSignOfferRequest;
import haveno.core.offer.placeoffer.tasks.MaybeAddToOfferBook;
import haveno.core.offer.placeoffer.tasks.ValidateOffer;
import haveno.core.trade.handlers.TransactionResultHandler;
import haveno.core.trade.protocol.TradeProtocol;
import haveno.network.p2p.NodeAddress;
import org.bitcoinj.core.Transaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlaceOfferProtocol {
    private static final Logger log = LoggerFactory.getLogger(PlaceOfferProtocol.class);
    private final PlaceOfferModel model;
    private Timer timeoutTimer;
    private TransactionResultHandler resultHandler;
    private ErrorMessageHandler errorMessageHandler;
    private TaskRunner<PlaceOfferModel> taskRunner;

    public PlaceOfferProtocol(PlaceOfferModel model, TransactionResultHandler resultHandler, ErrorMessageHandler errorMessageHandler) {
        this.model = model;
        this.model.setProtocol(this);
        this.resultHandler = resultHandler;
        this.errorMessageHandler = errorMessageHandler;
    }

    public void placeOffer() {
        this.startTimeoutTimer();
        this.taskRunner = new TaskRunner<PlaceOfferModel>(this.model, () -> {
            if (this.model.getSignOfferResponse() == null) {
                this.startTimeoutTimer();
            }
        }, errorMessage -> this.handleError(errorMessage));
        this.taskRunner.addTasks(ValidateOffer.class, MakerReserveOfferFunds.class, MakerSendSignOfferRequest.class);
        this.taskRunner.run();
    }

    public void cancelOffer() {
        this.handleError("Offer was canceled: " + this.model.getOpenOffer().getOffer().getId());
    }

    public void handleSignOfferResponse(SignOfferResponse response, NodeAddress sender) {
        log.debug("handleSignOfferResponse() " + this.model.getOpenOffer().getOffer().getId());
        this.model.setSignOfferResponse(response);
        if (!this.model.getOpenOffer().getOffer().getOfferPayload().getArbitratorSigner().equals(sender)) {
            log.warn("Ignoring sign offer response from different sender");
            return;
        }
        if (this.model.getOpenOffer().getOffer().getOfferPayload().getDate() != response.getSignedOfferPayload().getDate()) {
            log.warn("Ignoring sign offer response from arbitrator for offer payload with different timestamp");
            return;
        }
        if (this.timeoutTimer == null) {
            log.warn("Ignoring sign offer response from arbitrator because timeout has expired for offer " + this.model.getOpenOffer().getOffer().getId());
            return;
        }
        this.startTimeoutTimer();
        TaskRunner<PlaceOfferModel> taskRunner = new TaskRunner<PlaceOfferModel>(this.model, () -> {
            log.debug("sequence at handleSignOfferResponse completed");
            this.stopTimeoutTimer();
            this.handleResult(this.model.getTransaction());
        }, errorMessage -> {
            if (this.model.isOfferAddedToOfferBook()) {
                this.model.getOfferBookService().removeOffer(this.model.getOpenOffer().getOffer().getOfferPayload(), () -> {
                    this.model.setOfferAddedToOfferBook(false);
                    log.debug("OfferPayload removed from offer book.");
                }, log::error);
            }
            this.handleError(errorMessage);
        });
        taskRunner.addTasks(MakerProcessSignOfferResponse.class, MaybeAddToOfferBook.class);
        taskRunner.run();
    }

    public synchronized void startTimeoutTimer() {
        if (this.resultHandler == null) {
            return;
        }
        this.stopTimeoutTimer();
        this.timeoutTimer = UserThread.runAfter(() -> this.handleError(Res.get("createOffer.timeoutAtPublishing")), TradeProtocol.TRADE_STEP_TIMEOUT_SECONDS);
    }

    private synchronized void stopTimeoutTimer() {
        if (this.timeoutTimer != null) {
            this.timeoutTimer.stop();
            this.timeoutTimer = null;
        }
    }

    private synchronized void handleResult(Transaction transaction) {
        this.resultHandler.handleResult(transaction);
        this.resetHandlers();
    }

    private synchronized void handleError(String errorMessage) {
        if (this.timeoutTimer != null) {
            this.taskRunner.cancel();
            if (!this.model.getOpenOffer().isCanceled()) {
                this.model.getOpenOffer().getOffer().setErrorMessage(errorMessage);
            }
            this.stopTimeoutTimer();
            this.errorMessageHandler.handleErrorMessage(errorMessage);
        }
        this.resetHandlers();
    }

    private synchronized void resetHandlers() {
        this.resultHandler = null;
        this.errorMessageHandler = null;
    }
}

