/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.offer.placeoffer.tasks;

import com.google.common.base.Preconditions;
import haveno.common.taskrunner.Task;
import haveno.common.taskrunner.TaskRunner;
import haveno.core.offer.Offer;
import haveno.core.offer.placeoffer.PlaceOfferModel;
import haveno.core.support.dispute.arbitration.arbitrator.Arbitrator;
import haveno.core.trade.HavenoUtils;

public class MakerProcessSignOfferResponse
extends Task<PlaceOfferModel> {
    public MakerProcessSignOfferResponse(TaskRunner<PlaceOfferModel> taskHandler, PlaceOfferModel model) {
        super(taskHandler, model);
    }

    @Override
    protected void run() {
        Offer offer = ((PlaceOfferModel)this.model).getOpenOffer().getOffer();
        try {
            this.runInterceptHook();
            Arbitrator arbitrator = Preconditions.checkNotNull(((PlaceOfferModel)this.model).getUser().getAcceptedArbitratorByAddress(offer.getOfferPayload().getArbitratorSigner()), "user.getAcceptedArbitratorByAddress(arbitratorSigner) must not be null");
            if (!HavenoUtils.isArbitratorSignatureValid(((PlaceOfferModel)this.model).getSignOfferResponse().getSignedOfferPayload(), arbitrator)) {
                throw new RuntimeException("Arbitrator's offer payload has invalid signature, offerId=" + offer.getId());
            }
            offer.getOfferPayload().setArbitratorSignature(((PlaceOfferModel)this.model).getSignOfferResponse().getSignedOfferPayload().getArbitratorSignature());
            if (!HavenoUtils.isArbitratorSignatureValid(offer.getOfferPayload(), arbitrator)) {
                throw new RuntimeException("Maker's offer payload has invalid signature, offerId=" + offer.getId());
            }
            offer.setState(Offer.State.AVAILABLE);
            this.complete();
        }
        catch (Exception e) {
            offer.setErrorMessage("An error occurred.\nError message:\n" + e.getMessage());
            this.failed(e);
        }
    }
}

