/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.offer.placeoffer.tasks;

import haveno.common.taskrunner.Task;
import haveno.common.taskrunner.TaskRunner;
import haveno.core.offer.Offer;
import haveno.core.offer.OfferDirection;
import haveno.core.offer.OpenOffer;
import haveno.core.offer.placeoffer.PlaceOfferModel;
import haveno.core.trade.HavenoUtils;
import haveno.core.xmr.model.XmrAddressEntry;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import monero.common.MoneroRpcConnection;
import monero.daemon.model.MoneroOutput;
import monero.daemon.model.MoneroTx;
import monero.wallet.model.MoneroOutputWallet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MakerReserveOfferFunds
extends Task<PlaceOfferModel> {
    private static final Logger log = LoggerFactory.getLogger(MakerReserveOfferFunds.class);

    public MakerReserveOfferFunds(TaskRunner taskHandler, PlaceOfferModel model) {
        super(taskHandler, model);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void run() {
        OpenOffer openOffer = ((PlaceOfferModel)this.model).getOpenOffer();
        Offer offer = openOffer.getOffer();
        try {
            this.runInterceptHook();
            if (openOffer.getReserveTxHash() != null && !openOffer.getReserveTxHash().isEmpty()) {
                log.info("Reserve tx already created for offerId={}", (Object)openOffer.getShortId());
                this.complete();
                return;
            }
            ((PlaceOfferModel)this.model).getXmrWalletService().getXmrConnectionService().verifyConnection();
            Object object = HavenoUtils.xmrWalletService.getWalletLock();
            synchronized (object) {
                this.verifyPending();
                ((PlaceOfferModel)this.model).getProtocol().startTimeoutTimer();
                BigInteger penaltyFee = HavenoUtils.multiply(offer.getAmount(), offer.getPenaltyFeePct());
                BigInteger makerFee = offer.getMaxMakerFee();
                BigInteger sendAmount = offer.getDirection() == OfferDirection.BUY ? BigInteger.ZERO : offer.getAmount();
                BigInteger securityDeposit = offer.getDirection() == OfferDirection.BUY ? offer.getMaxBuyerSecurityDeposit() : offer.getMaxSellerSecurityDeposit();
                String returnAddress = ((PlaceOfferModel)this.model).getXmrWalletService().getOrCreateAddressEntry(offer.getId(), XmrAddressEntry.Context.TRADE_PAYOUT).getAddressString();
                XmrAddressEntry fundingEntry = ((PlaceOfferModel)this.model).getXmrWalletService().getAddressEntry(offer.getId(), XmrAddressEntry.Context.OFFER_FUNDING).orElse(null);
                Integer preferredSubaddressIndex = fundingEntry == null ? null : Integer.valueOf(fundingEntry.getSubaddressIndex());
                for (OpenOffer openOffer2 : ((PlaceOfferModel)this.model).getOpenOfferManager().getOpenOfferGroup(((PlaceOfferModel)this.model).getOpenOffer().getGroupId())) {
                    if (openOffer2.getId().equals(offer.getId())) continue;
                    ((PlaceOfferModel)this.model).getXmrWalletService().cloneAddressEntries(openOffer.getId(), openOffer2.getId());
                }
                MoneroTx reserveTx = null;
                try {
                    Object object2 = HavenoUtils.getWalletFunctionLock();
                    synchronized (object2) {
                        for (int i = 0; i < 5; ++i) {
                            MoneroRpcConnection sourceConnection = ((PlaceOfferModel)this.model).getXmrWalletService().getXmrConnectionService().getConnection();
                            try {
                                reserveTx = ((PlaceOfferModel)this.model).getXmrWalletService().createReserveTx(penaltyFee, makerFee, sendAmount, securityDeposit, returnAddress, openOffer.isReserveExactAmount(), preferredSubaddressIndex);
                            }
                            catch (IllegalStateException e) {
                                log.warn("Illegal state creating reserve tx, offerId={}, error={}", openOffer.getShortId(), i + 1, e.getMessage());
                                throw e;
                            }
                            catch (Exception e) {
                                log.warn("Error creating reserve tx, offerId={}, attempt={}/{}, error={}", openOffer.getShortId(), i + 1, 5, e.getMessage());
                                ((PlaceOfferModel)this.model).getXmrWalletService().handleWalletError(e, sourceConnection);
                                this.verifyPending();
                                if (i == 4) {
                                    throw e;
                                }
                                ((PlaceOfferModel)this.model).getProtocol().startTimeoutTimer();
                                HavenoUtils.waitFor(5000L);
                            }
                            this.verifyPending();
                            if (reserveTx != null) break;
                        }
                    }
                }
                catch (Exception exception) {
                    ((PlaceOfferModel)this.model).getXmrWalletService().resetAddressEntriesForOpenOffer(offer.getId());
                    if (reserveTx != null) {
                        ((PlaceOfferModel)this.model).getXmrWalletService().thawOutputs(HavenoUtils.getInputKeyImages(reserveTx));
                    }
                    offer.getOfferPayload().setReserveTxKeyImages(null);
                    throw exception;
                }
                ((PlaceOfferModel)this.model).getProtocol().startTimeoutTimer();
                ArrayList<String> arrayList = new ArrayList<String>();
                for (MoneroOutput input : reserveTx.getInputs()) {
                    arrayList.add(input.getKeyImage().getHex());
                }
                if (openOffer.getGroupId() == null) {
                    openOffer.setReserveTxHash(reserveTx.getHash());
                    openOffer.setReserveTxHex(reserveTx.getFullHex());
                    openOffer.setReserveTxKey(reserveTx.getKey());
                    offer.getOfferPayload().setReserveTxKeyImages(arrayList);
                } else {
                    for (OpenOffer offerClone : ((PlaceOfferModel)this.model).getOpenOfferManager().getOpenOfferGroup(((PlaceOfferModel)this.model).getOpenOffer().getGroupId())) {
                        offerClone.setReserveTxHash(reserveTx.getHash());
                        offerClone.setReserveTxHex(reserveTx.getFullHex());
                        offerClone.setReserveTxKey(reserveTx.getKey());
                        offerClone.getOffer().getOfferPayload().setReserveTxKeyImages(arrayList);
                    }
                }
                if (fundingEntry != null) {
                    List<MoneroOutputWallet> inputs = ((PlaceOfferModel)this.model).getXmrWalletService().getOutputs(arrayList);
                    HashSet<Integer> inputSubaddressIndices = new HashSet<Integer>();
                    for (MoneroOutputWallet input : inputs) {
                        if (input.getAccountIndex() != 0) continue;
                        inputSubaddressIndices.add(input.getSubaddressIndex());
                    }
                    for (OpenOffer clone : ((PlaceOfferModel)this.model).getOpenOfferManager().getOpenOfferGroup(((PlaceOfferModel)this.model).getOpenOffer().getGroupId())) {
                        XmrAddressEntry cloneFundingEntry = ((PlaceOfferModel)this.model).getXmrWalletService().getAddressEntry(clone.getId(), XmrAddressEntry.Context.OFFER_FUNDING).orElse(null);
                        if (cloneFundingEntry == null || inputSubaddressIndices.contains(cloneFundingEntry.getSubaddressIndex()) || !inputSubaddressIndices.contains(cloneFundingEntry.getSubaddressIndex())) continue;
                        ((PlaceOfferModel)this.model).getXmrWalletService().swapAddressEntryToAvailable(offer.getId(), XmrAddressEntry.Context.OFFER_FUNDING);
                    }
                }
            }
            this.complete();
        }
        catch (Throwable t2) {
            offer.setErrorMessage("An error occurred.\nError message:\n" + t2.getMessage());
            this.failed(t2);
        }
    }

    private boolean isPending() {
        return ((PlaceOfferModel)this.model).getOpenOffer().isPending();
    }

    private void verifyPending() {
        if (!this.isPending()) {
            throw new RuntimeException("Offer " + ((PlaceOfferModel)this.model).getOpenOffer().getOffer().getId() + " is canceled");
        }
    }
}

