/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.offer.placeoffer.tasks;

import com.google.common.base.Preconditions;
import haveno.common.taskrunner.Task;
import haveno.common.taskrunner.TaskRunner;
import haveno.core.offer.Offer;
import haveno.core.offer.OpenOffer;
import haveno.core.offer.placeoffer.PlaceOfferModel;

public class MaybeAddToOfferBook
extends Task<PlaceOfferModel> {
    public MaybeAddToOfferBook(TaskRunner<PlaceOfferModel> taskHandler, PlaceOfferModel model) {
        super(taskHandler, model);
    }

    @Override
    protected void run() {
        try {
            this.runInterceptHook();
            Preconditions.checkNotNull(((PlaceOfferModel)this.model).getSignOfferResponse().getSignedOfferPayload().getArbitratorSignature(), "Offer's arbitrator signature is null: " + ((PlaceOfferModel)this.model).getOpenOffer().getOffer().getId());
            if (((PlaceOfferModel)this.model).getOpenOfferManager().hasConflictingClone(((PlaceOfferModel)this.model).getOpenOffer())) {
                ((PlaceOfferModel)this.model).getOpenOffer().setState(OpenOffer.State.DEACTIVATED);
                ((PlaceOfferModel)this.model).setOfferAddedToOfferBook(false);
                this.complete();
                return;
            }
            if (!((PlaceOfferModel)this.model).getOpenOffer().isPending() && !((PlaceOfferModel)this.model).getOpenOffer().isAvailable()) {
                this.complete();
                return;
            }
            ((PlaceOfferModel)this.model).getOfferBookService().addOffer(new Offer(((PlaceOfferModel)this.model).getSignOfferResponse().getSignedOfferPayload()), () -> {
                ((PlaceOfferModel)this.model).getOpenOffer().setState(OpenOffer.State.AVAILABLE);
                ((PlaceOfferModel)this.model).setOfferAddedToOfferBook(true);
                this.complete();
            }, errorMessage -> {
                ((PlaceOfferModel)this.model).getOpenOffer().getOffer().setErrorMessage("Could not add offer to offerbook.\nPlease check your network connection and try again.");
                this.failed(errorMessage);
            });
        }
        catch (Throwable t2) {
            ((PlaceOfferModel)this.model).getOpenOffer().getOffer().setErrorMessage("An error occurred.\nError message:\n" + t2.getMessage());
            this.failed(t2);
        }
    }
}

