/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.offer.placeoffer.tasks;

import com.google.common.base.Preconditions;
import haveno.common.taskrunner.Task;
import haveno.common.taskrunner.TaskRunner;
import haveno.core.account.witness.AccountAgeWitnessService;
import haveno.core.offer.Offer;
import haveno.core.offer.OfferDirection;
import haveno.core.offer.placeoffer.PlaceOfferModel;
import haveno.core.trade.HavenoUtils;
import haveno.core.trade.messages.TradeMessage;
import haveno.core.user.User;
import java.math.BigInteger;
import org.bitcoinj.core.Coin;

public class ValidateOffer
extends Task<PlaceOfferModel> {
    public ValidateOffer(TaskRunner<PlaceOfferModel> taskHandler, PlaceOfferModel model) {
        super(taskHandler, model);
    }

    @Override
    protected void run() {
        Offer offer = ((PlaceOfferModel)this.model).getOpenOffer().getOffer();
        try {
            this.runInterceptHook();
            ValidateOffer.validateOffer(offer, ((PlaceOfferModel)this.model).getAccountAgeWitnessService(), ((PlaceOfferModel)this.model).getUser());
            this.complete();
        }
        catch (Exception e) {
            offer.setErrorMessage("An error occurred.\nError message:\n" + e.getMessage());
            this.failed(e);
        }
    }

    public static void validateOffer(Offer offer, AccountAgeWitnessService accountAgeWitnessService, User user) {
        ValidateOffer.checkBINotNullOrZero(offer.getAmount(), "Amount");
        ValidateOffer.checkBINotNullOrZero(offer.getMinAmount(), "MinAmount");
        ValidateOffer.checkBINotNullOrZero(offer.getMaxTradeLimit(), "MaxTradeLimit");
        if (offer.getMakerFeePct() < 0.0) {
            throw new IllegalArgumentException("Maker fee must be >= 0% but was " + offer.getMakerFeePct());
        }
        if (offer.getTakerFeePct() < 0.0) {
            throw new IllegalArgumentException("Taker fee must be >= 0% but was " + offer.getTakerFeePct());
        }
        offer.isPrivateOffer();
        if (offer.isPrivateOffer()) {
            boolean isBuyerMaker;
            boolean bl = isBuyerMaker = offer.getDirection() == OfferDirection.BUY;
            if (isBuyerMaker) {
                if (offer.getBuyerSecurityDepositPct() <= 0.0) {
                    throw new IllegalArgumentException("Buyer security deposit percent must be positive but was " + offer.getBuyerSecurityDepositPct());
                }
                if (offer.getSellerSecurityDepositPct() < 0.0) {
                    throw new IllegalArgumentException("Seller security deposit percent must be >= 0% but was " + offer.getSellerSecurityDepositPct());
                }
            } else {
                if (offer.getBuyerSecurityDepositPct() < 0.0) {
                    throw new IllegalArgumentException("Buyer security deposit percent must be >= 0% but was " + offer.getBuyerSecurityDepositPct());
                }
                if (offer.getSellerSecurityDepositPct() <= 0.0) {
                    throw new IllegalArgumentException("Seller security deposit percent must be positive but was " + offer.getSellerSecurityDepositPct());
                }
            }
        } else {
            if (offer.getBuyerSecurityDepositPct() <= 0.0) {
                throw new IllegalArgumentException("Buyer security deposit percent must be positive but was " + offer.getBuyerSecurityDepositPct());
            }
            if (offer.getSellerSecurityDepositPct() <= 0.0) {
                throw new IllegalArgumentException("Seller security deposit percent must be positive but was " + offer.getSellerSecurityDepositPct());
            }
        }
        long maxAmount = accountAgeWitnessService.getMyTradeLimit(user.getPaymentAccount(offer.getMakerPaymentAccountId()), offer.getCurrencyCode(), offer.getDirection(), offer.hasBuyerAsTakerWithoutDeposit());
        Preconditions.checkArgument(offer.getAmount().longValueExact() <= maxAmount, "Amount is larger than " + HavenoUtils.atomicUnitsToXmr(maxAmount) + " XMR");
        Preconditions.checkArgument(offer.getAmount().compareTo(offer.getMinAmount()) >= 0, "MinAmount is larger than Amount");
        Preconditions.checkNotNull(offer.getPrice(), "Price is null");
        if (!offer.isUseMarketBasedPrice()) {
            Preconditions.checkArgument(offer.getPrice().isPositive(), "Price must be positive unless using market based price. price=" + offer.getPrice().toFriendlyString());
        }
        Preconditions.checkArgument(offer.getDate().getTime() > 0L, "Date must not be 0. date=" + offer.getDate().toString());
        Preconditions.checkNotNull(offer.getCurrencyCode(), "Currency is null");
        Preconditions.checkNotNull(offer.getDirection(), "Direction is null");
        Preconditions.checkNotNull(offer.getId(), "Id is null");
        Preconditions.checkNotNull(offer.getPubKeyRing(), "pubKeyRing is null");
        Preconditions.checkNotNull(offer.getMinAmount(), "MinAmount is null");
        Preconditions.checkNotNull(offer.getPrice(), "Price is null");
        Preconditions.checkNotNull(offer.getVersionNr(), "VersionNr is null");
        Preconditions.checkArgument(offer.getMaxTradePeriod() > 0L, "maxTradePeriod must be positive. maxTradePeriod=" + offer.getMaxTradePeriod());
    }

    private static void checkBINotNullOrZero(BigInteger value, String name) {
        Preconditions.checkNotNull(value, name + " is null");
        Preconditions.checkArgument(value.compareTo(BigInteger.ZERO) > 0, name + " must be positive. " + name + "=" + String.valueOf(value));
    }

    private static void checkCoinNotNullOrZero(Coin value, String name) {
        Preconditions.checkNotNull(value, name + " is null");
        Preconditions.checkArgument(value.isPositive(), name + " must be positive. " + name + "=" + value.toFriendlyString());
    }

    private static String nonEmptyStringOf(String value) {
        Preconditions.checkNotNull(value);
        Preconditions.checkArgument(value.length() > 0);
        return value;
    }

    private static long nonNegativeLongOf(long value) {
        Preconditions.checkArgument(value >= 0L);
        return value;
    }

    private static Coin nonZeroCoinOf(Coin value) {
        Preconditions.checkNotNull(value);
        Preconditions.checkArgument(!value.isZero());
        return value;
    }

    private static Coin positiveCoinOf(Coin value) {
        Preconditions.checkNotNull(value);
        Preconditions.checkArgument(value.isPositive());
        return value;
    }

    private static void checkTradeId(String tradeId, TradeMessage tradeMessage) {
        Preconditions.checkArgument(tradeId.equals(tradeMessage.getOfferId()));
    }
}

