/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.payment;

import haveno.core.api.model.PaymentAccountFormField;
import haveno.core.locale.TradeCurrency;
import haveno.core.locale.TraditionalCurrency;
import haveno.core.payment.CountryBasedPaymentAccount;
import haveno.core.payment.payload.BizumAccountPayload;
import haveno.core.payment.payload.PaymentAccountPayload;
import haveno.core.payment.payload.PaymentMethod;
import java.util.List;
import lombok.NonNull;

public final class BizumAccount
extends CountryBasedPaymentAccount {
    public static final List<TradeCurrency> SUPPORTED_CURRENCIES = List.of(new TraditionalCurrency("EUR"));

    public BizumAccount() {
        super(PaymentMethod.BIZUM);
    }

    @Override
    protected PaymentAccountPayload createPayload() {
        return new BizumAccountPayload(this.paymentMethod.getId(), this.id);
    }

    public void setMobileNr(String mobileNr) {
        ((BizumAccountPayload)this.paymentAccountPayload).setMobileNr(mobileNr);
    }

    public String getMobileNr() {
        return ((BizumAccountPayload)this.paymentAccountPayload).getMobileNr();
    }

    @Override
    public String getMessageForBuyer() {
        return "payment.bizum.info.buyer";
    }

    @Override
    public String getMessageForSeller() {
        return "payment.bizum.info.seller";
    }

    @Override
    public String getMessageForAccountCreation() {
        return "payment.bizum.info.account";
    }

    @Override
    @NonNull
    public List<TradeCurrency> getSupportedCurrencies() {
        return SUPPORTED_CURRENCIES;
    }

    @Override
    @NonNull
    public List<PaymentAccountFormField.FieldId> getInputFieldIds() {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BizumAccount)) {
            return false;
        }
        BizumAccount other = (BizumAccount)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof BizumAccount;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

