/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.payment;

import haveno.core.api.model.PaymentAccountFormField;
import haveno.core.locale.TradeCurrency;
import haveno.core.locale.TraditionalCurrency;
import haveno.core.payment.PaymentAccount;
import haveno.core.payment.payload.CelPayAccountPayload;
import haveno.core.payment.payload.PaymentAccountPayload;
import haveno.core.payment.payload.PaymentMethod;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class CelPayAccount
extends PaymentAccount {
    public static final List<TradeCurrency> SUPPORTED_CURRENCIES = List.of(new TraditionalCurrency("AUD"), new TraditionalCurrency("CAD"), new TraditionalCurrency("GBP"), new TraditionalCurrency("HKD"), new TraditionalCurrency("USD"));

    public CelPayAccount() {
        super(PaymentMethod.CELPAY);
    }

    @Override
    protected PaymentAccountPayload createPayload() {
        return new CelPayAccountPayload(this.paymentMethod.getId(), this.id);
    }

    public void setEmail(String accountId) {
        ((CelPayAccountPayload)this.paymentAccountPayload).setEmail(accountId);
    }

    public String getEmail() {
        return ((CelPayAccountPayload)this.paymentAccountPayload).getEmail();
    }

    @Override
    public String getMessageForBuyer() {
        return "payment.celpay.info.buyer";
    }

    @Override
    public String getMessageForSeller() {
        return "payment.celpay.info.seller";
    }

    @Override
    public String getMessageForAccountCreation() {
        return "payment.celpay.info.account";
    }

    @Override
    @NotNull
    public List<TradeCurrency> getSupportedCurrencies() {
        return SUPPORTED_CURRENCIES;
    }

    @Override
    @NotNull
    public List<PaymentAccountFormField.FieldId> getInputFieldIds() {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CelPayAccount)) {
            return false;
        }
        CelPayAccount other = (CelPayAccount)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof CelPayAccount;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

