/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.payment;

import haveno.core.locale.Country;
import haveno.core.locale.CountryUtil;
import haveno.core.payment.PaymentAccount;
import haveno.core.payment.payload.CountryBasedPaymentAccountPayload;
import haveno.core.payment.payload.PaymentMethod;
import java.util.List;
import javax.annotation.Nullable;
import org.jetbrains.annotations.NotNull;

public abstract class CountryBasedPaymentAccount
extends PaymentAccount {
    @Nullable
    protected Country country;
    @Nullable
    protected List<Country> acceptedCountries;

    protected CountryBasedPaymentAccount(PaymentMethod paymentMethod) {
        super(paymentMethod);
    }

    @Nullable
    public Country getCountry() {
        if (this.country == null) {
            String countryCode = ((CountryBasedPaymentAccountPayload)this.paymentAccountPayload).getCountryCode();
            CountryUtil.findCountryByCode(countryCode).ifPresent(c -> {
                this.country = c;
            });
        }
        return this.country;
    }

    public void setCountry(@NotNull Country country) {
        this.country = country;
        ((CountryBasedPaymentAccountPayload)this.paymentAccountPayload).setCountryCode(country.code);
    }

    @Nullable
    public List<Country> getAcceptedCountries() {
        if (this.acceptedCountries == null) {
            List<String> acceptedCountryCodes = ((CountryBasedPaymentAccountPayload)this.paymentAccountPayload).getAcceptedCountryCodes();
            this.acceptedCountries = CountryUtil.getCountries(acceptedCountryCodes);
        }
        return this.acceptedCountries;
    }

    public void setAcceptedCountries(List<Country> acceptedCountries) {
        this.acceptedCountries = acceptedCountries;
        ((CountryBasedPaymentAccountPayload)this.paymentAccountPayload).setAcceptedCountryCodes(CountryUtil.getCountryCodes(acceptedCountries));
    }

    @Nullable
    public List<Country> getSupportedCountries() {
        return null;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CountryBasedPaymentAccount)) {
            return false;
        }
        CountryBasedPaymentAccount other = (CountryBasedPaymentAccount)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Country this$country = this.getCountry();
        Country other$country = other.getCountry();
        if (this$country == null ? other$country != null : !((Object)this$country).equals(other$country)) {
            return false;
        }
        List<Country> this$acceptedCountries = this.getAcceptedCountries();
        List<Country> other$acceptedCountries = other.getAcceptedCountries();
        return !(this$acceptedCountries == null ? other$acceptedCountries != null : !((Object)this$acceptedCountries).equals(other$acceptedCountries));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof CountryBasedPaymentAccount;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Country $country = this.getCountry();
        result = result * 59 + ($country == null ? 43 : ((Object)$country).hashCode());
        List<Country> $acceptedCountries = this.getAcceptedCountries();
        result = result * 59 + ($acceptedCountries == null ? 43 : ((Object)$acceptedCountries).hashCode());
        return result;
    }
}

