/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.payment;

import haveno.core.api.model.PaymentAccountFormField;
import haveno.core.locale.TradeCurrency;
import haveno.core.locale.TraditionalCurrency;
import haveno.core.payment.CountryBasedPaymentAccount;
import haveno.core.payment.SameCountryRestrictedBankAccount;
import haveno.core.payment.payload.BankAccountPayload;
import haveno.core.payment.payload.DomesticWireTransferAccountPayload;
import haveno.core.payment.payload.PaymentAccountPayload;
import haveno.core.payment.payload.PaymentMethod;
import java.util.List;
import lombok.NonNull;

public final class DomesticWireTransferAccount
extends CountryBasedPaymentAccount
implements SameCountryRestrictedBankAccount {
    public static final List<TradeCurrency> SUPPORTED_CURRENCIES = List.of(new TraditionalCurrency("USD"));

    public DomesticWireTransferAccount() {
        super(PaymentMethod.DOMESTIC_WIRE_TRANSFER);
    }

    @Override
    protected PaymentAccountPayload createPayload() {
        return new DomesticWireTransferAccountPayload(this.paymentMethod.getId(), this.id);
    }

    @Override
    public String getBankId() {
        return ((BankAccountPayload)this.paymentAccountPayload).getBankId();
    }

    @Override
    public String getCountryCode() {
        return this.getCountry() != null ? this.getCountry().code : "";
    }

    public DomesticWireTransferAccountPayload getPayload() {
        return (DomesticWireTransferAccountPayload)this.paymentAccountPayload;
    }

    @Override
    public String getMessageForBuyer() {
        return "payment.domesticWire.info.buyer";
    }

    @Override
    public String getMessageForSeller() {
        return "payment.domesticWire.info.seller";
    }

    @Override
    public String getMessageForAccountCreation() {
        return "payment.domesticWire.info.account";
    }

    @Override
    @NonNull
    public List<TradeCurrency> getSupportedCurrencies() {
        return SUPPORTED_CURRENCIES;
    }

    @Override
    @NonNull
    public List<PaymentAccountFormField.FieldId> getInputFieldIds() {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DomesticWireTransferAccount)) {
            return false;
        }
        DomesticWireTransferAccount other = (DomesticWireTransferAccount)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof DomesticWireTransferAccount;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

