/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.payment;

import haveno.core.api.model.PaymentAccountFormField;
import haveno.core.locale.CurrencyUtil;
import haveno.core.locale.Res;
import haveno.core.locale.TradeCurrency;
import haveno.core.payment.CountryBasedPaymentAccount;
import haveno.core.payment.payload.F2FAccountPayload;
import haveno.core.payment.payload.PaymentAccountPayload;
import haveno.core.payment.payload.PaymentMethod;
import java.util.List;
import lombok.NonNull;

public final class F2FAccount
extends CountryBasedPaymentAccount {
    public static final List<TradeCurrency> SUPPORTED_CURRENCIES = CurrencyUtil.getAllTraditionalCurrencies();
    private static final List<PaymentAccountFormField.FieldId> INPUT_FIELD_IDS = List.of(PaymentAccountFormField.FieldId.ACCOUNT_NAME, PaymentAccountFormField.FieldId.COUNTRY, PaymentAccountFormField.FieldId.TRADE_CURRENCIES, PaymentAccountFormField.FieldId.CONTACT, PaymentAccountFormField.FieldId.CITY, PaymentAccountFormField.FieldId.EXTRA_INFO, PaymentAccountFormField.FieldId.SALT);

    public F2FAccount() {
        super(PaymentMethod.F2F);
    }

    @Override
    protected PaymentAccountPayload createPayload() {
        return new F2FAccountPayload(this.paymentMethod.getId(), this.id);
    }

    @Override
    @NonNull
    public List<TradeCurrency> getSupportedCurrencies() {
        return SUPPORTED_CURRENCIES;
    }

    @Override
    @NonNull
    public List<PaymentAccountFormField.FieldId> getInputFieldIds() {
        return INPUT_FIELD_IDS;
    }

    public void setContact(String contact) {
        ((F2FAccountPayload)this.paymentAccountPayload).setContact(contact);
    }

    public String getContact() {
        return ((F2FAccountPayload)this.paymentAccountPayload).getContact();
    }

    public void setCity(String city) {
        ((F2FAccountPayload)this.paymentAccountPayload).setCity(city);
    }

    public String getCity() {
        return ((F2FAccountPayload)this.paymentAccountPayload).getCity();
    }

    public void setExtraInfo(String extraInfo) {
        ((F2FAccountPayload)this.paymentAccountPayload).setExtraInfo(extraInfo);
    }

    public String getExtraInfo() {
        return ((F2FAccountPayload)this.paymentAccountPayload).getExtraInfo();
    }

    @Override
    protected PaymentAccountFormField getEmptyFormField(PaymentAccountFormField.FieldId fieldId) {
        PaymentAccountFormField field = super.getEmptyFormField(fieldId);
        if (field.getId() == PaymentAccountFormField.FieldId.TRADE_CURRENCIES) {
            field.setComponent(PaymentAccountFormField.Component.SELECT_ONE);
        }
        if (field.getId() == PaymentAccountFormField.FieldId.CITY) {
            field.setLabel(Res.get("payment.f2f.city"));
        }
        if (field.getId() == PaymentAccountFormField.FieldId.CONTACT) {
            field.setLabel(Res.get("payment.f2f.contact"));
        }
        if (field.getId() == PaymentAccountFormField.FieldId.EXTRA_INFO) {
            field.setLabel(Res.get("payment.shared.extraInfo.prompt.paymentAccount"));
        }
        return field;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof F2FAccount)) {
            return false;
        }
        F2FAccount other = (F2FAccount)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof F2FAccount;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

