/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.payment;

import haveno.core.api.model.PaymentAccountFormField;
import haveno.core.locale.CryptoCurrency;
import haveno.core.locale.CurrencyUtil;
import haveno.core.locale.TradeCurrency;
import haveno.core.payment.AssetAccount;
import haveno.core.payment.payload.InstantCryptoCurrencyPayload;
import haveno.core.payment.payload.PaymentAccountPayload;
import haveno.core.payment.payload.PaymentMethod;
import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;

public final class InstantCryptoCurrencyAccount
extends AssetAccount {
    public static final List<TradeCurrency> SUPPORTED_CURRENCIES = new ArrayList<CryptoCurrency>(CurrencyUtil.getAllSortedCryptoCurrencies());

    public InstantCryptoCurrencyAccount() {
        super(PaymentMethod.BLOCK_CHAINS_INSTANT);
    }

    @Override
    protected PaymentAccountPayload createPayload() {
        return new InstantCryptoCurrencyPayload(this.paymentMethod.getId(), this.id);
    }

    @Override
    @NonNull
    public List<TradeCurrency> getSupportedCurrencies() {
        return SUPPORTED_CURRENCIES;
    }

    @Override
    @NonNull
    public List<PaymentAccountFormField.FieldId> getInputFieldIds() {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InstantCryptoCurrencyAccount)) {
            return false;
        }
        InstantCryptoCurrencyAccount other = (InstantCryptoCurrencyAccount)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof InstantCryptoCurrencyAccount;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

