/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.payment;

import haveno.core.api.model.PaymentAccountFormField;
import haveno.core.locale.TradeCurrency;
import haveno.core.locale.TraditionalCurrency;
import haveno.core.payment.PaymentAccount;
import haveno.core.payment.payload.JapanBankAccountPayload;
import haveno.core.payment.payload.PaymentAccountPayload;
import haveno.core.payment.payload.PaymentMethod;
import java.util.List;
import lombok.NonNull;

public final class JapanBankAccount
extends PaymentAccount {
    public static final List<TradeCurrency> SUPPORTED_CURRENCIES = List.of(new TraditionalCurrency("JPY"));

    public JapanBankAccount() {
        super(PaymentMethod.JAPAN_BANK);
        this.setSingleTradeCurrency(SUPPORTED_CURRENCIES.get(0));
    }

    @Override
    protected PaymentAccountPayload createPayload() {
        return new JapanBankAccountPayload(this.paymentMethod.getId(), this.id);
    }

    @Override
    @NonNull
    public List<TradeCurrency> getSupportedCurrencies() {
        return SUPPORTED_CURRENCIES;
    }

    @Override
    @NonNull
    public List<PaymentAccountFormField.FieldId> getInputFieldIds() {
        throw new RuntimeException("Not implemented");
    }

    public String getBankCode() {
        return ((JapanBankAccountPayload)this.paymentAccountPayload).getBankCode();
    }

    public void setBankCode(String bankCode) {
        if (bankCode == null) {
            bankCode = "";
        }
        ((JapanBankAccountPayload)this.paymentAccountPayload).setBankCode(bankCode);
    }

    public String getBankName() {
        return ((JapanBankAccountPayload)this.paymentAccountPayload).getBankName();
    }

    public void setBankName(String bankName) {
        if (bankName == null) {
            bankName = "";
        }
        ((JapanBankAccountPayload)this.paymentAccountPayload).setBankName(bankName);
    }

    public String getBankBranchCode() {
        return ((JapanBankAccountPayload)this.paymentAccountPayload).getBankBranchCode();
    }

    public void setBankBranchCode(String bankBranchCode) {
        if (bankBranchCode == null) {
            bankBranchCode = "";
        }
        ((JapanBankAccountPayload)this.paymentAccountPayload).setBankBranchCode(bankBranchCode);
    }

    public String getBankBranchName() {
        return ((JapanBankAccountPayload)this.paymentAccountPayload).getBankBranchName();
    }

    public void setBankBranchName(String bankBranchName) {
        if (bankBranchName == null) {
            bankBranchName = "";
        }
        ((JapanBankAccountPayload)this.paymentAccountPayload).setBankBranchName(bankBranchName);
    }

    public String getBankAccountType() {
        return ((JapanBankAccountPayload)this.paymentAccountPayload).getBankAccountType();
    }

    public void setBankAccountType(String bankAccountType) {
        if (bankAccountType == null) {
            bankAccountType = "";
        }
        ((JapanBankAccountPayload)this.paymentAccountPayload).setBankAccountType(bankAccountType);
    }

    public String getBankAccountNumber() {
        return ((JapanBankAccountPayload)this.paymentAccountPayload).getBankAccountNumber();
    }

    public void setBankAccountNumber(String bankAccountNumber) {
        if (bankAccountNumber == null) {
            bankAccountNumber = "";
        }
        ((JapanBankAccountPayload)this.paymentAccountPayload).setBankAccountNumber(bankAccountNumber);
    }

    public String getBankAccountName() {
        return ((JapanBankAccountPayload)this.paymentAccountPayload).getBankAccountName();
    }

    public void setBankAccountName(String bankAccountName) {
        if (bankAccountName == null) {
            bankAccountName = "";
        }
        ((JapanBankAccountPayload)this.paymentAccountPayload).setBankAccountName(bankAccountName);
    }
}

