/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.payment;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import haveno.core.user.Preferences;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class JapanBankData {
    private static String userLanguage;
    private static final Map<String, String> megaBanksEnglish;
    private static final Map<String, String> majorBanksJapanese;
    private static final Map<String, String> minorBanksJapanese;
    private static final String ID_OPEN = "";
    private static final String ID_CLOSE = "";
    private static final String JA_OPEN = "";
    private static final String JA_CLOSE = "";
    private static final String EN_OPEN = "";
    private static final String EN_CLOSE = "";
    public static final String SPACE = " ";

    @Inject
    JapanBankData(Preferences preferences) {
        userLanguage = preferences.getUserLanguage();
    }

    public static List<String> prettyPrintBankList() {
        String bankNameJa;
        String bankId;
        ArrayList<String> prettyList = new ArrayList<String>();
        for (Map.Entry<String, String> bank : megaBanksEnglish.entrySet()) {
            bankId = bank.getKey();
            String bankNameEn = bank.getValue();
            String bankNameJa2 = majorBanksJapanese.get(bankId);
            if (bankNameJa2 == null) {
                bankNameJa2 = minorBanksJapanese.get(bankId);
            }
            prettyList.add(JapanBankData.prettyPrintMajorBank(bankId, bankNameJa2, bankNameEn));
        }
        for (Map.Entry<String, String> bank : majorBanksJapanese.entrySet()) {
            bankId = bank.getKey();
            bankNameJa = bank.getValue();
            if (megaBanksEnglish.get(bankId) != null) continue;
            prettyList.add(JapanBankData.prettyPrintBank(bankId, bankNameJa));
        }
        for (Map.Entry<String, String> bank : minorBanksJapanese.entrySet()) {
            bankId = bank.getKey();
            bankNameJa = bank.getValue();
            prettyList.add(JapanBankData.prettyPrintBank(bankId, bankNameJa));
        }
        return prettyList;
    }

    private static String prettyPrintMajorBank(String bankId, String bankNameJa, String bankNameEn) {
        return bankId + SPACE + bankNameJa + SPACE + bankNameEn;
    }

    private static String prettyPrintBank(String bankId, String bankName) {
        return bankId + SPACE + bankName;
    }

    public static String getString(String id) {
        boolean ja = userLanguage.equals("ja");
        switch (id) {
            case "bank": {
                if (ja) {
                    return "\u9280\u884c\u540d \u30fb\u91d1\u878d\u6a5f\u95a2\u540d";
                }
                return "Bank or Financial Institution";
            }
            case "bank.select": {
                if (ja) {
                    return "\u91d1\u878d\u6a5f\u95a2 \u30fb\u9280\u884c\u691c\u7d22 (\u540d\u79f0\u5165\u529b\u691c\u7d22)";
                }
                return "Search for Bank or Financial Institution";
            }
            case "bank.code": {
                if (ja) {
                    return "\u9280\u884c\u30b3\u30fc\u30c9";
                }
                return "Zengin Bank Code";
            }
            case "bank.name": {
                if (ja) {
                    return "\u91d1\u878d\u6a5f\u95a2\u540d \u30fb\u9280\u884c\u540d";
                }
                return "Financial Institution / Bank Name";
            }
            case "branch": {
                if (ja) {
                    return "\u652f\u5e97\u540d";
                }
                return "Bank Branch";
            }
            case "branch.code": {
                if (ja) {
                    return "\u652f\u5e97\u30b3\u30fc\u30c9";
                }
                return "Zengin Branch Code";
            }
            case "branch.code.validation.error": {
                if (ja) {
                    return "\u5165\u529b\u306f3\u6841\u306e\u652f\u5e97\u30b3\u30fc\u30c9\u3067\u306a\u3051\u308c\u3070\u306a\u308a\u307e\u305b\u3093";
                }
                return "Input must be a 3 digit branch code";
            }
            case "branch.name": {
                if (ja) {
                    return "\u652f\u5e97\u540d";
                }
                return "Bank Branch Name";
            }
            case "account": {
                if (ja) {
                    return "\u9280\u884c\u53e3\u5ea7";
                }
                return "Bank Account";
            }
            case "account.type": {
                if (ja) {
                    return "\u53e3\u5ea7\u79d1\u76ee";
                }
                return "Bank Account Type";
            }
            case "account.type.select": {
                if (ja) {
                    return "\u53e3\u5ea7\u79d1\u76ee";
                }
                return "Select Account Type";
            }
            case "account.type.futsu": {
                if (ja) {
                    return "\u666e\u901a";
                }
                return "FUTSUU (ordinary) account";
            }
            case "account.type.touza": {
                if (ja) {
                    return "\u5f53\u5ea7";
                }
                return "TOUZA (checking) account";
            }
            case "account.type.chochiku": {
                if (ja) {
                    return "\u8caf\u91d1";
                }
                return "CHOCHIKU (special) account";
            }
            case "account.type.futsu.ja": {
                return "\u666e\u901a";
            }
            case "account.type.touza.ja": {
                return "\u5f53\u5ea7";
            }
            case "account.type.chochiku.ja": {
                return "\u8caf\u91d1";
            }
            case "account.number": {
                if (ja) {
                    return "\u53e3\u5ea7\u756a\u53f7";
                }
                return "Bank Account Number";
            }
            case "account.number.validation.error": {
                if (ja) {
                    return "\u5165\u529b\u306f4\u301c8\u6841\u306e\u53e3\u5ea7\u756a\u53f7\u3067\u306a\u3051\u308c\u3070\u306a\u308a\u307e\u305b\u3093";
                }
                return "Input must be 4 ~ 8 digit account number";
            }
            case "account.name": {
                if (ja) {
                    return "\u53e3\u5ea7\u540d\u7fa9";
                }
                return "Bank Account Name";
            }
            case "japanese.validation.error": {
                if (ja) {
                    return "\u5165\u529b\u306f\u6f22\u5b57\u3001\u3072\u3089\u304c\u306a\u3001\u307e\u305f\u306f\u30ab\u30bf\u30ab\u30ca\u3067\u306a\u3051\u308c\u3070\u306a\u308a\u307e\u305b\u3093";
                }
                return "Input must be Kanji, Hiragana, or Katakana";
            }
            case "japanese.validation.regex": {
                return "[\u4e00-\u9faf\u3005\u3007\u3041-\u309e\u30a1-\u30fb\uff67-\uff9d\uff9e\uff9f\u30fd\u30fe\u309b\u309c\u30fc\u3000 ]+";
            }
        }
        return "null";
    }

    static {
        megaBanksEnglish = ImmutableMap.builder().put("9900", "Japan Post Bank Yucho").put("0001", "Mizuho Bank").put("0005", "Mitsubishi UFJ Bank (MUFG)").put("0009", "Sumitomo Mitsui Banking Corporation (SMBC)").put("0010", "Resona Bank").put("0033", "Japan Net Bank").put("0034", "Seven Bank (7-11)").put("0035", "Sony Bank").put("0036", "Rakuten Bank").put("0038", "SBI Sumishin Net Bank").put("0039", "Jibun Bank").put("0040", "Aeon Bank").put("0042", "Lawson Bank").put("0150", "Suruga Bank").put("0288", "Mitsubishi UFJ Trust Bank").put("0289", "Mizuho Trust Bank").put("0294", "Sumitomo Trust Bank").put("0300", "SMBC Trust Bank (PRESTIA)").put("0304", "Nomura Trust Bank").put("0307", "Orix Trust Bank").put("0310", "GMO Aozora Net Bank").put("0321", "Japan Securities Trust Bank").put("0397", "Shinsei Bank").put("0398", "Aozora Bank").put("0402", "JP Morgan Chase Bank").put("0442", "BNY Mellon").put("0458", "DBS Bank").put("0472", "SBJ Shinhan Bank Japan").build();
        majorBanksJapanese = ImmutableMap.builder().put("9900", "\u3086\u3046\u3061\u3087\u9280\u884c").put("0001", "\u307f\u305a\u307b\u9280\u884c").put("0005", "\u4e09\u83f1\uff35\uff26\uff2a\u9280\u884c").put("0009", "\u4e09\u4e95\u4f4f\u53cb\u9280\u884c").put("0010", "\u308a\u305d\u306a\u9280\u884c").put("0017", "\u57fc\u7389\u308a\u305d\u306a\u9280\u884c").put("0033", "\u30b8\u30e3\u30d1\u30f3\u30cd\u30c3\u30c8\u9280\u884c").put("0034", "\u30bb\u30d6\u30f3\u9280\u884c").put("0035", "\u30bd\u30cb\u30fc\u9280\u884c").put("0036", "\u697d\u5929\u9280\u884c").put("0038", "\u4f4f\u4fe1\uff33\uff22\uff29\u30cd\u30c3\u30c8\u9280\u884c").put("0039", "\u3058\u3076\u3093\u9280\u884c").put("0040", "\u30a4\u30aa\u30f3\u9280\u884c").put("0041", "\u5927\u548c\u30cd\u30af\u30b9\u30c8\u9280\u884c").put("0042", "\u30ed\u30fc\u30bd\u30f3\u9280\u884c").put("0051", "\u5168\u9280\u5354").put("0052", "\u6a2a\u6d5c\u9280\u884c\u5354\u4f1a").put("0053", "\u91e7\u8def\u9280\u884c\u5354\u4f1a").put("0054", "\u672d\u5e4c\u9280\u884c\u5354\u4f1a").put("0056", "\u51fd\u9928\u9280\u884c\u5354\u4f1a").put("0057", "\u9752\u68ee\u9280\u884c\u5354\u4f1a").put("0058", "\u79cb\u7530\u9280\u884c\u5354\u4f1a").put("0059", "\u5bae\u57ce\u9280\u884c\u5354\u4f1a").put("0060", "\u798f\u5cf6\u9280\u884c\u5354\u4f1a").put("0061", "\u7fa4\u99ac\u9280\u884c\u5354\u4f1a").put("0062", "\u65b0\u6f5f\u9280\u884c\u5354\u4f1a").put("0063", "\u77f3\u5ddd\u9280\u884c\u5354\u4f1a").put("0064", "\u5c71\u68a8\u9280\u884c\u5354\u4f1a").put("0065", "\u9577\u91ce\u9280\u884c\u5354\u4f1a").put("0066", "\u9759\u5ca1\u9280\u884c\u5354\u4f1a").put("0067", "\u540d\u53e4\u5c4b\u9280\u884c\u5354\u4f1a").put("0068", "\u4eac\u90fd\u9280\u884c\u5354\u4f1a").put("0069", "\u5927\u962a\u9280\u884c\u5354\u4f1a").put("0070", "\u795e\u6238\u9280\u884c\u5354\u4f1a").put("0071", "\u5ca1\u5c71\u9280\u884c\u5354\u4f1a").put("0072", "\u5e83\u5cf6\u9280\u884c\u5354\u4f1a").put("0073", "\u5cf6\u6839\u9280\u884c\u5354\u4f1a").put("0074", "\u5c71\u53e3\u9280\u884c\u5354\u4f1a").put("0075", "\u9999\u5ddd\u9280\u884c\u5354\u4f1a").put("0076", "\u611b\u5a9b\u9280\u884c\u5354\u4f1a").put("0077", "\u9ad8\u77e5\u9280\u884c\u5354\u4f1a").put("0078", "\u5317\u4e5d\u5dde\u9280\u884c\u5354\u4f1a").put("0079", "\u798f\u5ca1\u9280\u884c\u5354\u4f1a").put("0080", "\u5927\u5206\u9280\u884c\u5354\u4f1a").put("0081", "\u9577\u5d0e\u9280\u884c\u5354\u4f1a").put("0082", "\u718a\u672c\u9280\u884c\u5354\u4f1a").put("0083", "\u9e7f\u5150\u5cf6\u9280\u884c\u5354\u4f1a").put("0084", "\u6c96\u7e04\u9280\u884c\u5354\u4f1a").put("0090", "\u5168\u9280\u30cd\u30c3\u30c8").put("0095", "\uff23\uff2c\uff33\uff22\uff21\uff2e\uff2b").put("0116", "\u5317\u6d77\u9053\u9280\u884c").put("0117", "\u9752\u68ee\u9280\u884c").put("0118", "\u307f\u3061\u306e\u304f\u9280\u884c").put("0119", "\u79cb\u7530\u9280\u884c").put("0120", "\u5317\u90fd\u9280\u884c").put("0121", "\u8358\u5185\u9280\u884c").put("0122", "\u5c71\u5f62\u9280\u884c").put("0123", "\u5ca9\u624b\u9280\u884c").put("0124", "\u6771\u5317\u9280\u884c").put("0125", "\u4e03\u5341\u4e03\u9280\u884c").put("0126", "\u6771\u90a6\u9280\u884c").put("0128", "\u7fa4\u99ac\u9280\u884c").put("0129", "\u8db3\u5229\u9280\u884c").put("0130", "\u5e38\u967d\u9280\u884c").put("0131", "\u7b51\u6ce2\u9280\u884c").put("0133", "\u6b66\u8535\u91ce\u9280\u884c").put("0134", "\u5343\u8449\u9280\u884c").put("0135", "\u5343\u8449\u8208\u696d\u9280\u884c").put("0137", "\u304d\u3089\u307c\u3057\u9280\u884c").put("0138", "\u6a2a\u6d5c\u9280\u884c").put("0140", "\u7b2c\u56db\u9280\u884c").put("0141", "\u5317\u8d8a\u9280\u884c").put("0142", "\u5c71\u68a8\u4e2d\u592e\u9280\u884c").put("0143", "\u516b\u5341\u4e8c\u9280\u884c").put("0144", "\u5317\u9678\u9280\u884c").put("0145", "\u5bcc\u5c71\u9280\u884c").put("0146", "\u5317\u570b\u9280\u884c").put("0147", "\u798f\u4e95\u9280\u884c").put("0149", "\u9759\u5ca1\u9280\u884c").put("0150", "\u30b9\u30eb\u30ac\u9280\u884c").put("0151", "\u6e05\u6c34\u9280\u884c").put("0152", "\u5927\u57a3\u5171\u7acb\u9280\u884c").put("0153", "\u5341\u516d\u9280\u884c").put("0154", "\u4e09\u91cd\u9280\u884c").put("0155", "\u767e\u4e94\u9280\u884c").put("0157", "\u6ecb\u8cc0\u9280\u884c").put("0158", "\u4eac\u90fd\u9280\u884c").put("0159", "\u95a2\u897f\u307f\u3089\u3044\u9280\u884c").put("0161", "\u6c60\u7530\u6cc9\u5dde\u9280\u884c").put("0162", "\u5357\u90fd\u9280\u884c").put("0163", "\u7d00\u967d\u9280\u884c").put("0164", "\u4f46\u99ac\u9280\u884c").put("0166", "\u9ce5\u53d6\u9280\u884c").put("0167", "\u5c71\u9670\u5408\u540c\u9280\u884c").put("0168", "\u4e2d\u56fd\u9280\u884c").put("0169", "\u5e83\u5cf6\u9280\u884c").put("0170", "\u5c71\u53e3\u9280\u884c").put("0172", "\u963f\u6ce2\u9280\u884c").put("0173", "\u767e\u5341\u56db\u9280\u884c").put("0174", "\u4f0a\u4e88\u9280\u884c").put("0175", "\u56db\u56fd\u9280\u884c").put("0177", "\u798f\u5ca1\u9280\u884c").put("0178", "\u7b51\u90a6\u9280\u884c").put("0179", "\u4f50\u8cc0\u9280\u884c").put("0180", "\u5341\u516b\u9280\u884c").put("0181", "\u89aa\u548c\u9280\u884c").put("0182", "\u80a5\u5f8c\u9280\u884c").put("0183", "\u5927\u5206\u9280\u884c").put("0184", "\u5bae\u5d0e\u9280\u884c").put("0185", "\u9e7f\u5150\u5cf6\u9280\u884c").put("0187", "\u7409\u7403\u9280\u884c").put("0188", "\u6c96\u7e04\u9280\u884c").put("0190", "\u897f\u65e5\u672c\u30b7\u30c6\u30a3\u9280\u884c").put("0191", "\u5317\u4e5d\u5dde\u9280\u884c").put("0288", "\u4e09\u83f1\uff35\uff26\uff2a\u4fe1\u8a17\u9280\u884c").put("0289", "\u307f\u305a\u307b\u4fe1\u8a17\u9280\u884c").put("0294", "\u4e09\u4e95\u4f4f\u53cb\u4fe1\u8a17\u9280\u884c").put("0295", "\uff22\uff2e\uff39\uff2d\u4fe1\u8a17").put("0297", "\u65e5\u672c\u30de\u30b9\u30bf\u30fc\u30c8\u30e9\u30b9\u30c8\u4fe1\u8a17\u9280\u884c").put("0299", "\u30b9\u30c6\u30fc\u30c8\u4fe1\u8a17").put("0300", "\uff33\uff2d\uff22\uff23\u4fe1\u8a17\u9280\u884c \u30d7\u30ec\u30b9\u30c6\u30a3\u30a2").put("0304", "\u91ce\u6751\u4fe1\u8a17\u9280\u884c").put("0307", "\u30aa\u30ea\u30c3\u30af\u30b9\u9280\u884c").put("0310", "\uff27\uff2d\uff2f\u3042\u304a\u305e\u3089\u30cd\u30c3\u30c8\u9280\u884c").put("0311", "\u8fb2\u4e2d\u4fe1\u8a17").put("0320", "\u65b0\u751f\u4fe1\u8a17").put("0321", "\u65e5\u8a3c\u91d1\u4fe1\u8a17").put("0324", "\u65e5\u672c\u30c8\u30e9\u30b9\u30c6\u30a3\u30b5\u30fc\u30d3\u30b9\u4fe1\u8a17\u9280\u884c").put("0325", "\u8cc7\u7523\u7ba1\u7406\u30b5\u30fc\u30d3\u30b9\u4fe1\u8a17\u9280\u884c").put("0397", "\u65b0\u751f\u9280\u884c").put("0398", "\u3042\u304a\u305e\u3089\u9280\u884c").put("0401", "\u30b7\u30c6\u30a3\u30d0\u30f3\u30af\u3001\u30a8\u30cc\u30fb\u30a8\u30a4 \u9280\u884c").put("0402", "\uff2a\uff30\u30e2\u30eb\u30ac\u30f3\u30fb\u30c1\u30a7\u30fc\u30b9\u9280\u884c").put("0403", "\u30a2\u30e1\u30ea\u30ab\u9280\u884c").put("0411", "\u9999\u6e2f\u4e0a\u6d77\u9280\u884c").put("0413", "\u30b9\u30bf\u30f3\u30c1\u30e4\u30fc\u30c8").put("0414", "\u30d0\u30fc\u30af\u30ec\u30a4\u30ba").put("0421", "\u30a2\u30b0\u30ea\u30b3\u30eb").put("0423", "\u30cf\u30ca").put("0424", "\u5370\u5ea6").put("0425", "\u5146\u8c50\u570b\u969b\u5546\u9280").put("0426", "\u30d0\u30f3\u30b3\u30c4\u30af").put("0429", "\u30d0\u30f3\u30af\u30cd\u30ac\u30e9").put("0430", "\u30c9\u30a4\u30c4\u9280\u884c").put("0432", "\u30d6\u30e9\u30b8\u30eb").put("0438", "\u30e6\u30fc\u30aa\u30d0\u30b7\u30fc\u30ba").put("0439", "\u30e6\u30fc\u30d3\u30fc\u30a8\u30b9").put("0442", "\uff22\uff2e\uff39\u30e1\u30ed\u30f3").put("0443", "\u30d3\u30fc\u30fb\u30a8\u30cc\u30fb\u30d4\u30fc\u30fb\u30d1\u30ea\u30d0\u9280\u884c").put("0444", "\u30c1\u30e4\u30a4\u30cb\u30fc\u30ba").put("0445", "\u30bd\u30b7\u30a8\u30c6").put("0456", "\u30e6\u30d0\u30d5").put("0458", "\uff24\uff22\uff33").put("0459", "\u30d1\u30ad\u30b9\u30bf\u30f3").put("0460", "\u30af\u30ec\u30c7\u30a4\u30b9\u30a4\u30b9").put("0461", "\u30b3\u30e1\u30eb\u30c4\u9280\u884c").put("0463", "\u30a6\u30cb\u30af\u30ec\u30c7\u30a4\u30c8").put("0468", "\u30a4\u30f3\u30c9\u30b9\u30c6\u30a4\u30c8").put("0471", "\u30ab\u30ca\u30c0\u30ed\u30a4\u30e4\u30eb").put("0472", "\uff33\uff22\uff2a\u9280\u884c").put("0477", "\u30a6\u30ea\u30a4").put("0482", "\u30a2\u30a4\u30a8\u30cc\u30b8\u30fc").put("0484", "\u30ca\u30c4\u30c8\u30aa\u30fc\u30b9").put("0485", "\u30a2\u30f3\u30ba\u30d0\u30f3\u30af").put("0487", "\u30b3\u30e2\u30f3\u30a6\u30a8\u30eb\u30b9").put("0489", "\u30d0\u30f3\u30af\u30c1\u30e4\u30a4\u30ca").put("0495", "\u30b9\u30c6\u30b9\u30c8\u30ea\u30fc\u30c8").put("0498", "\u4e2d\u5c0f\u4f01\u696d").put("0501", "\u5317\u6d0b\u9280\u884c").put("0508", "\u304d\u3089\u3084\u304b\u9280\u884c").put("0509", "\u5317\u65e5\u672c\u9280\u884c").put("0512", "\u4ed9\u53f0\u9280\u884c").put("0513", "\u798f\u5cf6\u9280\u884c").put("0514", "\u5927\u6771\u9280\u884c").put("0516", "\u6771\u548c\u9280\u884c").put("0517", "\u6803\u6728\u9280\u884c").put("0522", "\u4eac\u8449\u9280\u884c").put("0525", "\u6771\u65e5\u672c\u9280\u884c").put("0526", "\u6771\u4eac\u30b9\u30bf\u30fc\u9280\u884c").put("0530", "\u795e\u5948\u5ddd\u9280\u884c").put("0532", "\u5927\u5149\u9280\u884c").put("0533", "\u9577\u91ce\u9280\u884c").put("0534", "\u5bcc\u5c71\u7b2c\u4e00\u9280\u884c").put("0537", "\u798f\u90a6\u9280\u884c").put("0538", "\u9759\u5ca1\u4e2d\u592e\u9280\u884c").put("0542", "\u611b\u77e5\u9280\u884c").put("0543", "\u540d\u53e4\u5c4b\u9280\u884c").put("0544", "\u4e2d\u4eac\u9280\u884c").put("0546", "\u7b2c\u4e09\u9280\u884c").put("0555", "\u5927\u6b63\u9280\u884c").put("0562", "\u307f\u306a\u3068\u9280\u884c").put("0565", "\u5cf6\u6839\u9280\u884c").put("0566", "\u30c8\u30de\u30c8\u9280\u884c").put("0569", "\u3082\u307f\u3057\u3099\u9280\u884c").put("0570", "\u897f\u4eac\u9280\u884c").put("0572", "\u5fb3\u5cf6\u9280\u884c").put("0573", "\u9999\u5ddd\u9280\u884c").put("0576", "\u611b\u5a9b\u9280\u884c").put("0578", "\u9ad8\u77e5\u9280\u884c").put("0582", "\u798f\u5ca1\u4e2d\u592e\u9280\u884c").put("0583", "\u4f50\u8cc0\u5171\u6804\u9280\u884c").put("0585", "\u9577\u5d0e\u9280\u884c").put("0587", "\u718a\u672c\u9280\u884c").put("0590", "\u8c4a\u548c\u9280\u884c").put("0591", "\u5bae\u5d0e\u592a\u967d\u9280\u884c").put("0594", "\u5357\u65e5\u672c\u9280\u884c").put("0596", "\u6c96\u7e04\u6d77\u90a6\u9280\u884c").put("0603", "\u97d3\u56fd\u7523\u696d").put("0607", "\u5f70\u5316\u5546\u696d").put("0608", "\u30a6\u30a8\u30eb\u30ba\u30d5\u30a2\u30b4").put("0611", "\u7b2c\u4e00\u5546\u696d").put("0612", "\u53f0\u6e7e").put("0615", "\u4ea4\u901a").put("0616", "\u30e1\u30c8\u30ed\u30dd\u30ea\u30bf\u30f3").put("0617", "\u30d5\u30a4\u30ea\u30d4\u30f3").put("0619", "\u4e2d\u56fd\u5de5\u5546").put("0621", "\u4e2d\u570b\u4fe1\u8a17\u5546\u696d").put("0623", "\u30a4\u30f3\u30c6\u30fc\u30b6").put("0624", "\u570b\u6c11").put("0625", "\u4e2d\u56fd\u5efa\u8a2d").put("0626", "\u30a4\u30bf\u30a6\u30a6\u30cb").put("0627", "\uff22\uff22\uff36\uff21").put("0630", "\u4e2d\u56fd\u8fb2\u696d").put("0631", "\u53f0\u65b0").put("0632", "\u7389\u5c71").put("0633", "\u53f0\u6e7e\u4f01\u9280").put("0808", "\u30c9\u30a4\u30c4\u8a3c\u5238").put("0813", "\u30bd\u30b7\u30a8\u30c6\u8a3c\u5238").put("0821", "\u30d3\u30fc\u30d4\u30fc\u8a3c\u5238").put("0822", "\u30d0\u30fc\u30af\u30ec\u30a4\u8a3c\u5238").put("0831", "\u30a2\u30b0\u30ea\u30b3\u30eb\u8a3c\u5238").put("0832", "\u30b8\u30a8\u30a4\u30d4\u30fc\u8a3c\u5238").put("0842", "\u30b4\u30eb\u30c9\u30de\u30f3\u8a3c\u5238").put("0845", "\u30ca\u30c4\u30c8\u30a6\u30a8\u8a3c\u5238").put("0900", "\u65e5\u672c\u76f8\u4e92\u8a3c\u5238").put("0905", "\u6771\u4eac\u91d1\u878d\u53d6\u5f15\u6240").put("0909", "\u65e5\u672c\u30af\u30ea\u30a2\u6a5f\u69cb").put("0910", "\u307b\u3075\u308a\u30af\u30ea\u30a2").put("0964", "\u3057\u3093\u304d\u3093\u8a3c\u5238").put("0966", "\uff28\uff33\uff22\uff23\u8a3c\u5238").put("0968", "\u30bb\u30f3\u30c8\u6771\u77ed\u8a3c\u5238").put("0971", "\uff35\uff22\uff33\u8a3c\u5238").put("0972", "\u30e1\u30ea\u30eb\u65e5\u672c\u8a3c\u5238").build();
        minorBanksJapanese = ImmutableMap.builder().put("1000", "\u4fe1\u91d1\u4e2d\u592e\u91d1\u5eab").put("1001", "\u5317\u6d77\u9053\u4fe1\u91d1").put("1003", "\u5ba4\u862d\u4fe1\u91d1").put("1004", "\u7a7a\u77e5\u4fe1\u91d1").put("1006", "\u82eb\u5c0f\u7267\u4fe1\u91d1").put("1008", "\u5317\u9580\u4fe1\u91d1").put("1009", "\u4f0a\u9054\u4fe1\u91d1").put("1010", "\u5317\u7a7a\u77e5\u4fe1\u91d1").put("1011", "\u65e5\u9ad8\u4fe1\u91d1").put("1013", "\u6e21\u5cf6\u4fe1\u91d1").put("1014", "\u9053\u5357\u3046\u307f\u8857\u4fe1\u91d1").put("1020", "\u65ed\u5ddd\u4fe1\u91d1").put("1021", "\u7a1a\u5185\u4fe1\u91d1").put("1022", "\u7559\u840c\u4fe1\u91d1").put("1024", "\u5317\u661f\u4fe1\u91d1").put("1026", "\u5e2f\u5e83\u4fe1\u91d1").put("1027", "\u91e7\u8def\u4fe1\u91d1").put("1028", "\u5927\u5730\u307f\u3089\u3044\u4fe1\u91d1").put("1030", "\u5317\u898b\u4fe1\u91d1").put("1031", "\u7db2\u8d70\u4fe1\u91d1").put("1033", "\u9060\u8efd\u4fe1\u91d1").put("1104", "\u6771\u5965\u4fe1\u91d1").put("1105", "\u9752\u3044\u68ee\u4fe1\u91d1").put("1120", "\u79cb\u7530\u4fe1\u91d1").put("1123", "\u7fbd\u5f8c\u4fe1\u91d1").put("1140", "\u5c71\u5f62\u4fe1\u91d1").put("1141", "\u7c73\u6ca2\u4fe1\u91d1").put("1142", "\u9db4\u5ca1\u4fe1\u91d1").put("1143", "\u65b0\u5e84\u4fe1\u91d1").put("1150", "\u76db\u5ca1\u4fe1\u91d1").put("1152", "\u5bae\u53e4\u4fe1\u91d1").put("1153", "\u4e00\u95a2\u4fe1\u91d1").put("1154", "\u5317\u4e0a\u4fe1\u91d1").put("1155", "\u82b1\u5dfb\u4fe1\u91d1").put("1156", "\u6c34\u6ca2\u4fe1\u91d1").put("1170", "\u675c\u306e\u90fd\u4fe1\u91d1").put("1171", "\u5bae\u57ce\u7b2c\u4e00\u4fe1\u91d1").put("1172", "\u77f3\u5dfb\u4fe1\u91d1").put("1174", "\u4ed9\u5357\u4fe1\u91d1").put("1181", "\u4f1a\u6d25\u4fe1\u91d1").put("1182", "\u90e1\u5c71\u4fe1\u91d1").put("1184", "\u767d\u6cb3\u4fe1\u91d1").put("1185", "\u9808\u8cc0\u5ddd\u4fe1\u91d1").put("1186", "\u3072\u307e\u308f\u308a\u4fe1\u91d1").put("1188", "\u3042\u3076\u304f\u307e\u4fe1\u91d1").put("1189", "\u4e8c\u672c\u677e\u4fe1\u91d1").put("1190", "\u798f\u5cf6\u4fe1\u91d1").put("1203", "\u9ad8\u5d0e\u4fe1\u91d1").put("1204", "\u6850\u751f\u4fe1\u91d1").put("1206", "\u30a2\u30a4\u30aa\u30fc\u4fe1\u91d1").put("1208", "\u5229\u6839\u90e1\u4fe1\u91d1").put("1209", "\u9928\u6797\u4fe1\u91d1").put("1210", "\u5317\u7fa4\u99ac\u4fe1\u91d1").put("1211", "\u3057\u306e\u306e\u3081\u4fe1\u91d1").put("1221", "\u8db3\u5229\u5c0f\u5c71\u4fe1\u91d1").put("1222", "\u6803\u6728\u4fe1\u91d1").put("1223", "\u9e7f\u6cbc\u76f8\u4e92\u4fe1\u91d1").put("1224", "\u4f50\u91ce\u4fe1\u91d1").put("1225", "\u5927\u7530\u539f\u4fe1\u91d1").put("1227", "\u70cf\u5c71\u4fe1\u91d1").put("1240", "\u6c34\u6238\u4fe1\u91d1").put("1242", "\u7d50\u57ce\u4fe1\u91d1").put("1250", "\u57fc\u7389\u770c\u4fe1\u91d1").put("1251", "\u5ddd\u53e3\u4fe1\u91d1").put("1252", "\u9752\u6728\u4fe1\u91d1").put("1253", "\u98ef\u80fd\u4fe1\u91d1").put("1260", "\u5343\u8449\u4fe1\u91d1").put("1261", "\u929a\u5b50\u4fe1\u91d1").put("1262", "\u6771\u4eac\u30d9\u30a4\u4fe1\u91d1").put("1264", "\u9928\u5c71\u4fe1\u91d1").put("1267", "\u4f50\u539f\u4fe1\u91d1").put("1280", "\u6a2a\u6d5c\u4fe1\u91d1").put("1281", "\u304b\u306a\u304c\u308f\u4fe1\u91d1").put("1282", "\u6e58\u5357\u4fe1\u91d1").put("1283", "\u5ddd\u5d0e\u4fe1\u91d1").put("1286", "\u5e73\u585a\u4fe1\u91d1").put("1288", "\u3055\u304c\u307f\u4fe1\u91d1").put("1289", "\u4e2d\u6804\u4fe1\u91d1").put("1290", "\u4e2d\u5357\u4fe1\u91d1").put("1303", "\u671d\u65e5\u4fe1\u91d1").put("1305", "\u8208\u7523\u4fe1\u91d1").put("1310", "\u3055\u308f\u3084\u304b\u4fe1\u91d1").put("1311", "\u6771\u4eac\u30b7\u30c6\u30a4\u4fe1\u91d1").put("1319", "\u829d\u4fe1\u91d1").put("1320", "\u6771\u4eac\u6771\u4fe1\u91d1").put("1321", "\u6771\u6804\u4fe1\u91d1").put("1323", "\u4e80\u6709\u4fe1\u91d1").put("1326", "\u5c0f\u677e\u5ddd\u4fe1\u91d1").put("1327", "\u8db3\u7acb\u6210\u548c\u4fe1\u91d1").put("1333", "\u6771\u4eac\u4e09\u5354\u4fe1\u91d1").put("1336", "\u897f\u4eac\u4fe1\u91d1").put("1341", "\u897f\u6b66\u4fe1\u91d1").put("1344", "\u57ce\u5357\u4fe1\u91d1").put("1345", "\u6771\u4eac\uff09\u662d\u548c\u4fe1\u91d1").put("1346", "\u76ee\u9ed2\u4fe1\u91d1").put("1348", "\u4e16\u7530\u8c37\u4fe1\u91d1").put("1349", "\u6771\u4eac\u4fe1\u91d1").put("1351", "\u57ce\u5317\u4fe1\u91d1").put("1352", "\u6edd\u91ce\u5ddd\u4fe1\u91d1").put("1356", "\u5de3\u9d28\u4fe1\u91d1").put("1358", "\u9752\u6885\u4fe1\u91d1").put("1360", "\u591a\u6469\u4fe1\u91d1").put("1370", "\u65b0\u6f5f\u4fe1\u91d1").put("1371", "\u9577\u5ca1\u4fe1\u91d1").put("1373", "\u4e09\u6761\u4fe1\u91d1").put("1374", "\u65b0\u767a\u7530\u4fe1\u91d1").put("1375", "\u67cf\u5d0e\u4fe1\u91d1").put("1376", "\u4e0a\u8d8a\u4fe1\u91d1").put("1377", "\u65b0\u4e95\u4fe1\u91d1").put("1379", "\u6751\u4e0a\u4fe1\u91d1").put("1380", "\u52a0\u8302\u4fe1\u91d1").put("1385", "\u7532\u5e9c\u4fe1\u91d1").put("1386", "\u5c71\u68a8\u4fe1\u91d1").put("1390", "\u9577\u91ce\u4fe1\u91d1").put("1391", "\u677e\u672c\u4fe1\u91d1").put("1392", "\u4e0a\u7530\u4fe1\u91d1").put("1393", "\u8acf\u8a2a\u4fe1\u91d1").put("1394", "\u98ef\u7530\u4fe1\u91d1").put("1396", "\u30a2\u30eb\u30d7\u30b9\u4fe1\u91d1").put("1401", "\u5bcc\u5c71\u4fe1\u91d1").put("1402", "\u9ad8\u5ca1\u4fe1\u91d1").put("1405", "\u306b\u3044\u304b\u308f\u4fe1\u91d1").put("1406", "\u6c37\u898b\u4f0f\u6728\u4fe1\u91d1").put("1412", "\u783a\u6ce2\u4fe1\u91d1").put("1413", "\u77f3\u52d5\u4fe1\u91d1").put("1440", "\u91d1\u6ca2\u4fe1\u91d1").put("1442", "\u306e\u3068\u5171\u6804\u4fe1\u91d1").put("1444", "\u5317\u9678\u4fe1\u91d1").put("1445", "\u9db4\u6765\u4fe1\u91d1").put("1448", "\u8208\u80fd\u4fe1\u91d1").put("1470", "\u798f\u4e95\u4fe1\u91d1").put("1471", "\u6566\u8cc0\u4fe1\u91d1").put("1473", "\u5c0f\u6d5c\u4fe1\u91d1").put("1475", "\u8d8a\u524d\u4fe1\u91d1").put("1501", "\u3057\u305a\u713c\u6d25\u4fe1\u91d1").put("1502", "\u9759\u6e05\u4fe1\u91d1").put("1503", "\u6d5c\u677e\u78d0\u7530\u4fe1\u91d1").put("1505", "\u6cbc\u6d25\u4fe1\u91d1").put("1506", "\u4e09\u5cf6\u4fe1\u91d1").put("1507", "\u5bcc\u58eb\u5bae\u4fe1\u91d1").put("1513", "\u5cf6\u7530\u639b\u5ddd\u4fe1\u91d1").put("1515", "\u9759\u5ca1\uff09\u5bcc\u58eb\u4fe1\u91d1").put("1517", "\u9060\u5dde\u4fe1\u91d1").put("1530", "\u5c90\u961c\u4fe1\u91d1").put("1531", "\u5927\u57a3\u897f\u6fc3\u4fe1\u91d1").put("1532", "\u9ad8\u5c71\u4fe1\u91d1").put("1533", "\u6771\u6fc3\u4fe1\u91d1").put("1534", "\u95a2\u4fe1\u91d1").put("1538", "\u516b\u5e61\u4fe1\u91d1").put("1550", "\u611b\u77e5\u4fe1\u91d1").put("1551", "\u8c4a\u6a4b\u4fe1\u91d1").put("1552", "\u5ca1\u5d0e\u4fe1\u91d1").put("1553", "\u3044\u3061\u3044\u4fe1\u91d1").put("1554", "\u702c\u6238\u4fe1\u91d1").put("1555", "\u534a\u7530\u4fe1\u91d1").put("1556", "\u77e5\u591a\u4fe1\u91d1").put("1557", "\u8c4a\u5ddd\u4fe1\u91d1").put("1559", "\u8c4a\u7530\u4fe1\u91d1").put("1560", "\u78a7\u6d77\u4fe1\u91d1").put("1561", "\u897f\u5c3e\u4fe1\u91d1").put("1562", "\u84b2\u90e1\u4fe1\u91d1").put("1563", "\u5c3e\u897f\u4fe1\u91d1").put("1565", "\u4e2d\u65e5\u4fe1\u91d1").put("1566", "\u6771\u6625\u4fe1\u91d1").put("1580", "\u6d25\u4fe1\u91d1").put("1581", "\u5317\u4f0a\u52e2\u4e0a\u91ce\u4fe1\u91d1").put("1583", "\u6851\u540d\u4e09\u91cd\u4fe1\u91d1").put("1585", "\u7d00\u5317\u4fe1\u91d1").put("1602", "\u6ecb\u8cc0\u4e2d\u592e\u4fe1\u91d1").put("1603", "\u9577\u6d5c\u4fe1\u91d1").put("1604", "\u6e56\u6771\u4fe1\u91d1").put("1610", "\u4eac\u90fd\u4fe1\u91d1").put("1611", "\u4eac\u90fd\u4e2d\u592e\u4fe1\u91d1").put("1620", "\u4eac\u90fd\u5317\u90fd\u4fe1\u91d1").put("1630", "\u5927\u962a\u4fe1\u91d1").put("1633", "\u5927\u962a\u539a\u751f\u4fe1\u91d1").put("1635", "\u5927\u962a\u30b7\u30c6\u30a4\u4fe1\u91d1").put("1636", "\u5927\u962a\u5546\u5de5\u4fe1\u91d1").put("1643", "\u6c38\u548c\u4fe1\u91d1").put("1645", "\u5317\u304a\u304a\u3055\u304b\u4fe1\u91d1").put("1656", "\u679a\u65b9\u4fe1\u91d1").put("1666", "\u5948\u826f\u4fe1\u91d1").put("1667", "\u5927\u548c\u4fe1\u91d1").put("1668", "\u5948\u826f\u4e2d\u592e\u4fe1\u91d1").put("1671", "\u65b0\u5bae\u4fe1\u91d1").put("1674", "\u304d\u306e\u304f\u306b\u4fe1\u91d1").put("1680", "\u795e\u6238\u4fe1\u91d1").put("1685", "\u59eb\u8def\u4fe1\u91d1").put("1686", "\u64ad\u5dde\u4fe1\u91d1").put("1687", "\u5175\u5eab\u4fe1\u91d1").put("1688", "\u5c3c\u5d0e\u4fe1\u91d1").put("1689", "\u65e5\u65b0\u4fe1\u91d1").put("1691", "\u6de1\u8def\u4fe1\u91d1").put("1692", "\u4f46\u99ac\u4fe1\u91d1").put("1694", "\u897f\u5175\u5eab\u4fe1\u91d1").put("1695", "\u4e2d\u5175\u5eab\u4fe1\u91d1").put("1696", "\u4f46\u967d\u4fe1\u91d1").put("1701", "\u9ce5\u53d6\u4fe1\u91d1").put("1702", "\u7c73\u5b50\u4fe1\u91d1").put("1703", "\u5009\u5409\u4fe1\u91d1").put("1710", "\u3057\u307e\u306d\u4fe1\u91d1").put("1711", "\u65e5\u672c\u6d77\u4fe1\u91d1").put("1712", "\u5cf6\u6839\u4e2d\u592e\u4fe1\u91d1").put("1732", "\u304a\u304b\u3084\u307e\u4fe1\u91d1").put("1734", "\u6c34\u5cf6\u4fe1\u91d1").put("1735", "\u6d25\u5c71\u4fe1\u91d1").put("1738", "\u7389\u5cf6\u4fe1\u91d1").put("1740", "\u5099\u5317\u4fe1\u91d1").put("1741", "\u5409\u5099\u4fe1\u91d1").put("1742", "\u65e5\u751f\u4fe1\u91d1").put("1743", "\u5099\u524d\u4fe1\u91d1").put("1750", "\u5e83\u5cf6\u4fe1\u91d1").put("1752", "\u5449\u4fe1\u91d1").put("1756", "\u3057\u307e\u306a\u307f\u4fe1\u91d1").put("1758", "\u5e83\u5cf6\u307f\u3069\u308a\u4fe1\u91d1").put("1780", "\u8429\u5c71\u53e3\u4fe1\u91d1").put("1781", "\u897f\u4e2d\u56fd\u4fe1\u91d1").put("1789", "\u6771\u5c71\u53e3\u4fe1\u91d1").put("1801", "\u5fb3\u5cf6\u4fe1\u91d1").put("1803", "\u963f\u5357\u4fe1\u91d1").put("1830", "\u9ad8\u677e\u4fe1\u91d1").put("1833", "\u89b3\u97f3\u5bfa\u4fe1\u91d1").put("1860", "\u611b\u5a9b\u4fe1\u91d1").put("1862", "\u5b87\u548c\u5cf6\u4fe1\u91d1").put("1864", "\u6771\u4e88\u4fe1\u91d1").put("1866", "\u5ddd\u4e4b\u6c5f\u4fe1\u91d1").put("1880", "\u5e61\u591a\u4fe1\u91d1").put("1881", "\u9ad8\u77e5\u4fe1\u91d1").put("1901", "\u798f\u5ca1\u4fe1\u91d1").put("1903", "\u798f\u5ca1\u3072\u3073\u304d\u4fe1\u91d1").put("1908", "\u5927\u725f\u7530\u67f3\u5ddd\u4fe1\u91d1").put("1909", "\u7b51\u5f8c\u4fe1\u91d1").put("1910", "\u98ef\u585a\u4fe1\u91d1").put("1917", "\u5927\u5ddd\u4fe1\u91d1").put("1920", "\u9060\u8cc0\u4fe1\u91d1").put("1930", "\u5510\u6d25\u4fe1\u91d1").put("1931", "\u4f50\u8cc0\u4fe1\u91d1").put("1933", "\u4e5d\u5dde\u3072\u305c\u3093\u4fe1\u91d1").put("1942", "\u305f\u3061\u3070\u306a\u4fe1\u91d1").put("1951", "\u718a\u672c\u4fe1\u91d1").put("1952", "\u718a\u672c\u7b2c\u4e00\u4fe1\u91d1").put("1954", "\u718a\u672c\u4e2d\u592e\u4fe1\u91d1").put("1960", "\u5927\u5206\u4fe1\u91d1").put("1962", "\u5927\u5206\u307f\u3089\u3044\u4fe1\u91d1").put("1980", "\u5bae\u5d0e\u90fd\u57ce\u4fe1\u91d1").put("1985", "\u9ad8\u934b\u4fe1\u91d1").put("1990", "\u9e7f\u5150\u5cf6\u4fe1\u91d1").put("1991", "\u9e7f\u5150\u5cf6\u76f8\u4e92\u4fe1\u91d1").put("1993", "\u5944\u7f8e\u5927\u5cf6\u4fe1\u91d1").put("1996", "\u30b3\u30b6\u4fe1\u91d1").put("2004", "\u5546\u5de5\u7d44\u5408\u4e2d\u592e\u91d1\u5eab").put("2010", "\u5168\u56fd\u4fe1\u7528\u5354\u540c\u7d44\u5408\u9023\u5408\u4f1a").put("2213", "\u6574\u7406\u56de\u53ce\u6a5f\u69cb").put("2950", "\u52b4\u50cd\u91d1\u5eab\u9023\u5408\u4f1a").put("3000", "\u8fb2\u6797\u4e2d\u592e\u91d1\u5eab").put("3001", "\u5317\u6d77\u9053\u4fe1\u7528\u8fb2\u696d\u5354\u540c\u7d44\u5408\u9023\u5408\u4f1a").put("3003", "\u5ca9\u624b\u770c\u4fe1\u7528\u8fb2\u696d\u5354\u540c\u7d44\u5408\u9023\u5408\u4f1a").put("3008", "\u8328\u57ce\u770c\u4fe1\u7528\u8fb2\u696d\u5354\u540c\u7d44\u5408\u9023\u5408\u4f1a").put("3011", "\u57fc\u7389\u770c\u4fe1\u7528\u8fb2\u696d\u5354\u540c\u7d44\u5408\u9023\u5408\u4f1a").put("3013", "\u6771\u4eac\u90fd\u4fe1\u7528\u8fb2\u696d\u5354\u540c\u7d44\u5408\u9023\u5408\u4f1a").put("3014", "\u795e\u5948\u5ddd\u770c\u4fe1\u7528\u8fb2\u696d\u5354\u540c\u7d44\u5408\u9023\u5408\u4f1a").put("3015", "\u5c71\u68a8\u770c\u4fe1\u7528\u8fb2\u696d\u5354\u540c\u7d44\u5408\u9023\u5408\u4f1a").put("3016", "\u9577\u91ce\u770c\u4fe1\u7528\u8fb2\u696d\u5354\u540c\u7d44\u5408\u9023\u5408\u4f1a").put("3017", "\u65b0\u6f5f\u770c\u4fe1\u7528\u8fb2\u696d\u5354\u540c\u7d44\u5408\u9023\u5408\u4f1a").put("3019", "\u77f3\u5ddd\u770c\u4fe1\u7528\u8fb2\u696d\u5354\u540c\u7d44\u5408\u9023\u5408\u4f1a").put("3020", "\u5c90\u961c\u770c\u4fe1\u7528\u8fb2\u696d\u5354\u540c\u7d44\u5408\u9023\u5408\u4f1a").put("3021", "\u9759\u5ca1\u770c\u4fe1\u7528\u8fb2\u696d\u5354\u540c\u7d44\u5408\u9023\u5408\u4f1a").put("3022", "\u611b\u77e5\u770c\u4fe1\u7528\u8fb2\u696d\u5354\u540c\u7d44\u5408\u9023\u5408\u4f1a").put("3023", "\u4e09\u91cd\u770c\u4fe1\u7528\u8fb2\u696d\u5354\u540c\u7d44\u5408\u9023\u5408\u4f1a").put("3024", "\u798f\u4e95\u770c\u4fe1\u7528\u8fb2\u696d\u5354\u540c\u7d44\u5408\u9023\u5408\u4f1a").put("3025", "\u6ecb\u8cc0\u770c\u4fe1\u7528\u8fb2\u696d\u5354\u540c\u7d44\u5408\u9023\u5408\u4f1a").put("3026", "\u4eac\u90fd\u5e9c\u4fe1\u7528\u8fb2\u696d\u5354\u540c\u7d44\u5408\u9023\u5408\u4f1a").put("3027", "\u5927\u962a\u5e9c\u4fe1\u7528\u8fb2\u696d\u5354\u540c\u7d44\u5408\u9023\u5408\u4f1a").put("3028", "\u5175\u5eab\u770c\u4fe1\u7528\u8fb2\u696d\u5354\u540c\u7d44\u5408\u9023\u5408\u4f1a").put("3030", "\u548c\u6b4c\u5c71\u770c\u4fe1\u7528\u8fb2\u696d\u5354\u540c\u7d44\u5408\u9023\u5408\u4f1a").put("3031", "\u9ce5\u53d6\u770c\u4fe1\u7528\u8fb2\u696d\u5354\u540c\u7d44\u5408\u9023\u5408\u4f1a").put("3034", "\u5e83\u5cf6\u770c\u4fe1\u7528\u8fb2\u696d\u5354\u540c\u7d44\u5408\u9023\u5408\u4f1a").put("3035", "\u5c71\u53e3\u770c\u4fe1\u7528\u8fb2\u696d\u5354\u540c\u7d44\u5408\u9023\u5408\u4f1a").put("3036", "\u5fb3\u5cf6\u770c\u4fe1\u7528\u8fb2\u696d\u5354\u540c\u7d44\u5408\u9023\u5408\u4f1a").put("3037", "\u9999\u5ddd\u770c\u4fe1\u7528\u8fb2\u696d\u5354\u540c\u7d44\u5408\u9023\u5408\u4f1a").put("3038", "\u611b\u5a9b\u770c\u4fe1\u7528\u8fb2\u696d\u5354\u540c\u7d44\u5408\u9023\u5408\u4f1a").put("3039", "\u9ad8\u77e5\u770c\u4fe1\u7528\u8fb2\u696d\u5354\u540c\u7d44\u5408\u9023\u5408\u4f1a").put("3040", "\u798f\u5ca1\u770c\u4fe1\u7528\u8fb2\u696d\u5354\u540c\u7d44\u5408\u9023\u5408\u4f1a").put("3041", "\u4f50\u8cc0\u770c\u4fe1\u7528\u8fb2\u696d\u5354\u540c\u7d44\u5408\u9023\u5408\u4f1a").put("3044", "\u5927\u5206\u770c\u4fe1\u7528\u8fb2\u696d\u5354\u540c\u7d44\u5408\u9023\u5408\u4f1a").put("3045", "\u5bae\u5d0e\u770c\u4fe1\u7528\u8fb2\u696d\u5354\u540c\u7d44\u5408\u9023\u5408\u4f1a").put("3046", "\u9e7f\u5150\u5cf6\u770c\u4fe1\u7528\u8fb2\u696d\u5354\u540c\u7d44\u5408\u9023\u5408\u4f1a").put("9450", "\u5317\u6d77\u9053\u4fe1\u7528\u6f01\u696d\u5354\u540c\u7d44\u5408\u9023\u5408\u4f1a").put("9451", "\u9752\u68ee\u770c\u4fe1\u7528\u6f01\u696d\u5354\u540c\u7d44\u5408\u9023\u5408\u4f1a").put("9452", "\u5ca9\u624b\u770c\u4fe1\u7528\u6f01\u696d\u5354\u540c\u7d44\u5408\u9023\u5408\u4f1a").put("9453", "\u5bae\u57ce\u770c\u6f01\u696d\u5354\u540c\u7d44\u5408").put("9456", "\u798f\u5cf6\u770c\u4fe1\u7528\u6f01\u696d\u5354\u540c\u7d44\u5408\u9023\u5408\u4f1a").put("9457", "\u8328\u57ce\u770c\u4fe1\u7528\u6f01\u696d\u5354\u540c\u7d44\u5408\u9023\u5408\u4f1a").put("9461", "\u5343\u8449\u770c\u4fe1\u7528\u6f01\u696d\u5354\u540c\u7d44\u5408\u9023\u5408\u4f1a").put("9462", "\u6771\u4eac\u90fd\u4fe1\u7528\u6f01\u696d\u5354\u540c\u7d44\u5408\u9023\u5408\u4f1a").put("9466", "\u65b0\u6f5f\u770c\u4fe1\u7528\u6f01\u696d\u5354\u540c\u7d44\u5408\u9023\u5408\u4f1a").put("9467", "\u5bcc\u5c71\u770c\u4fe1\u7528\u6f01\u696d\u5354\u540c\u7d44\u5408\u9023\u5408\u4f1a").put("9468", "\u77f3\u5ddd\u770c\u4fe1\u7528\u6f01\u696d\u5354\u540c\u7d44\u5408\u9023\u5408\u4f1a").put("9470", "\u9759\u5ca1\u770c\u4fe1\u7528\u6f01\u696d\u5354\u540c\u7d44\u5408\u9023\u5408\u4f1a").put("9471", "\u611b\u77e5\u770c\u4fe1\u7528\u6f01\u696d\u5354\u540c\u7d44\u5408\u9023\u5408\u4f1a").put("9472", "\u4e09\u91cd\u770c\u4fe1\u7528\u6f01\u696d\u5354\u540c\u7d44\u5408\u9023\u5408\u4f1a").put("9473", "\u798f\u4e95\u770c\u4fe1\u7528\u6f01\u696d\u5354\u540c\u7d44\u5408\u9023\u5408\u4f1a").put("9475", "\u4eac\u90fd\u5e9c\u4fe1\u7528\u6f01\u696d\u5354\u540c\u7d44\u5408\u9023\u5408\u4f1a").put("9477", "\u306a\u304e\u3055\u4fe1\u7528\u6f01\u696d\u5354\u540c\u7d44\u5408\u9023\u5408\u4f1a").put("9480", "\u9ce5\u53d6\u770c\u4fe1\u7528\u6f01\u696d\u5354\u540c\u7d44\u5408\u9023\u5408\u4f1a").put("9481", "\uff2a\uff26\u3057\u307e\u306d\u6f01\u696d\u5354\u540c\u7d44\u5408").put("9483", "\u5e83\u5cf6\u770c\u4fe1\u7528\u6f01\u696d\u5354\u540c\u7d44\u5408\u9023\u5408\u4f1a").put("9484", "\u5c71\u53e3\u770c\u6f01\u696d\u5354\u540c\u7d44\u5408").put("9485", "\u5fb3\u5cf6\u770c\u4fe1\u7528\u6f01\u696d\u5354\u540c\u7d44\u5408\u9023\u5408\u4f1a").put("9486", "\u9999\u5ddd\u770c\u4fe1\u7528\u6f01\u696d\u5354\u540c\u7d44\u5408\u9023\u5408\u4f1a").put("9487", "\u611b\u5a9b\u770c\u4fe1\u7528\u6f01\u696d\u5354\u540c\u7d44\u5408\u9023\u5408\u4f1a").put("9488", "\u9ad8\u77e5\u770c\u4fe1\u7528\u6f01\u696d\u5354\u540c\u7d44\u5408\u9023\u5408\u4f1a").put("9489", "\u798f\u5ca1\u770c\u4fe1\u7528\u6f01\u696d\u5354\u540c\u7d44\u5408\u9023\u5408\u4f1a").put("9490", "\u4f50\u8cc0\u770c\u4fe1\u7528\u6f01\u696d\u5354\u540c\u7d44\u5408\u9023\u5408\u4f1a").put("9491", "\u9577\u5d0e\u770c\u4fe1\u7528\u6f01\u696d\u5354\u540c\u7d44\u5408\u9023\u5408\u4f1a").put("9493", "\u5927\u5206\u770c\u6f01\u696d\u5354\u540c\u7d44\u5408").put("9494", "\u5bae\u5d0e\u770c\u4fe1\u7528\u6f01\u696d\u5354\u540c\u7d44\u5408\u9023\u5408\u4f1a").put("9495", "\u9e7f\u5150\u5cf6\u770c\u4fe1\u7528\u6f01\u696d\u5354\u540c\u7d44\u5408\u9023\u5408\u4f1a").put("9496", "\u6c96\u7e04\u770c\u4fe1\u7528\u6f01\u696d\u5354\u540c\u7d44\u5408\u9023\u5408\u4f1a").put("9500", "\u6771\u4eac\u77ed\u8cc7").put("9501", "\u30bb\u30f3\u30c8\u30e9\u30eb\u77ed\u8cc7").put("9507", "\u4e0a\u7530\u516b\u6728\u77ed\u8cc7").put("9510", "\u65e5\u672c\u8a3c\u5238\u91d1\u878d").put("9520", "\u91ce\u6751\u8a3c\u5238").put("9521", "\u65e5\u8208\u8a3c\u5238").put("9523", "\u5927\u548c\u8a3c\u5238").put("9524", "\u307f\u305a\u307b\u8a3c\u5238").put("9528", "\u5ca1\u4e09\u8a3c\u5238").put("9530", "\u5ca9\u4e95\u30b3\u30b9\u30e2\u8a3c\u5238").put("9532", "\u4e09\u83f1\uff35\uff26\uff2a\u8a3c\u5238").put("9534", "\u4e38\u4e09\u8a3c\u5238").put("9535", "\u6771\u6d0b\u8a3c\u5238").put("9537", "\u6c34\u6238\u8a3c\u5238").put("9539", "\u6771\u6d77\u6771\u4eac\u8a3c\u5238").put("9542", "\u3080\u3055\u3057\u8a3c\u5238").put("9545", "\u3044\u3061\u3088\u3057\u8a3c\u5238").put("9573", "\u6975\u6771\u8a3c\u5238").put("9574", "\u7acb\u82b1\u8a3c\u5238").put("9579", "\u5149\u4e16\u8a3c\u5238").put("9584", "\u3061\u3070\u304e\u3093\u8a3c\u5238").put("9589", "\u30b7\u30c6\u30a4\u8a3c\u5238").put("9594", "\uff23\uff33\u8a3c\u5238").put("9595", "\u30b9\u30bf\u30f3\u30ec\u30fc\u8a3c\u5238").put("9930", "\u65e5\u672c\u653f\u7b56\u6295\u8cc7").put("9932", "\u653f\u7b56\u91d1\u878d\u516c\u5eab").put("9933", "\u56fd\u969b\u5354\u529b").put("9945", "\u9810\u91d1\u4fdd\u967a\u6a5f\u69cb").build();
    }
}

