/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.payment;

import haveno.core.api.model.PaymentAccountFormField;
import haveno.core.locale.Country;
import haveno.core.locale.CountryUtil;
import haveno.core.locale.TradeCurrency;
import haveno.core.locale.TraditionalCurrency;
import haveno.core.payment.PaymentAccount;
import haveno.core.payment.payload.MoneyGramAccountPayload;
import haveno.core.payment.payload.PaymentAccountPayload;
import haveno.core.payment.payload.PaymentMethod;
import java.util.List;
import javax.annotation.Nullable;
import org.jetbrains.annotations.NotNull;

public final class MoneyGramAccount
extends PaymentAccount {
    @Nullable
    private Country country;
    private static final List<PaymentAccountFormField.FieldId> INPUT_FIELD_IDS = List.of(PaymentAccountFormField.FieldId.ACCOUNT_NAME, PaymentAccountFormField.FieldId.COUNTRY, PaymentAccountFormField.FieldId.STATE, PaymentAccountFormField.FieldId.HOLDER_NAME, PaymentAccountFormField.FieldId.EMAIL, PaymentAccountFormField.FieldId.TRADE_CURRENCIES, PaymentAccountFormField.FieldId.SALT);
    public static final List<TradeCurrency> SUPPORTED_CURRENCIES = List.of(new TraditionalCurrency("AED"), new TraditionalCurrency("ARS"), new TraditionalCurrency("AUD"), new TraditionalCurrency("BND"), new TraditionalCurrency("CAD"), new TraditionalCurrency("CHF"), new TraditionalCurrency("CZK"), new TraditionalCurrency("DKK"), new TraditionalCurrency("EUR"), new TraditionalCurrency("FJD"), new TraditionalCurrency("GBP"), new TraditionalCurrency("HKD"), new TraditionalCurrency("HUF"), new TraditionalCurrency("IDR"), new TraditionalCurrency("ILS"), new TraditionalCurrency("INR"), new TraditionalCurrency("JPY"), new TraditionalCurrency("KRW"), new TraditionalCurrency("KWD"), new TraditionalCurrency("LKR"), new TraditionalCurrency("MAD"), new TraditionalCurrency("MGA"), new TraditionalCurrency("MXN"), new TraditionalCurrency("MYR"), new TraditionalCurrency("NOK"), new TraditionalCurrency("NZD"), new TraditionalCurrency("OMR"), new TraditionalCurrency("PEN"), new TraditionalCurrency("PGK"), new TraditionalCurrency("PHP"), new TraditionalCurrency("PKR"), new TraditionalCurrency("PLN"), new TraditionalCurrency("SAR"), new TraditionalCurrency("SBD"), new TraditionalCurrency("SCR"), new TraditionalCurrency("SEK"), new TraditionalCurrency("SGD"), new TraditionalCurrency("THB"), new TraditionalCurrency("TOP"), new TraditionalCurrency("TRY"), new TraditionalCurrency("TWD"), new TraditionalCurrency("USD"), new TraditionalCurrency("VND"), new TraditionalCurrency("VUV"), new TraditionalCurrency("WST"), new TraditionalCurrency("XOF"), new TraditionalCurrency("XPF"), new TraditionalCurrency("ZAR"));

    public MoneyGramAccount() {
        super(PaymentMethod.MONEY_GRAM);
    }

    @Override
    protected PaymentAccountPayload createPayload() {
        return new MoneyGramAccountPayload(this.paymentMethod.getId(), this.id);
    }

    @Override
    @NotNull
    public List<TradeCurrency> getSupportedCurrencies() {
        return SUPPORTED_CURRENCIES;
    }

    @Override
    @NotNull
    public List<PaymentAccountFormField.FieldId> getInputFieldIds() {
        return INPUT_FIELD_IDS;
    }

    @Nullable
    public Country getCountry() {
        if (this.country == null) {
            String countryCode = ((MoneyGramAccountPayload)this.paymentAccountPayload).getCountryCode();
            CountryUtil.findCountryByCode(countryCode).ifPresent(c -> {
                this.country = c;
            });
        }
        return this.country;
    }

    public void setCountry(@NotNull Country country) {
        this.country = country;
        ((MoneyGramAccountPayload)this.paymentAccountPayload).setCountryCode(country.code);
    }

    public String getEmail() {
        return ((MoneyGramAccountPayload)this.paymentAccountPayload).getEmail();
    }

    public void setEmail(String email) {
        ((MoneyGramAccountPayload)this.paymentAccountPayload).setEmail(email);
    }

    public String getFullName() {
        return ((MoneyGramAccountPayload)this.paymentAccountPayload).getHolderName();
    }

    public void setFullName(String email) {
        ((MoneyGramAccountPayload)this.paymentAccountPayload).setHolderName(email);
    }

    public String getState() {
        return ((MoneyGramAccountPayload)this.paymentAccountPayload).getState();
    }

    public void setState(String state) {
        ((MoneyGramAccountPayload)this.paymentAccountPayload).setState(state);
    }

    @Override
    protected PaymentAccountFormField getEmptyFormField(PaymentAccountFormField.FieldId fieldId) {
        PaymentAccountFormField field = super.getEmptyFormField(fieldId);
        if (field.getId() == PaymentAccountFormField.FieldId.HOLDER_NAME) {
            field.setLabel("Full name (first, middle, last)");
        }
        return field;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MoneyGramAccount)) {
            return false;
        }
        MoneyGramAccount other = (MoneyGramAccount)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Country this$country = this.getCountry();
        Country other$country = other.getCountry();
        return !(this$country == null ? other$country != null : !((Object)this$country).equals(other$country));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof MoneyGramAccount;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Country $country = this.getCountry();
        result = result * 59 + ($country == null ? 43 : ((Object)$country).hashCode());
        return result;
    }
}

