/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.payment;

import haveno.core.api.model.PaymentAccountFormField;
import haveno.core.locale.TradeCurrency;
import haveno.core.locale.TraditionalCurrency;
import haveno.core.payment.PaymentAccount;
import haveno.core.payment.payload.PaxumAccountPayload;
import haveno.core.payment.payload.PaymentAccountPayload;
import haveno.core.payment.payload.PaymentMethod;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class PaxumAccount
extends PaymentAccount {
    private static final List<PaymentAccountFormField.FieldId> INPUT_FIELD_IDS = List.of(PaymentAccountFormField.FieldId.ACCOUNT_NAME, PaymentAccountFormField.FieldId.EMAIL, PaymentAccountFormField.FieldId.TRADE_CURRENCIES, PaymentAccountFormField.FieldId.SALT);
    public static final List<TradeCurrency> SUPPORTED_CURRENCIES = List.of(new TraditionalCurrency("AUD"), new TraditionalCurrency("CAD"), new TraditionalCurrency("CHF"), new TraditionalCurrency("CZK"), new TraditionalCurrency("DKK"), new TraditionalCurrency("EUR"), new TraditionalCurrency("GBP"), new TraditionalCurrency("HUF"), new TraditionalCurrency("IDR"), new TraditionalCurrency("INR"), new TraditionalCurrency("NOK"), new TraditionalCurrency("NZD"), new TraditionalCurrency("PLN"), new TraditionalCurrency("RON"), new TraditionalCurrency("SEK"), new TraditionalCurrency("THB"), new TraditionalCurrency("USD"), new TraditionalCurrency("ZAR"));

    public PaxumAccount() {
        super(PaymentMethod.PAXUM);
    }

    @Override
    protected PaymentAccountPayload createPayload() {
        return new PaxumAccountPayload(this.paymentMethod.getId(), this.id);
    }

    @Override
    @NotNull
    public List<TradeCurrency> getSupportedCurrencies() {
        return SUPPORTED_CURRENCIES;
    }

    @Override
    @NotNull
    public List<PaymentAccountFormField.FieldId> getInputFieldIds() {
        return INPUT_FIELD_IDS;
    }

    public void setEmail(String accountId) {
        ((PaxumAccountPayload)this.paymentAccountPayload).setEmail(accountId);
    }

    public String getEmail() {
        return ((PaxumAccountPayload)this.paymentAccountPayload).getEmail();
    }

    @Override
    protected PaymentAccountFormField getEmptyFormField(PaymentAccountFormField.FieldId fieldId) {
        PaymentAccountFormField field = super.getEmptyFormField(fieldId);
        if (field.getId() == PaymentAccountFormField.FieldId.TRADE_CURRENCIES) {
            field.setValue("");
        }
        return field;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PaxumAccount)) {
            return false;
        }
        PaxumAccount other = (PaxumAccount)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof PaxumAccount;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

