/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.payment;

import haveno.core.api.model.PaymentAccountFormField;
import haveno.core.locale.CurrencyUtil;
import haveno.core.locale.Res;
import haveno.core.locale.TradeCurrency;
import haveno.core.payment.PaymentAccount;
import haveno.core.payment.payload.PayByMailAccountPayload;
import haveno.core.payment.payload.PaymentAccountPayload;
import haveno.core.payment.payload.PaymentMethod;
import java.util.List;
import lombok.NonNull;

public final class PayByMailAccount
extends PaymentAccount {
    public static final List<TradeCurrency> SUPPORTED_CURRENCIES = CurrencyUtil.getAllTraditionalCurrencies();
    private static final List<PaymentAccountFormField.FieldId> INPUT_FIELD_IDS = List.of(PaymentAccountFormField.FieldId.TRADE_CURRENCIES, PaymentAccountFormField.FieldId.CONTACT, PaymentAccountFormField.FieldId.POSTAL_ADDRESS, PaymentAccountFormField.FieldId.EXTRA_INFO, PaymentAccountFormField.FieldId.ACCOUNT_NAME, PaymentAccountFormField.FieldId.SALT);

    public PayByMailAccount() {
        super(PaymentMethod.PAY_BY_MAIL);
    }

    @Override
    protected PaymentAccountPayload createPayload() {
        return new PayByMailAccountPayload(this.paymentMethod.getId(), this.id);
    }

    @Override
    @NonNull
    public List<TradeCurrency> getSupportedCurrencies() {
        return SUPPORTED_CURRENCIES;
    }

    @Override
    @NonNull
    public List<PaymentAccountFormField.FieldId> getInputFieldIds() {
        return INPUT_FIELD_IDS;
    }

    public void setPostalAddress(String postalAddress) {
        ((PayByMailAccountPayload)this.paymentAccountPayload).setPostalAddress(postalAddress);
    }

    public String getPostalAddress() {
        return ((PayByMailAccountPayload)this.paymentAccountPayload).getPostalAddress();
    }

    public void setContact(String contact) {
        ((PayByMailAccountPayload)this.paymentAccountPayload).setContact(contact);
    }

    public String getContact() {
        return ((PayByMailAccountPayload)this.paymentAccountPayload).getContact();
    }

    public void setExtraInfo(String extraInfo) {
        ((PayByMailAccountPayload)this.paymentAccountPayload).setExtraInfo(extraInfo);
    }

    public String getExtraInfo() {
        return ((PayByMailAccountPayload)this.paymentAccountPayload).getExtraInfo();
    }

    @Override
    protected PaymentAccountFormField getEmptyFormField(PaymentAccountFormField.FieldId fieldId) {
        PaymentAccountFormField field = super.getEmptyFormField(fieldId);
        if (field.getId() == PaymentAccountFormField.FieldId.TRADE_CURRENCIES) {
            field.setComponent(PaymentAccountFormField.Component.SELECT_ONE);
        }
        if (field.getId() == PaymentAccountFormField.FieldId.CONTACT) {
            field.setLabel(Res.get("payment.payByMail.contact.prompt"));
        }
        if (field.getId() == PaymentAccountFormField.FieldId.POSTAL_ADDRESS) {
            field.setLabel(Res.get("payment.postal.address"));
        }
        if (field.getId() == PaymentAccountFormField.FieldId.EXTRA_INFO) {
            field.setLabel(Res.get("payment.shared.optionalExtra"));
        }
        return field;
    }
}

