/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.payment;

import haveno.core.payment.AchTransferAccount;
import haveno.core.payment.AdvancedCashAccount;
import haveno.core.payment.AliPayAccount;
import haveno.core.payment.AmazonGiftCardAccount;
import haveno.core.payment.AustraliaPayidAccount;
import haveno.core.payment.BizumAccount;
import haveno.core.payment.CapitualAccount;
import haveno.core.payment.CashAppAccount;
import haveno.core.payment.CashAtAtmAccount;
import haveno.core.payment.CashDepositAccount;
import haveno.core.payment.CelPayAccount;
import haveno.core.payment.ChaseQuickPayAccount;
import haveno.core.payment.CryptoCurrencyAccount;
import haveno.core.payment.DomesticWireTransferAccount;
import haveno.core.payment.F2FAccount;
import haveno.core.payment.FasterPaymentsAccount;
import haveno.core.payment.HalCashAccount;
import haveno.core.payment.ImpsAccount;
import haveno.core.payment.InstantCryptoCurrencyAccount;
import haveno.core.payment.InteracETransferAccount;
import haveno.core.payment.JapanBankAccount;
import haveno.core.payment.MoneseAccount;
import haveno.core.payment.MoneyBeamAccount;
import haveno.core.payment.MoneyGramAccount;
import haveno.core.payment.NationalBankAccount;
import haveno.core.payment.NeftAccount;
import haveno.core.payment.NequiAccount;
import haveno.core.payment.OKPayAccount;
import haveno.core.payment.PaxumAccount;
import haveno.core.payment.PayByMailAccount;
import haveno.core.payment.PayPalAccount;
import haveno.core.payment.PaymentAccount;
import haveno.core.payment.PaysafeAccount;
import haveno.core.payment.PayseraAccount;
import haveno.core.payment.PaytmAccount;
import haveno.core.payment.PerfectMoneyAccount;
import haveno.core.payment.PixAccount;
import haveno.core.payment.PopmoneyAccount;
import haveno.core.payment.PromptPayAccount;
import haveno.core.payment.RevolutAccount;
import haveno.core.payment.RtgsAccount;
import haveno.core.payment.SameBankAccount;
import haveno.core.payment.SatispayAccount;
import haveno.core.payment.SepaAccount;
import haveno.core.payment.SepaInstantAccount;
import haveno.core.payment.SpecificBanksAccount;
import haveno.core.payment.StrikeAccount;
import haveno.core.payment.SwiftAccount;
import haveno.core.payment.SwishAccount;
import haveno.core.payment.TikkieAccount;
import haveno.core.payment.TransferwiseAccount;
import haveno.core.payment.TransferwiseUsdAccount;
import haveno.core.payment.USPostalMoneyOrderAccount;
import haveno.core.payment.UpholdAccount;
import haveno.core.payment.UpiAccount;
import haveno.core.payment.VenmoAccount;
import haveno.core.payment.VerseAccount;
import haveno.core.payment.WeChatPayAccount;
import haveno.core.payment.WesternUnionAccount;
import haveno.core.payment.ZelleAccount;
import haveno.core.payment.payload.PaymentMethod;

public class PaymentAccountFactory {
    public static PaymentAccount getPaymentAccount(PaymentMethod paymentMethod) {
        switch (paymentMethod.getId()) {
            case "UPHOLD": {
                return new UpholdAccount();
            }
            case "MONEY_BEAM": {
                return new MoneyBeamAccount();
            }
            case "POPMONEY": {
                return new PopmoneyAccount();
            }
            case "REVOLUT": {
                return new RevolutAccount();
            }
            case "PERFECT_MONEY": {
                return new PerfectMoneyAccount();
            }
            case "SEPA": {
                return new SepaAccount();
            }
            case "SEPA_INSTANT": {
                return new SepaInstantAccount();
            }
            case "FASTER_PAYMENTS": {
                return new FasterPaymentsAccount();
            }
            case "NATIONAL_BANK": {
                return new NationalBankAccount();
            }
            case "SAME_BANK": {
                return new SameBankAccount();
            }
            case "SPECIFIC_BANKS": {
                return new SpecificBanksAccount();
            }
            case "JAPAN_BANK": {
                return new JapanBankAccount();
            }
            case "AUSTRALIA_PAYID": {
                return new AustraliaPayidAccount();
            }
            case "ALI_PAY": {
                return new AliPayAccount();
            }
            case "WECHAT_PAY": {
                return new WeChatPayAccount();
            }
            case "SWISH": {
                return new SwishAccount();
            }
            case "ZELLE": {
                return new ZelleAccount();
            }
            case "CHASE_QUICK_PAY": {
                return new ChaseQuickPayAccount();
            }
            case "INTERAC_E_TRANSFER": {
                return new InteracETransferAccount();
            }
            case "US_POSTAL_MONEY_ORDER": {
                return new USPostalMoneyOrderAccount();
            }
            case "CASH_DEPOSIT": {
                return new CashDepositAccount();
            }
            case "BLOCK_CHAINS": {
                return new CryptoCurrencyAccount();
            }
            case "MONEY_GRAM": {
                return new MoneyGramAccount();
            }
            case "WESTERN_UNION": {
                return new WesternUnionAccount();
            }
            case "HAL_CASH": {
                return new HalCashAccount();
            }
            case "F2F": {
                return new F2FAccount();
            }
            case "PAY_BY_MAIL": {
                return new PayByMailAccount();
            }
            case "CASH_AT_ATM": {
                return new CashAtAtmAccount();
            }
            case "PROMPT_PAY": {
                return new PromptPayAccount();
            }
            case "ADVANCED_CASH": {
                return new AdvancedCashAccount();
            }
            case "TRANSFERWISE": {
                return new TransferwiseAccount();
            }
            case "TRANSFERWISE_USD": {
                return new TransferwiseUsdAccount();
            }
            case "PAYPAL": {
                return new PayPalAccount();
            }
            case "PAYSERA": {
                return new PayseraAccount();
            }
            case "PAXUM": {
                return new PaxumAccount();
            }
            case "NEFT": {
                return new NeftAccount();
            }
            case "RTGS": {
                return new RtgsAccount();
            }
            case "IMPS": {
                return new ImpsAccount();
            }
            case "UPI": {
                return new UpiAccount();
            }
            case "PAYTM": {
                return new PaytmAccount();
            }
            case "NEQUI": {
                return new NequiAccount();
            }
            case "BIZUM": {
                return new BizumAccount();
            }
            case "PIX": {
                return new PixAccount();
            }
            case "AMAZON_GIFT_CARD": {
                return new AmazonGiftCardAccount();
            }
            case "BLOCK_CHAINS_INSTANT": {
                return new InstantCryptoCurrencyAccount();
            }
            case "CAPITUAL": {
                return new CapitualAccount();
            }
            case "CELPAY": {
                return new CelPayAccount();
            }
            case "MONESE": {
                return new MoneseAccount();
            }
            case "SATISPAY": {
                return new SatispayAccount();
            }
            case "TIKKIE": {
                return new TikkieAccount();
            }
            case "VERSE": {
                return new VerseAccount();
            }
            case "STRIKE": {
                return new StrikeAccount();
            }
            case "SWIFT": {
                return new SwiftAccount();
            }
            case "ACH_TRANSFER": {
                return new AchTransferAccount();
            }
            case "DOMESTIC_WIRE_TRANSFER": {
                return new DomesticWireTransferAccount();
            }
            case "CASH_APP": {
                return new CashAppAccount();
            }
            case "VENMO": {
                return new VenmoAccount();
            }
            case "PAYSAFE": {
                return new PaysafeAccount();
            }
            case "OK_PAY": {
                return new OKPayAccount();
            }
        }
        throw new RuntimeException("Not supported PaymentMethod: " + String.valueOf(paymentMethod));
    }
}

