/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.payment;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import haveno.common.util.ReflectionUtils;
import haveno.common.util.Utilities;
import haveno.core.locale.Country;
import haveno.core.locale.CountryUtil;
import haveno.core.locale.CurrencyUtil;
import haveno.core.locale.Res;
import haveno.core.locale.TradeCurrency;
import haveno.core.payment.CountryBasedPaymentAccount;
import haveno.core.payment.MoneyGramAccount;
import haveno.core.payment.PaymentAccount;
import haveno.core.payment.payload.PaymentAccountPayload;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PaymentAccountTypeAdapter
extends TypeAdapter<PaymentAccount> {
    private static final Logger log = LoggerFactory.getLogger(PaymentAccountTypeAdapter.class);
    private static final String[] JSON_COMMENTS = new String[]{"Do not manually edit the paymentMethodId field.", "Edit the salt field only if you are recreating a payment account on a new installation and wish to preserve the account age."};
    private final Class<? extends PaymentAccount> paymentAccountType;
    private final Class<? extends PaymentAccountPayload> paymentAccountPayloadType;
    private final Map<Field, Optional<Method>> fieldSettersMap;
    private final Predicate<Field> isExcludedField;

    public PaymentAccountTypeAdapter(Class<? extends PaymentAccount> paymentAccountType) {
        this(paymentAccountType, new String[0]);
    }

    public PaymentAccountTypeAdapter(Class<? extends PaymentAccount> paymentAccountType, String[] excludedFields) {
        this.paymentAccountType = paymentAccountType;
        this.paymentAccountPayloadType = this.getPaymentAccountPayloadType();
        this.isExcludedField = f -> Arrays.stream(excludedFields).anyMatch(e -> e.equals(f.getName()));
        this.fieldSettersMap = this.getFieldSetterMap();
    }

    @Override
    public void write(JsonWriter out, PaymentAccount account) throws IOException {
        out.beginObject();
        this.writeComments(out, account);
        out.name("paymentMethodId");
        out.value(account.getPaymentMethod().getId());
        this.writeInnerMutableFields(out, account);
        out.name("salt");
        out.value("");
        out.endObject();
    }

    private void writeComments(JsonWriter out, PaymentAccount account) throws IOException {
        out.name("_COMMENTS_");
        out.beginArray();
        for (String s2 : JSON_COMMENTS) {
            out.value(s2);
        }
        if (account.hasPaymentMethodWithId("SWIFT_ID")) {
            List<String> wrappedSwiftComments = Res.getWrappedAsList("payment.swift.info.account", 110);
            for (String line : wrappedSwiftComments) {
                out.value(line);
            }
        }
        out.endArray();
    }

    private void writeInnerMutableFields(JsonWriter out, PaymentAccount account) {
        if (account.hasMultipleCurrencies()) {
            this.writeTradeCurrenciesField(out, account);
            this.writeSelectedTradeCurrencyField(out, account);
        }
        this.fieldSettersMap.forEach((field, value) -> {
            try {
                if (value.isPresent()) {
                    log.debug("Append form with settable field: {} {} {} setter: {}", ReflectionUtils.getVisibilityModifierAsString(field), field.getType().getSimpleName(), field.getName(), value);
                    String fieldName = field.getName();
                    out.name(fieldName);
                    if (fieldName.equals("country")) {
                        out.value("your two letter country code");
                    } else {
                        out.value("your " + fieldName.toLowerCase());
                    }
                }
            }
            catch (Exception ex) {
                String errMsg = String.format("cannot create a new %s json form", account.getClass().getSimpleName());
                log.error(StringUtils.capitalize(errMsg) + ".", ex);
                throw new IllegalStateException("programmer error: " + errMsg);
            }
        });
    }

    private void writeTradeCurrenciesField(JsonWriter out, PaymentAccount account) {
        try {
            String fieldName = "tradeCurrencies";
            log.debug("Append form with non-settable field: {}", (Object)fieldName);
            out.name(fieldName);
            out.value("comma delimited currency code list, e.g., gbp,eur,jpy,usd");
        }
        catch (Exception ex) {
            String errMsg = String.format("cannot create a new %s json form", account.getClass().getSimpleName());
            log.error(StringUtils.capitalize(errMsg) + ".", ex);
            throw new IllegalStateException("programmer error: " + errMsg);
        }
    }

    private void writeSelectedTradeCurrencyField(JsonWriter out, PaymentAccount account) {
        try {
            String fieldName = "selectedTradeCurrency";
            log.debug("Append form with settable field: {}", (Object)fieldName);
            out.name(fieldName);
            out.value("primary trading currency code, e.g., eur");
        }
        catch (Exception ex) {
            String errMsg = String.format("cannot create a new %s json form", account.getClass().getSimpleName());
            log.error(StringUtils.capitalize(errMsg) + ".", ex);
            throw new IllegalStateException("programmer error: " + errMsg);
        }
    }

    @Override
    public PaymentAccount read(JsonReader in) throws IOException {
        PaymentAccount account = this.initNewPaymentAccount();
        in.beginObject();
        while (in.hasNext()) {
            String currentFieldName = in.nextName();
            if (this.didReadTradeCurrenciesField(in, account, currentFieldName) || this.didReadAcceptedCountryCodes(in, account, currentFieldName) || this.didReadSelectedTradeCurrencyField(in, account, currentFieldName) || this.didReadCommonField(in, account, currentFieldName) || this.didReadCountryField(in, account, currentFieldName)) continue;
            Optional<Field> field = this.fieldSettersMap.keySet().stream().filter(k -> k.getName().equals(currentFieldName)).findFirst();
            field.ifPresentOrElse(f -> this.invokeSetterMethod(account, (Field)f, in), () -> {
                throw new IllegalStateException(String.format("programmer error: cannot de-serialize json to a '%s'  because there is no %s field.", account.getClass().getSimpleName(), currentFieldName));
            });
        }
        in.endObject();
        return account;
    }

    private void invokeSetterMethod(PaymentAccount account, Field field, JsonReader jsonReader) {
        block6: {
            Optional<Method> setter = this.fieldSettersMap.get(field);
            if (setter.isPresent()) {
                try {
                    if (this.isSetterOnPaymentAccountClass(setter.get(), account)) {
                        setter.get().invoke((Object)account, this.nextStringOrNull(jsonReader));
                        break block6;
                    }
                    if (this.isSetterOnPaymentAccountPayloadClass(setter.get(), account)) {
                        setter.get().invoke((Object)account.getPaymentAccountPayload(), this.nextStringOrNull(jsonReader));
                        break block6;
                    }
                    String errMsg = String.format("programmer error: cannot de-serialize json to a '%s' using reflection because the setter method's declaring class was not found.", account.getClass().getSimpleName());
                    throw new IllegalStateException(errMsg);
                }
                catch (ReflectiveOperationException ex) {
                    ReflectionUtils.handleSetFieldValueError(account, field, ex);
                }
            } else {
                throw new IllegalStateException(String.format("programmer error: cannot de-serialize json to a '%s'  because field value cannot be set %s.", account.getClass().getSimpleName(), field.getName()));
            }
        }
    }

    private boolean isSetterOnPaymentAccountClass(Method setter, PaymentAccount account) {
        return ReflectionUtils.isSetterOnClass(setter, account.getClass());
    }

    private boolean isSetterOnPaymentAccountPayloadClass(Method setter, PaymentAccount account) {
        return ReflectionUtils.isSetterOnClass(setter, account.getPaymentAccountPayload().getClass()) || ReflectionUtils.isSetterOnClass(setter, account.getPaymentAccountPayload().getClass().getSuperclass());
    }

    private Map<Field, Optional<Method>> getFieldSetterMap() {
        List<Field> orderedFields = this.getOrderedFields();
        LinkedHashMap<Field, Optional<Method>> map = new LinkedHashMap<Field, Optional<Method>>();
        for (Field field : orderedFields) {
            Optional<Method> setter = ReflectionUtils.getSetterMethodForFieldInClassHierarchy(field, this.paymentAccountType).or(() -> ReflectionUtils.getSetterMethodForFieldInClassHierarchy(field, this.paymentAccountPayloadType));
            map.put(field, setter);
        }
        return Collections.unmodifiableMap(map);
    }

    private List<Field> getOrderedFields() {
        ArrayList<Field> fields = new ArrayList<Field>();
        ReflectionUtils.loadFieldListForClassHierarchy(fields, this.paymentAccountType, this.isExcludedField);
        ReflectionUtils.loadFieldListForClassHierarchy(fields, this.paymentAccountPayloadType, this.isExcludedField);
        fields.sort(Comparator.comparing(Field::getName));
        return fields;
    }

    private String nextStringOrNull(JsonReader in) {
        try {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            return in.nextString();
        }
        catch (IOException ex) {
            String errMsg = "cannot see next string in json reader";
            log.error(StringUtils.capitalize(errMsg) + ".", ex);
            throw new IllegalStateException("programmer error: " + errMsg);
        }
    }

    private Long nextLongOrNull(JsonReader in) {
        try {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            return in.nextLong();
        }
        catch (IOException ex) {
            String errMsg = "cannot see next long in json reader";
            log.error(StringUtils.capitalize(errMsg) + ".", ex);
            throw new IllegalStateException("programmer error: " + errMsg);
        }
    }

    private boolean didReadAcceptedCountryCodes(JsonReader in, PaymentAccount account, String fieldName) {
        if (!fieldName.equals("acceptedCountryCodes")) {
            return false;
        }
        String fieldValue = this.nextStringOrNull(in);
        List<String> countryCodes = PaymentAccount.commaDelimitedCodesToList.apply(fieldValue);
        ((CountryBasedPaymentAccount)account).setAcceptedCountries(CountryUtil.getCountries(countryCodes));
        return true;
    }

    private boolean didReadTradeCurrenciesField(JsonReader in, PaymentAccount account, String fieldName) {
        if (!fieldName.equals("tradeCurrencies")) {
            return false;
        }
        String fieldValue = this.nextStringOrNull(in);
        List<String> currencyCodes = PaymentAccount.commaDelimitedCodesToList.apply(fieldValue);
        Optional<List<TradeCurrency>> tradeCurrencies = this.getReconciledTradeCurrencies(currencyCodes, account);
        if (tradeCurrencies.isPresent()) {
            for (TradeCurrency tradeCurrency : tradeCurrencies.get()) {
                account.addCurrency(tradeCurrency);
            }
        } else {
            log.warn("No trade currencies were found in the {} account form.", (Object)account.getPaymentMethod().getDisplayString());
        }
        return true;
    }

    private Optional<List<TradeCurrency>> getReconciledTradeCurrencies(List<String> currencyCodes, PaymentAccount account) {
        return CurrencyUtil.getTradeCurrenciesInList(currencyCodes, account.getSupportedCurrencies());
    }

    private boolean didReadSelectedTradeCurrencyField(JsonReader in, PaymentAccount account, String fieldName) {
        if (!fieldName.equals("selectedTradeCurrency")) {
            return false;
        }
        String fieldValue = this.nextStringOrNull(in);
        if (fieldValue != null && !fieldValue.isEmpty()) {
            Optional<TradeCurrency> tradeCurrency = CurrencyUtil.getTradeCurrency(fieldValue.toUpperCase());
            if (tradeCurrency.isPresent()) {
                account.setSelectedTradeCurrency(tradeCurrency.get());
            } else {
                log.error("{} is not a valid trade currency code.", (Object)fieldValue);
            }
        }
        return true;
    }

    private boolean didReadCommonField(JsonReader in, PaymentAccount account, String fieldName) throws IOException {
        switch (fieldName) {
            case "_COMMENTS_": 
            case "paymentMethodId": {
                in.skipValue();
                return true;
            }
            case "accountName": {
                account.setAccountName(this.nextStringOrNull(in));
                return true;
            }
            case "salt": {
                String saltAsHex = this.nextStringOrNull(in);
                if (saltAsHex != null && !saltAsHex.trim().isEmpty()) {
                    account.setSalt(Utilities.decodeFromHex(saltAsHex));
                }
                return true;
            }
        }
        return false;
    }

    private boolean didReadCountryField(JsonReader in, PaymentAccount account, String fieldName) {
        if (!fieldName.equals("country")) {
            return false;
        }
        String countryCode = this.nextStringOrNull(in);
        Optional<Country> country = CountryUtil.findCountryByCode(countryCode);
        if (country.isPresent()) {
            if (account.isCountryBasedPaymentAccount()) {
                ((CountryBasedPaymentAccount)account).setCountry(country.get());
            } else if (account.hasPaymentMethodWithId("MONEY_GRAM")) {
                ((MoneyGramAccount)account).setCountry(country.get());
            } else {
                String errMsg = String.format("cannot set the country on a %s", this.paymentAccountType.getSimpleName());
                log.error(StringUtils.capitalize(errMsg) + ".");
                throw new IllegalStateException("programmer error: " + errMsg);
            }
            return true;
        }
        throw new IllegalArgumentException(String.format("'%s' is an invalid country code.", countryCode));
    }

    private Class<? extends PaymentAccountPayload> getPaymentAccountPayloadType() {
        try {
            Package pkg = PaymentAccountPayload.class.getPackage();
            return Class.forName(pkg.getName() + "." + this.paymentAccountType.getSimpleName() + "Payload");
        }
        catch (Exception ex) {
            String errMsg = String.format("cannot get the payload class for %s", this.paymentAccountType.getSimpleName());
            log.error(StringUtils.capitalize(errMsg) + ".", ex);
            throw new IllegalStateException("programmer error: " + errMsg);
        }
    }

    private PaymentAccount initNewPaymentAccount() {
        try {
            Constructor<? extends PaymentAccount> constructor = this.paymentAccountType.getDeclaredConstructor(new Class[0]);
            PaymentAccount paymentAccount = constructor.newInstance(new Object[0]);
            paymentAccount.init();
            return paymentAccount;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            String errMsg = String.format("cannot instantiate a new %s", this.paymentAccountType.getSimpleName());
            log.error(StringUtils.capitalize(errMsg) + ".", ex);
            throw new IllegalStateException("programmer error: " + errMsg);
        }
    }
}

