/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.payment;

import haveno.core.account.witness.AccountAgeWitnessService;
import haveno.core.locale.Country;
import haveno.core.locale.TradeCurrency;
import haveno.core.offer.Offer;
import haveno.core.payment.AchTransferAccount;
import haveno.core.payment.AdvancedCashAccount;
import haveno.core.payment.AliPayAccount;
import haveno.core.payment.AmazonGiftCardAccount;
import haveno.core.payment.AustraliaPayidAccount;
import haveno.core.payment.BankAccount;
import haveno.core.payment.BizumAccount;
import haveno.core.payment.CapitualAccount;
import haveno.core.payment.CashAppAccount;
import haveno.core.payment.CashDepositAccount;
import haveno.core.payment.CelPayAccount;
import haveno.core.payment.ChaseQuickPayAccount;
import haveno.core.payment.CountryBasedPaymentAccount;
import haveno.core.payment.DomesticWireTransferAccount;
import haveno.core.payment.F2FAccount;
import haveno.core.payment.FasterPaymentsAccount;
import haveno.core.payment.HalCashAccount;
import haveno.core.payment.IfscBasedAccount;
import haveno.core.payment.InteracETransferAccount;
import haveno.core.payment.JapanBankAccount;
import haveno.core.payment.MoneseAccount;
import haveno.core.payment.MoneyBeamAccount;
import haveno.core.payment.MoneyGramAccount;
import haveno.core.payment.NationalBankAccount;
import haveno.core.payment.NequiAccount;
import haveno.core.payment.PaxumAccount;
import haveno.core.payment.PayByMailAccount;
import haveno.core.payment.PayPalAccount;
import haveno.core.payment.PaymentAccount;
import haveno.core.payment.PaymentAccounts;
import haveno.core.payment.PayseraAccount;
import haveno.core.payment.PerfectMoneyAccount;
import haveno.core.payment.PixAccount;
import haveno.core.payment.PopmoneyAccount;
import haveno.core.payment.PromptPayAccount;
import haveno.core.payment.ReceiptValidator;
import haveno.core.payment.RevolutAccount;
import haveno.core.payment.SameBankAccount;
import haveno.core.payment.SatispayAccount;
import haveno.core.payment.SepaAccount;
import haveno.core.payment.SepaInstantAccount;
import haveno.core.payment.SpecificBanksAccount;
import haveno.core.payment.StrikeAccount;
import haveno.core.payment.SwiftAccount;
import haveno.core.payment.SwishAccount;
import haveno.core.payment.TikkieAccount;
import haveno.core.payment.TransferwiseAccount;
import haveno.core.payment.TransferwiseUsdAccount;
import haveno.core.payment.USPostalMoneyOrderAccount;
import haveno.core.payment.UpholdAccount;
import haveno.core.payment.VenmoAccount;
import haveno.core.payment.VerseAccount;
import haveno.core.payment.WeChatPayAccount;
import haveno.core.payment.WesternUnionAccount;
import haveno.core.payment.ZelleAccount;
import haveno.core.payment.payload.PaymentAccountPayload;
import haveno.core.payment.payload.PaymentMethod;
import haveno.core.user.User;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaymentAccountUtil {
    private static final Logger log = LoggerFactory.getLogger(PaymentAccountUtil.class);

    public static boolean isAnyPaymentAccountValidForOffer(Offer offer, Collection<PaymentAccount> paymentAccounts) {
        for (PaymentAccount paymentAccount : new ArrayList<PaymentAccount>(paymentAccounts)) {
            if (!PaymentAccountUtil.isPaymentAccountValidForOffer(offer, paymentAccount)) continue;
            return true;
        }
        return false;
    }

    public static ObservableList<PaymentAccount> getPossiblePaymentAccounts(Offer offer, Set<PaymentAccount> paymentAccounts, AccountAgeWitnessService accountAgeWitnessService) {
        ObservableList<PaymentAccount> result = FXCollections.observableArrayList();
        result.addAll(paymentAccounts.stream().filter(paymentAccount -> PaymentAccountUtil.isPaymentAccountValidForOffer(offer, paymentAccount)).filter(paymentAccount -> PaymentAccountUtil.isAmountValidForOffer(offer, paymentAccount, accountAgeWitnessService)).collect(Collectors.toList()));
        return result;
    }

    public static boolean isAmountValidForOffer(Offer offer, PaymentAccount paymentAccount, AccountAgeWitnessService accountAgeWitnessService) {
        boolean hasChargebackRisk = PaymentMethod.hasChargebackRisk(offer.getPaymentMethod(), offer.getCurrencyCode());
        boolean hasValidAccountAgeWitness = accountAgeWitnessService.getMyTradeLimit(paymentAccount, offer.getCurrencyCode(), offer.getMirroredDirection(), offer.hasBuyerAsTakerWithoutDeposit()) >= offer.getMinAmount().longValueExact();
        return !hasChargebackRisk || hasValidAccountAgeWitness;
    }

    public static String getInfoForMismatchingPaymentMethodLimits(Offer offer, PaymentAccount paymentAccount) {
        return "Payment methods have different trade limits or trade periods.\nOur local Payment method: " + paymentAccount.getPaymentMethod().toString() + "\nPayment method from offer: " + offer.getPaymentMethod().toString();
    }

    public static boolean isPaymentAccountValidForOffer(Offer offer, PaymentAccount paymentAccount) {
        return new ReceiptValidator(offer, paymentAccount).isValid();
    }

    public static Optional<PaymentAccount> getMostMaturePaymentAccountForOffer(Offer offer, Set<PaymentAccount> paymentAccounts, AccountAgeWitnessService service) {
        PaymentAccounts accounts = new PaymentAccounts(paymentAccounts, service);
        return Optional.ofNullable(accounts.getOldestPaymentAccountForOffer(offer));
    }

    @Nullable
    public static ArrayList<String> getAcceptedCountryCodes(PaymentAccount paymentAccount) {
        ArrayList<String> acceptedCountryCodes = null;
        if (paymentAccount instanceof SepaAccount) {
            acceptedCountryCodes = new ArrayList<String>(((SepaAccount)paymentAccount).getAcceptedCountryCodes());
        } else if (paymentAccount instanceof SepaInstantAccount) {
            acceptedCountryCodes = new ArrayList<String>(((SepaInstantAccount)paymentAccount).getAcceptedCountryCodes());
        } else if (paymentAccount instanceof CountryBasedPaymentAccount) {
            acceptedCountryCodes = new ArrayList();
            Country country = ((CountryBasedPaymentAccount)paymentAccount).getCountry();
            if (country != null) {
                acceptedCountryCodes.add(country.code);
            }
        }
        return acceptedCountryCodes;
    }

    public static List<TradeCurrency> getTradeCurrencies(PaymentMethod paymentMethod) {
        switch (paymentMethod.getId()) {
            case "ADVANCED_CASH": {
                return AdvancedCashAccount.SUPPORTED_CURRENCIES;
            }
            case "AMAZON_GIFT_CARD": {
                return AmazonGiftCardAccount.SUPPORTED_CURRENCIES;
            }
            case "CAPITUAL": {
                return CapitualAccount.SUPPORTED_CURRENCIES;
            }
            case "MONEY_GRAM": {
                return MoneyGramAccount.SUPPORTED_CURRENCIES;
            }
            case "PAXUM": {
                return PaxumAccount.SUPPORTED_CURRENCIES;
            }
            case "PAYSERA": {
                return PayseraAccount.SUPPORTED_CURRENCIES;
            }
            case "REVOLUT": {
                return RevolutAccount.SUPPORTED_CURRENCIES;
            }
            case "SWIFT": {
                return SwiftAccount.SUPPORTED_CURRENCIES;
            }
            case "TRANSFERWISE": {
                return TransferwiseAccount.SUPPORTED_CURRENCIES;
            }
            case "UPHOLD": {
                return UpholdAccount.SUPPORTED_CURRENCIES;
            }
            case "INTERAC_E_TRANSFER": {
                return InteracETransferAccount.SUPPORTED_CURRENCIES;
            }
            case "STRIKE": {
                return StrikeAccount.SUPPORTED_CURRENCIES;
            }
            case "TIKKIE": {
                return TikkieAccount.SUPPORTED_CURRENCIES;
            }
            case "ALI_PAY": {
                return AliPayAccount.SUPPORTED_CURRENCIES;
            }
            case "NEQUI": {
                return NequiAccount.SUPPORTED_CURRENCIES;
            }
            case "IMPS": 
            case "NEFT": 
            case "PAYTM": 
            case "RTGS": 
            case "UPI": {
                return IfscBasedAccount.SUPPORTED_CURRENCIES;
            }
            case "BIZUM": {
                return BizumAccount.SUPPORTED_CURRENCIES;
            }
            case "MONEY_BEAM": {
                return MoneyBeamAccount.SUPPORTED_CURRENCIES;
            }
            case "PIX": {
                return PixAccount.SUPPORTED_CURRENCIES;
            }
            case "SATISPAY": {
                return SatispayAccount.SUPPORTED_CURRENCIES;
            }
            case "CHASE_QUICK_PAY": {
                return ChaseQuickPayAccount.SUPPORTED_CURRENCIES;
            }
            case "US_POSTAL_MONEY_ORDER": {
                return USPostalMoneyOrderAccount.SUPPORTED_CURRENCIES;
            }
            case "VENMO": {
                return VenmoAccount.SUPPORTED_CURRENCIES;
            }
            case "PAYPAL": {
                return PayPalAccount.SUPPORTED_CURRENCIES;
            }
            case "JAPAN_BANK": {
                return JapanBankAccount.SUPPORTED_CURRENCIES;
            }
            case "WECHAT_PAY": {
                return WeChatPayAccount.SUPPORTED_CURRENCIES;
            }
            case "ZELLE": {
                return ZelleAccount.SUPPORTED_CURRENCIES;
            }
            case "AUSTRALIA_PAYID": {
                return AustraliaPayidAccount.SUPPORTED_CURRENCIES;
            }
            case "PERFECT_MONEY": {
                return PerfectMoneyAccount.SUPPORTED_CURRENCIES;
            }
            case "HAL_CASH": {
                return HalCashAccount.SUPPORTED_CURRENCIES;
            }
            case "SWISH": {
                return SwishAccount.SUPPORTED_CURRENCIES;
            }
            case "CASH_APP": {
                return CashAppAccount.SUPPORTED_CURRENCIES;
            }
            case "POPMONEY": {
                return PopmoneyAccount.SUPPORTED_CURRENCIES;
            }
            case "PROMPT_PAY": {
                return PromptPayAccount.SUPPORTED_CURRENCIES;
            }
            case "SEPA": {
                return SepaAccount.SUPPORTED_CURRENCIES;
            }
            case "SEPA_INSTANT": {
                return SepaInstantAccount.SUPPORTED_CURRENCIES;
            }
            case "PAY_BY_MAIL": {
                return PayByMailAccount.SUPPORTED_CURRENCIES;
            }
            case "F2F": {
                return F2FAccount.SUPPORTED_CURRENCIES;
            }
            case "NATIONAL_BANK": {
                return NationalBankAccount.SUPPORTED_CURRENCIES;
            }
            case "SAME_BANK": {
                return SameBankAccount.SUPPORTED_CURRENCIES;
            }
            case "SPECIFIC_BANKS": {
                return SpecificBanksAccount.SUPPORTED_CURRENCIES;
            }
            case "CASH_DEPOSIT": {
                return CashDepositAccount.SUPPORTED_CURRENCIES;
            }
            case "WESTERN_UNION": {
                return WesternUnionAccount.SUPPORTED_CURRENCIES;
            }
            case "FASTER_PAYMENTS": {
                return FasterPaymentsAccount.SUPPORTED_CURRENCIES;
            }
            case "DOMESTIC_WIRE_TRANSFER": {
                return DomesticWireTransferAccount.SUPPORTED_CURRENCIES;
            }
            case "ACH_TRANSFER": {
                return AchTransferAccount.SUPPORTED_CURRENCIES;
            }
            case "CELPAY": {
                return CelPayAccount.SUPPORTED_CURRENCIES;
            }
            case "MONESE": {
                return MoneseAccount.SUPPORTED_CURRENCIES;
            }
            case "TRANSFERWISE_USD": {
                return TransferwiseUsdAccount.SUPPORTED_CURRENCIES;
            }
            case "VERSE": {
                return VerseAccount.SUPPORTED_CURRENCIES;
            }
        }
        return Collections.emptyList();
    }

    public static boolean supportsCurrency(PaymentMethod paymentMethod, TradeCurrency selectedTradeCurrency) {
        return PaymentAccountUtil.getTradeCurrencies(paymentMethod).stream().anyMatch(tradeCurrency -> tradeCurrency.equals(selectedTradeCurrency));
    }

    @Nullable
    public static List<String> getAcceptedBanks(PaymentAccount paymentAccount) {
        ArrayList<String> acceptedBanks = null;
        if (paymentAccount instanceof SpecificBanksAccount) {
            acceptedBanks = new ArrayList<String>(((SpecificBanksAccount)paymentAccount).getAcceptedBanks());
        } else if (paymentAccount instanceof SameBankAccount) {
            acceptedBanks = new ArrayList();
            acceptedBanks.add(((SameBankAccount)paymentAccount).getBankId());
        }
        return acceptedBanks;
    }

    @Nullable
    public static String getBankId(PaymentAccount paymentAccount) {
        return paymentAccount instanceof BankAccount ? ((BankAccount)((Object)paymentAccount)).getBankId() : null;
    }

    @Nullable
    public static String getCountryCode(PaymentAccount paymentAccount) {
        if (paymentAccount instanceof CountryBasedPaymentAccount) {
            Country country = ((CountryBasedPaymentAccount)paymentAccount).getCountry();
            return country != null ? country.code : null;
        }
        return null;
    }

    public static boolean isCryptoCurrencyAccount(PaymentAccount paymentAccount) {
        return paymentAccount != null && paymentAccount.getPaymentMethod().equals(PaymentMethod.BLOCK_CHAINS) || paymentAccount != null && paymentAccount.getPaymentMethod().equals(PaymentMethod.BLOCK_CHAINS_INSTANT);
    }

    public static Optional<PaymentAccount> findPaymentAccount(PaymentAccountPayload paymentAccountPayload, User user) {
        return user.getPaymentAccountsAsObservable().stream().filter(e -> e.getPaymentAccountPayload().equals(paymentAccountPayload)).findAny();
    }
}

