/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.payment;

import haveno.core.api.model.PaymentAccountFormField;
import haveno.core.locale.TradeCurrency;
import haveno.core.locale.TraditionalCurrency;
import haveno.core.payment.PaymentAccount;
import haveno.core.payment.payload.PaymentAccountPayload;
import haveno.core.payment.payload.PaymentMethod;
import haveno.core.payment.payload.PaysafeAccountPayload;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class PaysafeAccount
extends PaymentAccount {
    private static final List<PaymentAccountFormField.FieldId> INPUT_FIELD_IDS = List.of(PaymentAccountFormField.FieldId.ACCOUNT_NAME, PaymentAccountFormField.FieldId.EMAIL, PaymentAccountFormField.FieldId.TRADE_CURRENCIES, PaymentAccountFormField.FieldId.SALT);
    public static final List<TradeCurrency> SUPPORTED_CURRENCIES = List.of(new TraditionalCurrency("AED"), new TraditionalCurrency("ARS"), new TraditionalCurrency("AUD"), new TraditionalCurrency("BGN"), new TraditionalCurrency("BRL"), new TraditionalCurrency("CAD"), new TraditionalCurrency("CHF"), new TraditionalCurrency("CZK"), new TraditionalCurrency("DKK"), new TraditionalCurrency("EGP"), new TraditionalCurrency("EUR"), new TraditionalCurrency("GBP"), new TraditionalCurrency("GEL"), new TraditionalCurrency("HUF"), new TraditionalCurrency("ILS"), new TraditionalCurrency("INR"), new TraditionalCurrency("JPY"), new TraditionalCurrency("ISK"), new TraditionalCurrency("KWD"), new TraditionalCurrency("KRW"), new TraditionalCurrency("MXN"), new TraditionalCurrency("NOK"), new TraditionalCurrency("NZD"), new TraditionalCurrency("PEN"), new TraditionalCurrency("PHP"), new TraditionalCurrency("PLN"), new TraditionalCurrency("RON"), new TraditionalCurrency("RSD"), new TraditionalCurrency("RUB"), new TraditionalCurrency("SAR"), new TraditionalCurrency("SEK"), new TraditionalCurrency("TRY"), new TraditionalCurrency("USD"), new TraditionalCurrency("UYU"));

    public PaysafeAccount() {
        super(PaymentMethod.PAYSAFE);
    }

    @Override
    protected PaymentAccountPayload createPayload() {
        return new PaysafeAccountPayload(this.paymentMethod.getId(), this.id);
    }

    @Override
    @NotNull
    public List<TradeCurrency> getSupportedCurrencies() {
        return SUPPORTED_CURRENCIES;
    }

    @Override
    @NotNull
    public List<PaymentAccountFormField.FieldId> getInputFieldIds() {
        return INPUT_FIELD_IDS;
    }

    public void setEmail(String accountId) {
        ((PaysafeAccountPayload)this.paymentAccountPayload).setEmail(accountId);
    }

    public String getEmail() {
        return ((PaysafeAccountPayload)this.paymentAccountPayload).getEmail();
    }

    @Override
    protected PaymentAccountFormField getEmptyFormField(PaymentAccountFormField.FieldId fieldId) {
        PaymentAccountFormField field = super.getEmptyFormField(fieldId);
        if (field.getId() == PaymentAccountFormField.FieldId.TRADE_CURRENCIES) {
            field.setValue("");
        }
        return field;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PaysafeAccount)) {
            return false;
        }
        PaysafeAccount other = (PaysafeAccount)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof PaysafeAccount;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

